/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemFeePrice;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@DiscriminatorColumn(name="TYPE")
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_DISC_ITEM_FEE_PRICE")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(friendlyName="baseDiscreteOrderItemFreePrice")
public class DiscreteOrderItemFeePriceImpl
implements DiscreteOrderItemFeePrice {
    public static final Log LOG = LogFactory.getLog(DiscreteOrderItemFeePriceImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="DiscreteOrderItemFeePriceId", strategy=GenerationType.TABLE)
    @TableGenerator(name="DiscreteOrderItemFeePriceId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="DiscreteOrderItemFeePriceImpl", allocationSize=50)
    @Column(name="DISC_ITEM_FEE_PRICE_ID")
    protected Long id;
    @ManyToOne(targetEntity=DiscreteOrderItemImpl.class, optional=false)
    @JoinColumn(name="ORDER_ITEM_ID")
    protected DiscreteOrderItem discreteOrderItem;
    @Column(name="AMOUNT", precision=19, scale=5)
    @AdminPresentation(friendlyName="Amount", order=2, group="Description", prominent=true)
    protected BigDecimal amount;
    @Column(name="NAME")
    @AdminPresentation(friendlyName="Name", order=1, group="Description", prominent=true)
    private String name;
    @Column(name="REPORTING_CODE")
    @AdminPresentation(friendlyName="Reporting Code", order=3, group="Description", prominent=true)
    private String reportingCode;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public DiscreteOrderItem getDiscreteOrderItem() {
        return this.discreteOrderItem;
    }

    @Override
    public void setDiscreteOrderItem(DiscreteOrderItem discreteOrderItem) {
        this.discreteOrderItem = discreteOrderItem;
    }

    @Override
    public Money getAmount() {
        return this.amount == null ? null : new Money(this.amount);
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = Money.toAmount((Money)amount);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getReportingCode() {
        return this.reportingCode;
    }

    @Override
    public void setReportingCode(String reportingCode) {
        this.reportingCode = reportingCode;
    }

    public void checkCloneable(DiscreteOrderItemFeePrice discreteFeePrice) throws CloneNotSupportedException, SecurityException, NoSuchMethodException {
        Method cloneMethod = discreteFeePrice.getClass().getMethod("clone", new Class[0]);
        if (cloneMethod.getDeclaringClass().getName().startsWith("org.broadleafcommerce") && !discreteFeePrice.getClass().getName().startsWith("org.broadleafcommerce")) {
            throw new CloneNotSupportedException("Custom extensions and implementations should implement clone in order to guarantee split and merge operations are performed accurately");
        }
    }

    @Override
    public DiscreteOrderItemFeePrice clone() {
        DiscreteOrderItemFeePrice clone;
        try {
            clone = (DiscreteOrderItemFeePrice)Class.forName(this.getClass().getName()).newInstance();
            try {
                this.checkCloneable(clone);
            }
            catch (CloneNotSupportedException e) {
                LOG.warn((Object)("Clone implementation missing in inheritance hierarchy outside of Broadleaf: " + clone.getClass().getName()), (Throwable)e);
            }
            clone.setAmount(this.getAmount());
            clone.setName(this.getName());
            clone.setReportingCode(this.getReportingCode());
            clone.setDiscreteOrderItem(this.getDiscreteOrderItem());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.discreteOrderItem == null ? 0 : this.discreteOrderItem.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.reportingCode == null ? 0 : this.reportingCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscreteOrderItemFeePriceImpl other = (DiscreteOrderItemFeePriceImpl)obj;
        if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
            return false;
        }
        if (this.discreteOrderItem == null ? other.discreteOrderItem != null : !this.discreteOrderItem.equals(other.discreteOrderItem)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.reportingCode == null ? other.reportingCode != null : !this.reportingCode.equals(other.reportingCode));
    }
}

