/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.advice;

import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.pricing.service.PricingService;
import org.broadleafcommerce.core.pricing.service.advice.PricingExecutionManager;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component(value="blPricingExecutionManager")
public class PricingExecutionManagerImpl
implements PricingExecutionManager,
Ordered {
    private static final Log LOG = LogFactory.getLog(PricingExecutionManagerImpl.class);
    private static final ThreadLocal<Order> UNIQUE_ORDER = new ThreadLocal();
    private int order;
    @Resource(name="blPricingService")
    private PricingService pricingService;
    @Resource(name="blOrderDao")
    private OrderDao orderDao;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void clearCache() {
        UNIQUE_ORDER.remove();
    }

    @Override
    public void executePricing(Order order) {
        UNIQUE_ORDER.set(order);
        LOG.debug((Object)("Context order reset : order id " + order.getId()));
    }

    public Order getLatestItem() {
        Order order = UNIQUE_ORDER.get();
        if (order != null) {
            LOG.debug((Object)("Latest context order retrieved : order id " + order.getId()));
        }
        return order;
    }

    public Object priceOrder(ProceedingJoinPoint call) throws Throwable {
        Object returnValue;
        this.clearCache();
        boolean exceptionOccurred = false;
        try {
            returnValue = call.proceed();
        }
        catch (Throwable e) {
            exceptionOccurred = true;
            throw e;
        }
        finally {
            Order orderItem = this.getLatestItem();
            this.clearCache();
            if (orderItem != null && !exceptionOccurred) {
                orderItem = this.pricingService.executePricing(orderItem);
                orderItem = this.orderDao.save(orderItem);
                LOG.debug((Object)("Context order priced : order id " + orderItem.getId()));
            }
        }
        return returnValue;
    }
}

