/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.processor.AbstractBaseProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.manipulation.BundleOrderItemSplitContainer;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemSplitContainer;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.compass.core.util.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="blOrderOfferProcessor")
public class OrderOfferProcessorImpl
extends AbstractBaseProcessor
implements OrderOfferProcessor {
    private static final Log LOG = LogFactory.getLog(OrderOfferProcessorImpl.class);
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;
    @Resource(name="blCartService")
    protected CartService cartService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fulfillmentGroupItemDao;
    @Resource(name="blPromotableItemFactory")
    protected PromotableItemFactory promotableItemFactory;

    @Override
    public void filterOrderLevelOffer(PromotableOrder order, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, Offer offer) {
        CandidatePromotionItems candidates;
        boolean orderLevelQualification;
        block6: {
            if (offer.getDiscountType().getType().equals(OfferDiscountType.FIX_PRICE.getType())) {
                LOG.warn((Object)("Offers of type ORDER may not have a discount type of FIX_PRICE. Ignoring order offer (name=" + offer.getName() + ")"));
                return;
            }
            orderLevelQualification = false;
            if (this.couldOfferApplyToOrder(offer, order)) {
                orderLevelQualification = true;
            } else {
                for (PromotableOrderItem discreteOrderItem : order.getDiscountableDiscreteOrderItems(offer.getApplyDiscountToSalePrice())) {
                    if (!this.couldOfferApplyToOrder(offer, order, discreteOrderItem)) continue;
                    orderLevelQualification = true;
                    break block6;
                }
                for (PromotableFulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                    if (!this.couldOfferApplyToOrder(offer, order, fulfillmentGroup)) continue;
                    orderLevelQualification = true;
                    break;
                }
            }
        }
        if (orderLevelQualification && (candidates = this.couldOfferApplyToOrderItems(offer, order.getDiscountableDiscreteOrderItems(offer.getApplyDiscountToSalePrice()))).isMatchedQualifier()) {
            PromotableCandidateOrderOffer candidateOffer = this.createCandidateOrderOffer(order, qualifiedOrderOffers, offer);
            candidateOffer.getCandidateQualifiersMap().putAll(candidates.getCandidateQualifiersMap());
        }
    }

    @Override
    public boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order) {
        return this.couldOfferApplyToOrder(offer, order, null, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order, PromotableOrderItem discreteOrderItem) {
        return this.couldOfferApplyToOrder(offer, order, discreteOrderItem, null);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order, PromotableFulfillmentGroup fulfillmentGroup) {
        return this.couldOfferApplyToOrder(offer, order, null, fulfillmentGroup);
    }

    protected boolean couldOfferApplyToOrder(Offer offer, PromotableOrder order, PromotableOrderItem discreteOrderItem, PromotableFulfillmentGroup fulfillmentGroup) {
        boolean appliesToItem = false;
        String rule = null;
        if (offer.getAppliesToOrderRules() != null && offer.getAppliesToOrderRules().trim().length() != 0) {
            rule = offer.getAppliesToOrderRules();
        } else {
            OfferRule orderRule = offer.getOfferMatchRules().get(OfferRuleType.ORDER.getType());
            if (orderRule != null) {
                rule = orderRule.getMatchRule();
            }
        }
        if (rule != null) {
            Boolean expressionOutcome;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("order", order.getDelegate());
            vars.put("offer", offer);
            if (fulfillmentGroup != null) {
                vars.put("fulfillmentGroup", fulfillmentGroup.getDelegate());
            }
            if (discreteOrderItem != null) {
                vars.put("discreteOrderItem", discreteOrderItem.getDelegate());
            }
            if ((expressionOutcome = this.executeExpression(rule, vars)) != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    protected PromotableCandidateOrderOffer createCandidateOrderOffer(PromotableOrder order, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, Offer offer) {
        CandidateOrderOffer candidateOffer = this.offerDao.createCandidateOrderOffer();
        candidateOffer.setOrder(order.getDelegate());
        candidateOffer.setOffer(offer);
        PromotableCandidateOrderOffer promotableCandidateOrderOffer = this.promotableItemFactory.createPromotableCandidateOrderOffer(candidateOffer, order);
        qualifiedOrderOffers.add(promotableCandidateOrderOffer);
        return promotableCandidateOrderOffer;
    }

    @Override
    public List<PromotableCandidateOrderOffer> removeTrailingNotCombinableOrderOffers(List<PromotableCandidateOrderOffer> candidateOffers) {
        ArrayList<PromotableCandidateOrderOffer> remainingCandidateOffers = new ArrayList<PromotableCandidateOrderOffer>();
        int offerCount = 0;
        for (PromotableCandidateOrderOffer candidateOffer : candidateOffers) {
            if (offerCount == 0) {
                remainingCandidateOffers.add(candidateOffer);
            } else {
                boolean treatAsNewFormat = false;
                if (candidateOffer.getOffer().getTreatAsNewFormat() != null && candidateOffer.getOffer().getTreatAsNewFormat().booleanValue()) {
                    treatAsNewFormat = true;
                }
                if (!treatAsNewFormat && candidateOffer.getOffer().isCombinableWithOtherOffers() || treatAsNewFormat && (candidateOffer.getOffer().isTotalitarianOffer() == null || !candidateOffer.getOffer().isTotalitarianOffer().booleanValue())) {
                    remainingCandidateOffers.add(candidateOffer);
                }
            }
            ++offerCount;
        }
        return remainingCandidateOffers;
    }

    @Override
    public boolean applyAllOrderOffers(List<PromotableCandidateOrderOffer> orderOffers, PromotableOrder order) {
        boolean orderOffersApplied = false;
        Iterator<PromotableCandidateOrderOffer> orderOfferIterator = orderOffers.iterator();
        while (orderOfferIterator.hasNext()) {
            PromotableCandidateOrderOffer orderOffer = orderOfferIterator.next();
            if (orderOffer.getOffer().getTreatAsNewFormat() == null || !orderOffer.getOffer().getTreatAsNewFormat().booleanValue()) {
                if (!orderOffer.getOffer().isStackable() && order.isHasOrderAdjustments()) continue;
                boolean alreadyContainsNotCombinableOfferAtAnyLevel = order.isNotCombinableOfferAppliedAtAnyLevel();
                this.applyOrderOffer(order, orderOffer);
                orderOffersApplied = true;
                if (orderOffer.getOffer().isCombinableWithOtherOffers() && !alreadyContainsNotCombinableOfferAtAnyLevel) continue;
                if (orderOffersApplied = this.compareAndAdjustOrderAndItemOffers(order, orderOffersApplied)) break;
                orderOfferIterator.remove();
                continue;
            }
            if (order.containsNotStackableOrderOffer() && order.isHasOrderAdjustments()) continue;
            boolean alreadyContainsTotalitarianOffer = order.isTotalitarianOfferApplied();
            this.applyOrderOffer(order, orderOffer);
            orderOffersApplied = true;
            if (orderOffer.getOffer().isTotalitarianOffer() != null && orderOffer.getOffer().isTotalitarianOffer().booleanValue() || alreadyContainsTotalitarianOffer) {
                if (orderOffersApplied = this.compareAndAdjustOrderAndItemOffers(order, orderOffersApplied)) break;
                orderOfferIterator.remove();
                continue;
            }
            if (orderOffer.getOffer().isCombinableWithOtherOffers()) continue;
            break;
        }
        return orderOffersApplied;
    }

    @Override
    public void initializeBundleSplitItems(PromotableOrder order) {
        List<OrderItem> basicOrderItems = order.getDelegate().getOrderItems();
        for (OrderItem basicOrderItem : basicOrderItems) {
            if (!(basicOrderItem instanceof BundleOrderItem)) continue;
            BundleOrderItem bundleOrderItem = (BundleOrderItem)basicOrderItem;
            List<BundleOrderItem> searchHit = order.searchBundleSplitItems(bundleOrderItem);
            if (searchHit == null) {
                searchHit = new ArrayList<BundleOrderItem>();
                BundleOrderItemSplitContainer container = new BundleOrderItemSplitContainer();
                container.setKey(bundleOrderItem);
                container.setSplitItems(searchHit);
                order.getBundleSplitItems().add(container);
            }
            long count = 0L;
            if (bundleOrderItem.getQuantity() > 1) {
                for (int j = 1; j <= bundleOrderItem.getQuantity(); ++j) {
                    BundleOrderItem temp = (BundleOrderItem)bundleOrderItem.clone();
                    temp.setQuantity(1);
                    temp.setId(++count);
                    searchHit.add(temp);
                }
                continue;
            }
            BundleOrderItem temp = (BundleOrderItem)bundleOrderItem.clone();
            temp.setId(++count);
            searchHit.add(temp);
        }
    }

    @Override
    public void initializeSplitItems(PromotableOrder order) {
        List<PromotableOrderItem> items = order.getDiscountableDiscreteOrderItems();
        for (PromotableOrderItem item : items) {
            ArrayList<PromotableOrderItem> temp = new ArrayList<PromotableOrderItem>();
            temp.add(item);
            OrderItemSplitContainer container = new OrderItemSplitContainer();
            container.setKey(item.getDelegate());
            container.setSplitItems(temp);
            order.getSplitItems().add(container);
        }
    }

    protected boolean compareAndAdjustOrderAndItemOffers(PromotableOrder order, boolean orderOffersApplied) {
        if (order.getAdjustmentPrice().greaterThanOrEqual(order.calculateOrderItemsCurrentPrice())) {
            order.removeAllOrderAdjustments();
            orderOffersApplied = false;
        } else {
            order.removeAllItemAdjustments();
            this.gatherCart(order);
            this.initializeSplitItems(order);
        }
        return orderOffersApplied;
    }

    @Override
    public void gatherCart(PromotableOrder promotableOrder) {
        Order order = promotableOrder.getDelegate();
        try {
            if (!CollectionUtils.isEmpty(order.getFulfillmentGroups())) {
                this.gatherFulfillmentGroupLinkedDiscreteOrderItems(order);
                this.gatherFulfillmentGroupLinkedBundleOrderItems(order);
            } else {
                this.gatherOrderLinkedDiscreteOrderItems(order);
                this.gatherOrderLinkedBundleOrderItems(order);
            }
        }
        catch (PricingException e) {
            throw new RuntimeException("Could not gather the cart", e);
        }
        promotableOrder.resetDiscreteOrderItems();
    }

    protected void gatherOrderLinkedBundleOrderItems(Order order) throws PricingException {
        HashMap<String, BundleOrderItem> gatherBundle = new HashMap<String, BundleOrderItem>();
        ArrayList<BundleOrderItem> bundlesToRemove = new ArrayList<BundleOrderItem>();
        for (OrderItem orderItem : order.getOrderItems()) {
            if (!(orderItem instanceof BundleOrderItem)) continue;
            String identifier = this.getBundleOrderItemIdentifier((BundleOrderItem)orderItem);
            BundleOrderItem retrieved = (BundleOrderItem)gatherBundle.get(identifier);
            if (retrieved == null) {
                gatherBundle.put(identifier, (BundleOrderItem)orderItem);
                continue;
            }
            retrieved.setQuantity(retrieved.getQuantity() + orderItem.getQuantity());
            bundlesToRemove.add((BundleOrderItem)orderItem);
        }
        for (BundleOrderItem bundleOrderItem : gatherBundle.values()) {
            this.orderItemService.saveOrderItem(bundleOrderItem);
        }
        for (BundleOrderItem bundleOrderItem : bundlesToRemove) {
            this.cartService.removeItemFromOrder(order, bundleOrderItem, false);
        }
    }

    protected void gatherOrderLinkedDiscreteOrderItems(Order order) throws PricingException {
        ArrayList<DiscreteOrderItem> itemsToRemove = new ArrayList<DiscreteOrderItem>();
        HashMap<String, OrderItem> gatheredItem = new HashMap<String, OrderItem>();
        for (OrderItem orderItem : order.getOrderItems()) {
            if (orderItem instanceof BundleOrderItem) {
                for (DiscreteOrderItem discreteOrderItem : ((BundleOrderItem)orderItem).getDiscreteOrderItems()) {
                    this.gatherOrderLinkedDiscreteOrderItem(itemsToRemove, gatheredItem, discreteOrderItem, String.valueOf(orderItem.getId()));
                }
                continue;
            }
            this.gatherOrderLinkedDiscreteOrderItem(itemsToRemove, gatheredItem, (DiscreteOrderItem)orderItem, null);
        }
        for (OrderItem orderItem : gatheredItem.values()) {
            this.orderItemService.saveOrderItem(orderItem);
        }
        for (DiscreteOrderItem discreteOrderItem : itemsToRemove) {
            if (discreteOrderItem.getBundleOrderItem() == null) {
                this.cartService.removeItemFromOrder(order, discreteOrderItem, false);
                continue;
            }
            this.cartService.removeItemFromBundle(order, discreteOrderItem.getBundleOrderItem(), discreteOrderItem, false);
        }
    }

    protected void gatherFulfillmentGroupLinkedBundleOrderItems(Order order) throws PricingException {
        ArrayList<BundleOrderItem> bundlesToRemove = new ArrayList<BundleOrderItem>();
        HashMap gatherBundle = new HashMap();
        for (FulfillmentGroup group : order.getFulfillmentGroups()) {
            HashMap<String, Object[]> gatheredItem = (HashMap<String, Object[]>)gatherBundle.get(group.getId());
            if (gatheredItem == null) {
                gatheredItem = new HashMap<String, Object[]>();
                gatherBundle.put(group.getId(), gatheredItem);
            }
            for (FulfillmentGroupItem fgItem : group.getFulfillmentGroupItems()) {
                OrderItem orderItem = fgItem.getOrderItem();
                if (!(orderItem instanceof BundleOrderItem)) continue;
                String identifier = this.getBundleOrderItemIdentifier((BundleOrderItem)orderItem);
                Object[] gatheredOrderItem = (Object[])gatheredItem.get(identifier);
                if (gatheredOrderItem == null) {
                    gatheredItem.put(identifier, new Object[]{orderItem, fgItem});
                    continue;
                }
                ((OrderItem)gatheredOrderItem[0]).setQuantity(((OrderItem)gatheredOrderItem[0]).getQuantity() + orderItem.getQuantity());
                ((FulfillmentGroupItem)gatheredOrderItem[1]).setQuantity(((FulfillmentGroupItem)gatheredOrderItem[1]).getQuantity() + fgItem.getQuantity());
                bundlesToRemove.add((BundleOrderItem)orderItem);
            }
        }
        for (Map values : gatherBundle.values()) {
            for (Object[] item : values.values()) {
                this.orderItemService.saveOrderItem((OrderItem)item[0]);
                this.fulfillmentGroupItemDao.save((FulfillmentGroupItem)item[1]);
            }
        }
        for (BundleOrderItem orderItem : bundlesToRemove) {
            this.cartService.removeItemFromOrder(order, orderItem, false);
        }
    }

    protected void gatherFulfillmentGroupLinkedDiscreteOrderItems(Order order) throws PricingException {
        ArrayList<DiscreteOrderItem> itemsToRemove = new ArrayList<DiscreteOrderItem>();
        HashMap<Long, HashMap<String, Object[]>> gatherMap = new HashMap<Long, HashMap<String, Object[]>>();
        for (FulfillmentGroup group : order.getFulfillmentGroups()) {
            HashMap<String, Object[]> gatheredItem = (HashMap<String, Object[]>)gatherMap.get(group.getId());
            if (gatheredItem == null) {
                gatheredItem = new HashMap<String, Object[]>();
                gatherMap.put(group.getId(), gatheredItem);
            }
            for (FulfillmentGroupItem fgItem : group.getFulfillmentGroupItems()) {
                OrderItem orderItem = fgItem.getOrderItem();
                if (orderItem instanceof BundleOrderItem) {
                    for (DiscreteOrderItem discreteOrderItem : ((BundleOrderItem)orderItem).getDiscreteOrderItems()) {
                        this.gatherFulfillmentGroupLinkedDiscreteOrderItem(itemsToRemove, gatheredItem, fgItem, discreteOrderItem, String.valueOf(orderItem.getId()));
                    }
                    continue;
                }
                this.gatherFulfillmentGroupLinkedDiscreteOrderItem(itemsToRemove, gatheredItem, fgItem, (DiscreteOrderItem)orderItem, null);
            }
        }
        for (Map values : gatherMap.values()) {
            for (Object[] item : values.values()) {
                this.orderItemService.saveOrderItem((OrderItem)item[0]);
                this.fulfillmentGroupItemDao.save((FulfillmentGroupItem)item[1]);
            }
        }
        for (DiscreteOrderItem orderItem : itemsToRemove) {
            if (orderItem.getBundleOrderItem() == null) {
                this.cartService.removeItemFromOrder(order, orderItem, false);
                continue;
            }
            this.cartService.removeItemFromBundle(order, orderItem.getBundleOrderItem(), orderItem, false);
        }
    }

    protected String getBundleOrderItemIdentifier(BundleOrderItem bundleOrderItem) {
        StringBuilder identifier = new StringBuilder();
        for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
            identifier.append(discreteOrderItem.getSku());
            identifier.append(discreteOrderItem.getQuantity());
            identifier.append(discreteOrderItem.getPrice());
        }
        return identifier.toString();
    }

    protected void gatherOrderLinkedDiscreteOrderItem(List<DiscreteOrderItem> itemsToRemove, Map<String, OrderItem> gatheredItem, DiscreteOrderItem orderItem, String extraIdentifier) {
        if (CollectionUtils.isEmpty(orderItem.getOrderItemAdjustments())) {
            OrderItem gatheredOrderItem;
            String identifier = String.valueOf(orderItem.getSku().getId());
            identifier = identifier + '_' + orderItem.getPrice().stringValue();
            if (extraIdentifier != null) {
                identifier = identifier + '_' + extraIdentifier;
            }
            if ((gatheredOrderItem = gatheredItem.get(identifier)) == null) {
                gatheredItem.put(identifier, orderItem);
                return;
            }
            gatheredOrderItem.setQuantity(gatheredOrderItem.getQuantity() + orderItem.getQuantity());
            itemsToRemove.add(orderItem);
        }
    }

    protected void gatherFulfillmentGroupLinkedDiscreteOrderItem(List<DiscreteOrderItem> itemsToRemove, Map<String, Object[]> gatheredItem, FulfillmentGroupItem fgItem, DiscreteOrderItem orderItem, String extraIdentifier) {
        if (CollectionUtils.isEmpty(orderItem.getOrderItemAdjustments())) {
            Object[] gatheredOrderItem;
            String identifier = String.valueOf(orderItem.getSku().getId());
            identifier = identifier + '_' + orderItem.getPrice().stringValue();
            if (extraIdentifier != null) {
                identifier = identifier + '_' + extraIdentifier;
            }
            if ((gatheredOrderItem = gatheredItem.get(identifier)) == null) {
                gatheredItem.put(identifier, new Object[]{orderItem, fgItem});
                return;
            }
            ((OrderItem)gatheredOrderItem[0]).setQuantity(((OrderItem)gatheredOrderItem[0]).getQuantity() + orderItem.getQuantity());
            ((FulfillmentGroupItem)gatheredOrderItem[1]).setQuantity(((FulfillmentGroupItem)gatheredOrderItem[1]).getQuantity() + fgItem.getQuantity());
            itemsToRemove.add(orderItem);
        }
    }

    protected void applyOrderOffer(PromotableOrder order, PromotableCandidateOrderOffer orderOffer) {
        OrderAdjustment orderAdjustment = this.offerDao.createOrderAdjustment();
        orderAdjustment.init(order.getDelegate(), orderOffer.getOffer(), orderOffer.getOffer().getName());
        PromotableOrderAdjustment promotableOrderAdjustment = this.promotableItemFactory.createPromotableOrderAdjustment(orderAdjustment, order);
        order.addOrderAdjustments(promotableOrderAdjustment);
    }

    protected void mergeSplitItems(PromotableOrder order) {
        try {
            this.mergeSplitDiscreteOrderItems(order);
            this.mergeSplitBundleOrderItems(order);
            order.resetDiscreteOrderItems();
            for (PromotableOrderItem myItem : order.getDiscountableDiscreteOrderItems()) {
                if (!myItem.isHasOrderItemAdjustments()) continue;
                for (OrderItemAdjustment adjustment : myItem.getDelegate().getOrderItemAdjustments()) {
                    PromotableOrderItemAdjustment promotableOrderItemAdjustment = this.promotableItemFactory.createPromotableOrderItemAdjustment(adjustment, myItem);
                    myItem.resetAdjustmentPrice();
                    promotableOrderItemAdjustment.computeAdjustmentValues();
                    myItem.computeAdjustmentPrice();
                }
            }
        }
        catch (PricingException e) {
            throw new RuntimeException("Could not propagate the items split by the promotion engine into the order", e);
        }
    }

    protected void mergeSplitDiscreteOrderItems(PromotableOrder order) throws PricingException {
        ArrayList<PromotableOrderItem> itemsToRemove = new ArrayList<PromotableOrderItem>();
        ArrayList<DiscreteOrderItem> delegatesToRemove = new ArrayList<DiscreteOrderItem>();
        Iterator<PromotableOrderItem> finalItems = order.getDiscountableDiscreteOrderItems().iterator();
        HashMap<String, PromotableOrderItem> allItems = new HashMap<String, PromotableOrderItem>();
        while (finalItems.hasNext()) {
            PromotableOrderItem nextItem = finalItems.next();
            List<PromotableOrderItem> mySplits = order.searchSplitItems(nextItem);
            if (CollectionUtils.isEmpty(mySplits)) continue;
            PromotableOrderItem cloneItem = nextItem.clone();
            cloneItem.clearAllDiscount();
            cloneItem.clearAllQualifiers();
            cloneItem.removeAllAdjustments();
            cloneItem.setQuantity(0);
            Iterator<PromotableOrderItem> splitItemIterator = mySplits.iterator();
            while (splitItemIterator.hasNext()) {
                PromotableOrderItem splitItem = splitItemIterator.next();
                if (splitItem.isHasOrderItemAdjustments()) continue;
                cloneItem.setQuantity(cloneItem.getQuantity() + splitItem.getQuantity());
                splitItemIterator.remove();
            }
            if (cloneItem.getQuantity() > 0) {
                String identifier = String.valueOf(cloneItem.getSku().getId());
                if (cloneItem.getDelegate().getBundleOrderItem() != null) {
                    identifier = identifier + cloneItem.getDelegate().getBundleOrderItem().getId();
                }
                if (allItems.containsKey(identifier)) {
                    PromotableOrderItem savedItem = (PromotableOrderItem)allItems.get(identifier);
                    savedItem.setQuantity(savedItem.getQuantity() + cloneItem.getQuantity());
                } else {
                    allItems.put(identifier, cloneItem);
                    mySplits.add(cloneItem);
                }
            }
            if (nextItem.getDelegate().getBundleOrderItem() == null) {
                if (mySplits.contains(nextItem)) {
                    mySplits.remove(nextItem);
                    continue;
                }
                itemsToRemove.add(nextItem);
                delegatesToRemove.add(nextItem.getDelegate());
                continue;
            }
            itemsToRemove.add(nextItem);
            delegatesToRemove.add(nextItem.getDelegate());
        }
        for (OrderItemSplitContainer key : order.getSplitItems()) {
            List<PromotableOrderItem> mySplits = key.getSplitItems();
            if (CollectionUtils.isEmpty(mySplits)) continue;
            PromotableFulfillmentGroup targetGroup = this.getTargetFulfillmentGroup(order, key.getKey());
            for (PromotableOrderItem myItem : mySplits) {
                myItem.assignFinalPrice();
                DiscreteOrderItem delegateItem = myItem.getDelegate();
                if (delegateItem.getBundleOrderItem() == null) {
                    delegateItem = (DiscreteOrderItem)this.cartService.addOrderItemToOrder(order.getDelegate(), delegateItem, false);
                    if (targetGroup != null) {
                        this.cartService.addItemToFulfillmentGroup((OrderItem)delegateItem, targetGroup.getDelegate(), false);
                    }
                } else {
                    delegateItem = (DiscreteOrderItem)this.cartService.addOrderItemToBundle(order.getDelegate(), delegateItem.getBundleOrderItem(), delegateItem, false);
                }
                myItem.setDelegate(delegateItem);
            }
        }
        ArrayList<GiftWrapOrderItem> giftWrapItems = new ArrayList<GiftWrapOrderItem>();
        for (DiscreteOrderItem discreteOrderItem : order.getDelegate().getDiscreteOrderItems()) {
            if (!(discreteOrderItem instanceof GiftWrapOrderItem)) continue;
            if (!delegatesToRemove.contains(discreteOrderItem)) {
                giftWrapItems.add((GiftWrapOrderItem)discreteOrderItem);
                continue;
            }
            Iterator<OrderItem> wrappedItems = ((GiftWrapOrderItem)discreteOrderItem).getWrappedItems().iterator();
            while (wrappedItems.hasNext()) {
                OrderItem wrappedItem = wrappedItems.next();
                wrappedItem.setGiftWrapOrderItem(null);
                wrappedItems.remove();
            }
        }
        for (PromotableOrderItem itemToRemove : itemsToRemove) {
            DiscreteOrderItem delegateItem = itemToRemove.getDelegate();
            this.mergeSplitGiftWrapOrderItems(order, giftWrapItems, itemToRemove, delegateItem);
            if (delegateItem.getBundleOrderItem() == null) {
                this.cartService.removeItemFromOrder(order.getDelegate(), itemToRemove.getDelegate(), false);
                continue;
            }
            delegateItem.getBundleOrderItem().getDiscreteOrderItems().remove(itemToRemove.getDelegate());
        }
    }

    protected void mergeSplitGiftWrapOrderItems(PromotableOrder order, List<GiftWrapOrderItem> giftWrapItems, PromotableOrderItem itemToRemove, DiscreteOrderItem delegateItem) {
        for (GiftWrapOrderItem giftWrapOrderItem : giftWrapItems) {
            ArrayList<DiscreteOrderItem> newItems = new ArrayList<DiscreteOrderItem>();
            Iterator<OrderItem> wrappedItems = giftWrapOrderItem.getWrappedItems().iterator();
            boolean foundItems = false;
            while (wrappedItems.hasNext()) {
                OrderItem wrappedItem = wrappedItems.next();
                if (!wrappedItem.equals(delegateItem)) continue;
                foundItems = true;
                List<PromotableOrderItem> searchHits = order.searchSplitItems(itemToRemove);
                if (!CollectionUtils.isEmpty(searchHits)) {
                    for (PromotableOrderItem searchHit : searchHits) {
                        newItems.add(searchHit.getDelegate());
                        searchHit.getDelegate().setGiftWrapOrderItem(giftWrapOrderItem);
                    }
                }
                delegateItem.setGiftWrapOrderItem(null);
                wrappedItems.remove();
            }
            if (!foundItems) continue;
            giftWrapOrderItem.getWrappedItems().addAll(newItems);
            this.orderItemService.saveOrderItem(giftWrapOrderItem);
        }
    }

    protected void mergeSplitBundleOrderItems(PromotableOrder order) throws PricingException {
        List<BundleOrderItemSplitContainer> bundleContainers = order.getBundleSplitItems();
        for (BundleOrderItemSplitContainer bundleContainer : bundleContainers) {
            PromotableFulfillmentGroup targetGroup = this.getTargetFulfillmentGroup(order, bundleContainer.getKey());
            List<BundleOrderItem> bundleOrderItems = bundleContainer.getSplitItems();
            HashMap<String, BundleOrderItem> gatheredBundleItems = new HashMap<String, BundleOrderItem>();
            for (BundleOrderItem bundleOrderItem : bundleOrderItems) {
                bundleOrderItem.assignFinalPrice();
                String hash = bundleOrderItem.getPrice().stringValue();
                if (!gatheredBundleItems.containsKey(hash)) {
                    gatheredBundleItems.put(hash, bundleOrderItem);
                    continue;
                }
                BundleOrderItem temp = (BundleOrderItem)gatheredBundleItems.get(hash);
                temp.setQuantity(temp.getQuantity() + 1);
            }
            this.cartService.removeItemFromOrder(order.getDelegate(), bundleContainer.getKey(), false);
            for (BundleOrderItem vals : gatheredBundleItems.values()) {
                vals.setId(null);
                BundleOrderItem temp = (BundleOrderItem)this.cartService.addOrderItemToOrder(order.getDelegate(), vals, false);
                if (targetGroup == null) continue;
                this.cartService.addItemToFulfillmentGroup((OrderItem)temp, targetGroup.getDelegate(), false);
            }
        }
    }

    protected PromotableFulfillmentGroup getTargetFulfillmentGroup(PromotableOrder order, OrderItem key) {
        PromotableFulfillmentGroup targetGroup = null;
        block0: for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgItem : fg.getDelegate().getFulfillmentGroupItems()) {
                if (!fgItem.getOrderItem().equals(key)) continue;
                targetGroup = fg;
                break block0;
            }
        }
        return targetGroup;
    }

    @Override
    public void compileOrderTotal(PromotableOrder order) {
        order.assignOrderItemsFinalPrice();
        order.setSubTotal(order.calculateOrderItemsFinalPrice(true));
    }

    @Override
    public OfferDao getOfferDao() {
        return this.offerDao;
    }

    @Override
    public void setOfferDao(OfferDao offerDao) {
        this.offerDao = offerDao;
    }

    @Override
    public CartService getCartService() {
        return this.cartService;
    }

    @Override
    public void setCartService(CartService cartService) {
        this.cartService = cartService;
    }

    @Override
    public OrderItemService getOrderItemService() {
        return this.orderItemService;
    }

    @Override
    public void setOrderItemService(OrderItemService orderItemService) {
        this.orderItemService = orderItemService;
    }

    @Override
    public FulfillmentGroupItemDao getFulfillmentGroupItemDao() {
        return this.fulfillmentGroupItemDao;
    }

    @Override
    public void setFulfillmentGroupItemDao(FulfillmentGroupItemDao fulfillmentGroupItemDao) {
        this.fulfillmentGroupItemDao = fulfillmentGroupItemDao;
    }

    @Override
    public PromotableItemFactory getPromotableItemFactory() {
        return this.promotableItemFactory;
    }

    @Override
    public void setPromotableItemFactory(PromotableItemFactory promotableItemFactory) {
        this.promotableItemFactory = promotableItemFactory;
    }
}

