/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.BundleOrderItemFeePrice;
import org.broadleafcommerce.core.order.domain.BundleOrderItemFeePriceImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemVisitor;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_BUNDLE_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(friendlyName="bundleOrderItem")
public class BundleOrderItemImpl
extends OrderItemImpl
implements BundleOrderItem {
    private static final long serialVersionUID = 1L;
    @OneToMany(mappedBy="bundleOrderItem", targetEntity=DiscreteOrderItemImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<DiscreteOrderItem> discreteOrderItems = new ArrayList<DiscreteOrderItem>();
    @OneToMany(mappedBy="bundleOrderItem", targetEntity=BundleOrderItemFeePriceImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<BundleOrderItemFeePrice> bundleOrderItemFeePrices = new ArrayList<BundleOrderItemFeePrice>();

    @Override
    public List<DiscreteOrderItem> getDiscreteOrderItems() {
        return this.discreteOrderItems;
    }

    @Override
    public void setDiscreteOrderItems(List<DiscreteOrderItem> discreteOrderItems) {
        this.discreteOrderItems = discreteOrderItems;
    }

    @Override
    public List<BundleOrderItemFeePrice> getBundleOrderItemFeePrices() {
        return this.bundleOrderItemFeePrices;
    }

    @Override
    public void setBundleOrderItemFeePrices(List<BundleOrderItemFeePrice> bundleOrderItemFeePrices) {
        this.bundleOrderItemFeePrices = bundleOrderItemFeePrices;
    }

    @Override
    public void removeAllCandidateItemOffers() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            discreteOrderItem.removeAllCandidateItemOffers();
        }
    }

    @Override
    public int removeAllAdjustments() {
        int removedAdjustmentCount = 0;
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            removedAdjustmentCount += discreteOrderItem.removeAllAdjustments();
        }
        return removedAdjustmentCount;
    }

    @Override
    public void assignFinalPrice() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            discreteOrderItem.assignFinalPrice();
        }
        this.price = this.getCurrentPrice().getAmount();
    }

    @Override
    public Money getTaxablePrice() {
        Money currentBundleTaxablePrice = new Money();
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            Money currentItemTaxablePrice = discreteOrderItem.getTaxablePrice();
            currentBundleTaxablePrice = currentBundleTaxablePrice.add(new Money(currentItemTaxablePrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
        }
        for (BundleOrderItemFeePrice fee : this.getBundleOrderItemFeePrices()) {
            if (!fee.isTaxable().booleanValue()) continue;
            currentBundleTaxablePrice = currentBundleTaxablePrice.add(fee.getAmount());
        }
        return currentBundleTaxablePrice;
    }

    @Override
    public Money getRetailPrice() {
        Money bundleRetailPrice = new Money();
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            Money itemRetailPrice = discreteOrderItem.getRetailPrice();
            bundleRetailPrice = bundleRetailPrice.add(new Money(itemRetailPrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
        }
        for (BundleOrderItemFeePrice fee : this.getBundleOrderItemFeePrices()) {
            bundleRetailPrice = bundleRetailPrice.add(fee.getAmount());
        }
        return bundleRetailPrice;
    }

    @Override
    public Money getSalePrice() {
        Money bundleSalePrice = null;
        if (this.hasSaleItems()) {
            bundleSalePrice = new Money();
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                Money itemSalePrice = null;
                itemSalePrice = discreteOrderItem.getSalePrice() != null ? discreteOrderItem.getSalePrice() : discreteOrderItem.getRetailPrice();
                bundleSalePrice = bundleSalePrice.add(new Money(itemSalePrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
            }
            for (BundleOrderItemFeePrice fee : this.getBundleOrderItemFeePrices()) {
                bundleSalePrice = bundleSalePrice.add(fee.getAmount());
            }
        }
        return bundleSalePrice;
    }

    private boolean hasSaleItems() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            if (discreteOrderItem.getSalePrice() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAdjustedItems() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            if (!discreteOrderItem.getAdjustmentValue().greaterThan(new Money(0.0))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Money getCurrentPrice() {
        Money currentBundlePrice = new Money();
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            Money currentItemPrice = discreteOrderItem.getCurrentPrice();
            currentBundlePrice = currentBundlePrice.add(new Money(currentItemPrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
        }
        return currentBundlePrice;
    }

    @Override
    public boolean updatePrices() {
        boolean updated = false;
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            if (!discreteOrderItem.updatePrices()) continue;
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleOrderItemImpl other = (BundleOrderItemImpl)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public OrderItem clone() {
        BundleOrderItemImpl orderItem = (BundleOrderItemImpl)super.clone();
        if (this.getDiscreteOrderItems() != null) {
            for (DiscreteOrderItem discreteOrderItem : this.getDiscreteOrderItems()) {
                DiscreteOrderItem temp = (DiscreteOrderItem)discreteOrderItem.clone();
                temp.setBundleOrderItem(orderItem);
                orderItem.getDiscreteOrderItems().add(temp);
            }
        }
        if (this.getBundleOrderItemFeePrices() != null) {
            for (BundleOrderItemFeePrice feePrice : this.getBundleOrderItemFeePrices()) {
                BundleOrderItemFeePrice cloneFeePrice = feePrice.clone();
                cloneFeePrice.setBundleOrderItem(orderItem);
                orderItem.getBundleOrderItemFeePrices().add(cloneFeePrice);
            }
        }
        return orderItem;
    }

    @Override
    public int hashCode() {
        int prime = super.hashCode();
        int result = 1;
        result = prime * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public void accept(OrderItemVisitor visitor) throws PricingException {
        visitor.visit(this);
    }
}

