/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class FulfillmentType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, FulfillmentType> TYPES = new HashMap<String, FulfillmentType>();
    public static final FulfillmentType DIGITAL = new FulfillmentType("DIGITAL", "Digital");
    public static final FulfillmentType PHYSICAL = new FulfillmentType("PHYSICAL", "Physical");
    @Deprecated
    public static final FulfillmentType SHIPPING = new FulfillmentType("SHIPPING", "Shipping");
    private String type;
    private String friendlyType;

    public static FulfillmentType getInstance(String type) {
        return TYPES.get(type);
    }

    public FulfillmentType() {
    }

    public FulfillmentType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentType other = (FulfillmentType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

