/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetImpl;
import org.broadleafcommerce.core.search.domain.SearchFacetRange;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SEARCH_FACET_RANGE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class SearchFacetRangeImpl
implements SearchFacetRange,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SearchFacetRangeId", strategy=GenerationType.TABLE)
    @TableGenerator(name="SearchFacetRangeId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="SearchFacetRangeImpl", allocationSize=50)
    @Column(name="SEARCH_FACET_RANGE_ID")
    protected Long id;
    @ManyToOne(targetEntity=SearchFacetImpl.class, optional=false)
    @JoinColumn(name="SEARCH_FACET_ID")
    @Index(name="SEARCH_FACET_INDEX", columnNames={"SEARCH_FACET_ID"})
    protected SearchFacet searchFacet = new SearchFacetImpl();
    @Column(name="MIN_VALUE", precision=19, scale=5, nullable=false)
    @AdminPresentation(friendlyName="SearchFacetRangeImpl_MIN_VALUE", order=1, group="SearchFacetRangeImpl_Description", prominent=true)
    protected BigDecimal minValue;
    @Column(name="MAX_VALUE", precision=19, scale=5)
    @AdminPresentation(friendlyName="SearchFacetRangeImpl_MAX_VALUE", order=1, group="SearchFacetRangeImpl_Description", prominent=true)
    protected BigDecimal maxValue;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public SearchFacet getSearchFacet() {
        return this.searchFacet;
    }

    @Override
    public void setSearchFacet(SearchFacet searchFacet) {
        this.searchFacet = searchFacet;
    }

    @Override
    public BigDecimal getMinValue() {
        return this.minValue;
    }

    @Override
    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    @Override
    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }
}

