/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.RequiredOverride;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductBundleImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItem;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.dynamic.DefaultDynamicSkuPricingInvocationHandler;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPrices;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU_BUNDLE_ITEM")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class SkuBundleItemImpl
implements SkuBundleItem {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuBundleItemId")
    @GenericGenerator(name="SkuBundleItemId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="SkuBundleItemImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.SkuBundleItemImpl")})
    @Column(name="SKU_BUNDLE_ITEM_ID")
    @AdminPresentation(friendlyName="SkuBundleItemImpl_ID", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="bundleItemQuantity", requiredOverride=RequiredOverride.REQUIRED)
    protected Integer quantity;
    @Column(name="ITEM_SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="bundleItemSalePrice", tooltip="bundleItemSalePriceTooltip", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal itemSalePrice;
    @ManyToOne(targetEntity=ProductBundleImpl.class, optional=false)
    @JoinColumn(name="PRODUCT_BUNDLE_ID", referencedColumnName="PRODUCT_ID")
    protected ProductBundle bundle;
    @ManyToOne(targetEntity=SkuImpl.class, optional=false)
    @JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID")
    private Sku sku;
    @Transient
    protected DynamicSkuPrices dynamicPrices = null;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    protected Money getDynamicSalePrice(Sku sku, BigDecimal salePrice) {
        if (SkuPricingConsiderationContext.getSkuPricingConsiderationContext() != null && SkuPricingConsiderationContext.getSkuPricingConsiderationContext().size() > 0 && SkuPricingConsiderationContext.getSkuPricingService() != null) {
            if (sku == null) {
                throw new IllegalArgumentException("Unable to price bundle item.   DynamicPricing is enabled but no default sku is associated with the ProductBundle.");
            }
            DefaultDynamicSkuPricingInvocationHandler handler = new DefaultDynamicSkuPricingInvocationHandler(sku, salePrice);
            Sku proxy = (Sku)Proxy.newProxyInstance(sku.getClass().getClassLoader(), sku.getClass().getInterfaces(), (InvocationHandler)handler);
            this.dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getSkuPrices(proxy, SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
            handler.reset();
            return this.dynamicPrices.getSalePrice();
        }
        return salePrice == null ? null : new Money(salePrice);
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.itemSalePrice = salePrice != null ? salePrice.getAmount() : null;
    }

    @Override
    public Money getSalePrice() {
        if (this.itemSalePrice == null) {
            return this.sku.getSalePrice();
        }
        return this.getDynamicSalePrice(this.sku, this.itemSalePrice);
    }

    @Override
    public Money getRetailPrice() {
        return this.sku.getRetailPrice();
    }

    @Override
    public ProductBundle getBundle() {
        return this.bundle;
    }

    @Override
    public void setBundle(ProductBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
    }
}

