/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.util;

import org.apache.commons.lang.time.DurationFormatUtils;

public class StopWatch {
    private static final int STATE_UNSTARTED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPPED = 2;
    private static final int STATE_SUSPENDED = 3;
    private static final int STATE_UNSPLIT = 10;
    private static final int STATE_SPLIT = 11;
    private int runningState = 0;
    private int splitState = 10;
    private long startTime = -1L;
    private long stopTime = -1L;

    public StopWatch() {
        this.start();
        this.split();
    }

    public StopWatch start() {
        if (this.runningState == 2) {
            throw new IllegalStateException("Stopwatch must be reset before being restarted. ");
        }
        if (this.runningState != 0) {
            throw new IllegalStateException("Stopwatch already started. ");
        }
        this.stopTime = -1L;
        this.startTime = System.currentTimeMillis();
        this.runningState = 1;
        return this;
    }

    public StopWatch stop() {
        if (this.runningState != 1 && this.runningState != 3) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        if (this.runningState == 1) {
            this.stopTime = System.currentTimeMillis();
        }
        this.runningState = 2;
        return this;
    }

    public StopWatch reset() {
        this.runningState = 0;
        this.splitState = 10;
        this.startTime = -1L;
        this.stopTime = -1L;
        return this;
    }

    public StopWatch split() {
        if (this.runningState != 1) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        this.stopTime = System.currentTimeMillis();
        this.splitState = 11;
        return this;
    }

    public StopWatch unsplit() {
        if (this.splitState != 11) {
            throw new IllegalStateException("Stopwatch has not been split. ");
        }
        this.stopTime = -1L;
        this.splitState = 10;
        return this;
    }

    public StopWatch suspend() {
        if (this.runningState != 1) {
            throw new IllegalStateException("Stopwatch must be running to suspend. ");
        }
        this.stopTime = System.currentTimeMillis();
        this.runningState = 3;
        return this;
    }

    public StopWatch resume() {
        if (this.runningState != 3) {
            throw new IllegalStateException("Stopwatch must be suspended to resume. ");
        }
        this.startTime += System.currentTimeMillis() - this.stopTime;
        this.stopTime = -1L;
        this.runningState = 1;
        return this;
    }

    public long getTime() {
        if (this.runningState == 2 || this.runningState == 3) {
            return this.stopTime - this.startTime;
        }
        if (this.runningState == 0) {
            return 0L;
        }
        if (this.runningState == 1) {
            return System.currentTimeMillis() - this.startTime;
        }
        throw new RuntimeException("Illegal running state has occured. ");
    }

    public long getSplitTime() {
        if (this.splitState != 11) {
            throw new IllegalStateException("Stopwatch must be split to get the split time. ");
        }
        return this.stopTime - this.startTime;
    }

    public long getLapTime() {
        if (this.splitState != 11) {
            throw new IllegalStateException("Stopwatch must be split to get the lap time. ");
        }
        return System.currentTimeMillis() - this.stopTime;
    }

    public long getStartTime() {
        if (this.runningState == 0) {
            throw new IllegalStateException("Stopwatch has not been started");
        }
        return this.startTime;
    }

    public String toString() {
        return DurationFormatUtils.formatDurationHMS((long)this.getTime());
    }

    public String toSplitString() {
        return DurationFormatUtils.formatDurationHMS((long)this.getSplitTime());
    }

    public String toLapString() {
        return DurationFormatUtils.formatDurationHMS((long)this.getLapTime());
    }

    public StopWatch printString(String msg) {
        System.out.println(msg + ": " + this.toString());
        return this;
    }

    public StopWatch printSplitString(String msg) {
        System.out.println(msg + ": " + this.toSplitString());
        return this;
    }

    public StopWatch printLapString(String msg) {
        System.out.println(msg + ": " + this.toLapString());
        return this;
    }
}

