/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.util.demo;

import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.broadleafcommerce.core.catalog.dao.CategoryXrefDao;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.util.demo.CatalogMultiplier;

public class CatalogMultiplierImpl
implements CatalogMultiplier {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blCategoryXrefDao")
    protected CategoryXrefDao categoryXrefDao;
    protected Random random = new Random();
    protected long numberOfProductsToAdd = 10000L;

    @Override
    public void init() {
        long j = 0L;
        List<Product> products = this.catalogService.findAllProducts();
        while (j < this.numberOfProductsToAdd) {
            for (Product product : products) {
                List<ProductAttribute> attributes = product.getProductAttributes();
                for (ProductAttribute attribute : attributes) {
                    this.em.detach((Object)attribute);
                    attribute.setId(null);
                }
                Product derivedProduct = product;
                Sku sku = derivedProduct.getDefaultSku();
                this.em.detach((Object)sku);
                sku.setId(null);
                String skuName = sku.getName();
                int pos = skuName.indexOf(95);
                if (pos >= 0) {
                    skuName = skuName.substring(0, pos);
                }
                sku.setName(skuName + '_' + j);
                sku = this.catalogService.saveSku(sku);
                derivedProduct.setDefaultSku(sku);
                product.getAllSkus().clear();
                product.getAllSkus().add(sku);
                product.getAllParentCategories().size();
                this.em.detach((Object)product);
                product.setId(null);
                String productName = sku.getName();
                pos = productName.indexOf(95);
                if (pos >= 0) {
                    productName = productName.substring(0, pos);
                }
                product.setName(productName + '_' + j);
                String manuName = product.getManufacturer();
                pos = manuName.indexOf(95);
                if (pos >= 0) {
                    manuName = manuName.substring(0, pos);
                }
                product.setManufacturer(manuName + '_' + this.random.nextInt(100));
                product = this.catalogService.saveProduct(product);
                System.out.println(++j + ". Adding additional demo product: " + product.getName());
                if (j <= this.numberOfProductsToAdd) continue;
                break;
            }
            this.em.flush();
            this.em.clear();
        }
    }

    public long getNumberOfProductsToAdd() {
        return this.numberOfProductsToAdd;
    }

    public void setNumberOfProductsToAdd(long numberOfProductsToAdd) {
        this.numberOfProductsToAdd = numberOfProductsToAdd;
    }
}

