/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.broadleafcommerce.core.order.domain.TaxDetail;
import org.broadleafcommerce.core.order.domain.TaxDetailImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;

@Entity
@DiscriminatorColumn(name="TYPE")
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_GROUP_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class FulfillmentGroupItemImpl
implements FulfillmentGroupItem,
Cloneable {
    private static final Log LOG = LogFactory.getLog(FulfillmentGroupItemImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FulfillmentGroupItemId", strategy=GenerationType.TABLE)
    @TableGenerator(name="FulfillmentGroupItemId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="FulfillmentGroupItemImpl", allocationSize=150)
    @Column(name="FULFILLMENT_GROUP_ITEM_ID")
    protected Long id;
    @ManyToOne(targetEntity=FulfillmentGroupImpl.class, optional=false)
    @JoinColumn(name="FULFILLMENT_GROUP_ID")
    @Index(name="FGITEM_FG_INDEX", columnNames={"FULFILLMENT_GROUP_ID"})
    protected FulfillmentGroup fulfillmentGroup;
    @ManyToOne(targetEntity=OrderItemImpl.class, optional=false)
    @JoinColumn(name="ORDER_ITEM_ID")
    protected OrderItem orderItem;
    @Column(name="QUANTITY", nullable=false)
    protected int quantity;
    @Column(name="STATUS")
    @Index(name="FGITEM_STATUS_INDEX", columnNames={"STATUS"})
    private String status;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=TaxDetailImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_FG_ITEM_TAX_XREF", joinColumns={@JoinColumn(name="FULFILLMENT_GROUP_ITEM_ID")}, inverseJoinColumns={@JoinColumn(name="TAX_DETAIL_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<TaxDetail> taxes = new ArrayList<TaxDetail>();
    @Column(name="TOTAL_ITEM_TAX", precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupItemImpl_Total_Item_Tax", order=9, group="FulfillmentGroupItemImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal totalTax;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    @Override
    public void setFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroup = fulfillmentGroup;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public Money getRetailPrice() {
        return this.orderItem.getRetailPrice();
    }

    @Override
    public Money getSalePrice() {
        return this.orderItem.getSalePrice();
    }

    @Override
    public Money getPrice() {
        return this.orderItem.getPrice();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void removeAssociations() {
        if (this.getFulfillmentGroup() != null) {
            this.getFulfillmentGroup().getFulfillmentGroupItems().remove(this);
        }
        this.setFulfillmentGroup(null);
        this.setOrderItem(null);
    }

    @Override
    public List<TaxDetail> getTaxes() {
        return this.taxes;
    }

    @Override
    public void setTaxes(List<TaxDetail> taxes) {
        this.taxes = taxes;
    }

    @Override
    public Money getTotalTax() {
        return this.totalTax == null ? null : new Money(this.totalTax);
    }

    @Override
    public void setTotalTax(Money totalTax) {
        this.totalTax = Money.toAmount((Money)totalTax);
    }

    public void checkCloneable(FulfillmentGroupItem fulfillmentGroupItem) throws CloneNotSupportedException, SecurityException, NoSuchMethodException {
        Method cloneMethod = fulfillmentGroupItem.getClass().getMethod("clone", new Class[0]);
        if (cloneMethod.getDeclaringClass().getName().startsWith("org.broadleafcommerce") && !this.orderItem.getClass().getName().startsWith("org.broadleafcommerce")) {
            throw new CloneNotSupportedException("Custom extensions and implementations should implement clone in order to guarantee split and merge operations are performed accurately");
        }
    }

    @Override
    public FulfillmentGroupItem clone() {
        FulfillmentGroupItem clonedFulfillmentGroupItem;
        try {
            clonedFulfillmentGroupItem = (FulfillmentGroupItem)Class.forName(this.getClass().getName()).newInstance();
            try {
                this.checkCloneable(clonedFulfillmentGroupItem);
            }
            catch (CloneNotSupportedException e) {
                LOG.warn((Object)("Clone implementation missing in inheritance hierarchy outside of Broadleaf: " + clonedFulfillmentGroupItem.getClass().getName()), (Throwable)e);
            }
            clonedFulfillmentGroupItem.setFulfillmentGroup(this.getFulfillmentGroup());
            clonedFulfillmentGroupItem.setOrderItem(this.getOrderItem());
            clonedFulfillmentGroupItem.setQuantity(this.getQuantity());
            clonedFulfillmentGroupItem.setStatus(this.getStatus());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clonedFulfillmentGroupItem;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupItemImpl other = (FulfillmentGroupItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.orderItem == null ? other.orderItem != null : !this.orderItem.equals(other.orderItem));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.orderItem == null ? 0 : this.orderItem.hashCode());
        return result;
    }
}

