/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.workflow;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutContext;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.offer.dao.OfferAuditDao;
import org.broadleafcommerce.core.offer.domain.Adjustment;
import org.broadleafcommerce.core.offer.domain.OfferAudit;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class RecordOfferUsageActivity
extends BaseActivity {
    @Resource(name="blOfferAuditDao")
    private OfferAuditDao offerAuditDao;

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        HashSet<Long> appliedOfferIds = new HashSet<Long>();
        CheckoutSeed seed = ((CheckoutContext)context).getSeedData();
        Order order = seed.getOrder();
        if (order != null) {
            this.addOfferIds(order.getOrderAdjustments(), appliedOfferIds);
            if (order.getOrderItems() != null) {
                for (OrderItem item : order.getOrderItems()) {
                    this.addOfferIds(item.getOrderItemAdjustments(), appliedOfferIds);
                }
            }
            if (order.getFulfillmentGroups() != null) {
                for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                    this.addOfferIds(fg.getFulfillmentGroupAdjustments(), appliedOfferIds);
                }
            }
            this.saveOfferIds(appliedOfferIds, order);
        }
        return context;
    }

    private void saveOfferIds(Set<Long> offerIds, Order order) {
        for (Long offerId : offerIds) {
            OfferAudit audit = this.offerAuditDao.create();
            if (order.getCustomer() != null) {
                audit.setCustomerId(order.getCustomer().getId());
            }
            audit.setOfferId(offerId);
            audit.setOrderId(order.getId());
            audit.setRedeemedDate(SystemTime.asDate());
            this.offerAuditDao.save(audit);
        }
    }

    private void addOfferIds(List<? extends Adjustment> adjustments, Set<Long> offerIds) {
        if (adjustments != null) {
            for (Adjustment adjustment : adjustments) {
                if (adjustment.getOffer() == null) continue;
                offerIds.add(adjustment.getOffer().getId());
            }
        }
    }
}

