/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.search.dao.FieldDao;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.FieldEntity;
import org.broadleafcommerce.core.search.domain.FieldImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blFieldDao")
public class FieldDaoImpl
implements FieldDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Field readFieldByAbbreviation(String abbreviation) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Field.class);
        Root root = criteria.from(FieldImpl.class);
        criteria.select((Selection)root);
        criteria.where((Expression)builder.equal(root.get("abbreviation").as(String.class), (Object)abbreviation));
        return (Field)this.em.createQuery(criteria).getSingleResult();
    }

    @Override
    public List<Field> readAllProductFields() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Field.class);
        Root root = criteria.from(FieldImpl.class);
        criteria.select((Selection)root);
        criteria.where((Expression)builder.equal(root.get("entityType").as(String.class), (Object)FieldEntity.PRODUCT.getType()));
        return this.em.createQuery(criteria).getResultList();
    }
}

