/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.PromotableProduct;
import org.broadleafcommerce.core.catalog.domain.RelatedProductDTO;
import org.broadleafcommerce.core.catalog.domain.RelatedProductTypeEnum;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.catalog.service.RelatedProductsService;
import org.springframework.stereotype.Service;

@Service(value="blRelatedProductsService")
public class RelatedProductsServiceImpl
implements RelatedProductsService {
    @Resource(name="blCategoryDao")
    protected CategoryDao categoryDao;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;

    @Override
    public List<? extends PromotableProduct> findRelatedProducts(RelatedProductDTO relatedProductDTO) {
        Product product = this.lookupProduct(relatedProductDTO);
        Category category = this.lookupCategory(relatedProductDTO);
        if (RelatedProductTypeEnum.FEATURED.equals(relatedProductDTO.getType())) {
            return this.buildFeaturedProductsList(product, category, relatedProductDTO);
        }
        if (RelatedProductTypeEnum.CROSS_SALE.equals(relatedProductDTO.getType())) {
            return this.buildCrossSaleProductsList(product, category, relatedProductDTO);
        }
        if (RelatedProductTypeEnum.UP_SALE.equals(relatedProductDTO.getType())) {
            return this.buildUpSaleProductsList(product, category, relatedProductDTO);
        }
        throw new IllegalArgumentException("RelatedProductType " + relatedProductDTO.getType() + " not supported.");
    }

    protected List<? extends PromotableProduct> buildFeaturedProductsList(Product product, Category category, RelatedProductDTO relatedProductDTO) {
        List<PromotableProduct> returnFeaturedProducts = null;
        if (product != null) {
            category = product.getDefaultCategory();
        }
        if (category != null) {
            returnFeaturedProducts = relatedProductDTO.isCumulativeResults() ? category.getCumulativeFeaturedProducts() : category.getFeaturedProducts();
        }
        this.removeCurrentProductFromReturnList(product, returnFeaturedProducts);
        returnFeaturedProducts = this.removeDuplicatesFromList(returnFeaturedProducts);
        return this.resizeList(returnFeaturedProducts, relatedProductDTO.getQuantity());
    }

    private List<? extends PromotableProduct> removeDuplicatesFromList(List<? extends PromotableProduct> returnPromotableProducts) {
        LinkedHashSet<PromotableProduct> productSet = new LinkedHashSet<PromotableProduct>();
        LinkedHashSet<Product> relatedProductSet = new LinkedHashSet<Product>();
        if (returnPromotableProducts != null) {
            for (PromotableProduct promotableProduct : returnPromotableProducts) {
                if (relatedProductSet.contains(promotableProduct.getRelatedProduct())) continue;
                productSet.add(promotableProduct);
                relatedProductSet.add(promotableProduct.getRelatedProduct());
            }
        } else {
            return null;
        }
        returnPromotableProducts.clear();
        returnPromotableProducts.addAll(new ArrayList(productSet));
        return returnPromotableProducts;
    }

    private void removeCurrentProductFromReturnList(Product product, List<? extends PromotableProduct> returnPromotableProducts) {
        if (product != null && returnPromotableProducts != null) {
            Iterator<? extends PromotableProduct> productIterator = returnPromotableProducts.iterator();
            while (productIterator.hasNext()) {
                PromotableProduct promotableProduct = productIterator.next();
                if (!product.getId().equals(promotableProduct.getRelatedProduct().getId())) continue;
                productIterator.remove();
            }
        }
    }

    protected List<? extends PromotableProduct> buildUpSaleProductsList(Product product, Category category, RelatedProductDTO relatedProductDTO) {
        List<PromotableProduct> returnUpSaleProducts = null;
        if (product != null) {
            returnUpSaleProducts = relatedProductDTO.isCumulativeResults() ? product.getCumulativeUpSaleProducts() : product.getUpSaleProducts();
        } else if (category != null) {
            returnUpSaleProducts = relatedProductDTO.isCumulativeResults() ? category.getCumulativeUpSaleProducts() : category.getUpSaleProducts();
        }
        this.removeCurrentProductFromReturnList(product, returnUpSaleProducts);
        returnUpSaleProducts = this.removeDuplicatesFromList(returnUpSaleProducts);
        return this.resizeList(returnUpSaleProducts, relatedProductDTO.getQuantity());
    }

    protected List<? extends PromotableProduct> buildCrossSaleProductsList(Product product, Category category, RelatedProductDTO relatedProductDTO) {
        List<PromotableProduct> crossSaleProducts = null;
        if (product != null) {
            crossSaleProducts = relatedProductDTO.isCumulativeResults() ? product.getCumulativeCrossSaleProducts() : product.getCrossSaleProducts();
        } else if (category != null) {
            crossSaleProducts = relatedProductDTO.isCumulativeResults() ? category.getCumulativeCrossSaleProducts() : category.getCrossSaleProducts();
        }
        this.removeCurrentProductFromReturnList(product, crossSaleProducts);
        crossSaleProducts = this.removeDuplicatesFromList(crossSaleProducts);
        return this.resizeList(crossSaleProducts, relatedProductDTO.getQuantity());
    }

    protected List<? extends PromotableProduct> resizeList(List<? extends PromotableProduct> originalList, Integer qty) {
        if (qty != null && originalList != null && originalList.size() > qty) {
            return originalList.subList(0, qty);
        }
        return originalList;
    }

    protected Product lookupProduct(RelatedProductDTO relatedProductDTO) {
        if (relatedProductDTO.getProductId() != null) {
            return this.productDao.readProductById(relatedProductDTO.getProductId());
        }
        return null;
    }

    protected Category lookupCategory(RelatedProductDTO relatedProductDTO) {
        if (relatedProductDTO.getCategoryId() != null) {
            return this.categoryDao.readCategoryById(relatedProductDTO.getCategoryId());
        }
        return null;
    }
}

