/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.OrderItemMergeService;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemImpl;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.domain.OrderMultishipOption;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.manipulation.BundleOrderItemSplitContainer;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemSplitContainer;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Address;
import org.springframework.stereotype.Service;

@Service(value="blOrderItemMergeService")
public class OrderItemMergeServiceImpl
implements OrderItemMergeService {
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fulfillmentGroupItemDao;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blOrderMultishipOptionService")
    protected OrderMultishipOptionService orderMultishipOptionService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blPromotableItemFactory")
    protected PromotableItemFactory promotableItemFactory;

    @Override
    public void gatherSplitItemsInBundles(Order order) throws PricingException {
        ArrayList<DiscreteOrderItem> itemsToRemove = new ArrayList<DiscreteOrderItem>();
        ArrayList<FulfillmentGroupItem> fgItemsToRemove = new ArrayList<FulfillmentGroupItem>();
        HashMap<Long, HashMap<String, Object[]>> gatherMap = new HashMap<Long, HashMap<String, Object[]>>();
        for (FulfillmentGroup group : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgItem : group.getFulfillmentGroupItems()) {
                OrderItem orderItem = fgItem.getOrderItem();
                if (!(orderItem instanceof DiscreteOrderItem) || ((DiscreteOrderItem)orderItem).getBundleOrderItem() == null) continue;
                HashMap<String, Object[]> gatheredItem = (HashMap<String, Object[]>)gatherMap.get(((DiscreteOrderItem)orderItem).getSku().getId());
                if (gatheredItem == null) {
                    gatheredItem = new HashMap<String, Object[]>();
                    gatherMap.put(((DiscreteOrderItem)orderItem).getSku().getId(), gatheredItem);
                }
                this.gatherFulfillmentGroupLinkedDiscreteOrderItem(itemsToRemove, fgItemsToRemove, gatheredItem, fgItem, (DiscreteOrderItem)orderItem, null, this.orderMultishipOptionService.findOrderMultishipOptions(order.getId()), false);
            }
        }
        for (Map values : gatherMap.values()) {
            for (Object[] item : values.values()) {
                this.orderItemService.saveOrderItem((OrderItem)item[0]);
                this.fulfillmentGroupItemDao.save((FulfillmentGroupItem)item[1]);
            }
        }
        for (FulfillmentGroupItem fgItem : fgItemsToRemove) {
            FulfillmentGroup fg = fgItem.getFulfillmentGroup();
            fg.getFulfillmentGroupItems().remove(fgItem);
            this.fulfillmentGroupItemDao.delete(fgItem);
            if (!fg.getFulfillmentGroupItems().isEmpty()) continue;
            order.getFulfillmentGroups().remove(fg);
            this.fulfillmentGroupService.delete(fg);
        }
        for (DiscreteOrderItem orderItem : itemsToRemove) {
            if (orderItem.getBundleOrderItem() == null) continue;
            BundleOrderItem bundleOrderItem = orderItem.getBundleOrderItem();
            bundleOrderItem.getDiscreteOrderItems().remove(orderItem);
            orderItem.setBundleOrderItem(null);
            this.orderItemService.saveOrderItem(bundleOrderItem);
        }
    }

    @Override
    public void mergeSplitItems(PromotableOrder order) {
        try {
            this.mergeSplitDiscreteOrderItems(order);
            this.mergeSplitBundleOrderItems(order);
            order.resetDiscreteOrderItems();
            for (PromotableOrderItem myItem : order.getDiscountableDiscreteOrderItems()) {
                if (!myItem.isHasOrderItemAdjustments()) continue;
                for (OrderItemAdjustment adjustment : myItem.getDelegate().getOrderItemAdjustments()) {
                    PromotableOrderItemAdjustment promotableOrderItemAdjustment = this.promotableItemFactory.createPromotableOrderItemAdjustment(adjustment, myItem);
                    myItem.resetAdjustmentPrice();
                    promotableOrderItemAdjustment.computeAdjustmentValues();
                    myItem.computeAdjustmentPrice();
                }
            }
        }
        catch (PricingException e) {
            throw new RuntimeException("Could not propagate the items split by the promotion engine into the order", e);
        }
    }

    protected String getKey(Address address, FulfillmentOption option) {
        Long addressKey = address == null ? -1L : address.getId();
        Long fulfillmentOptionKey = option == null ? -1L : option.getId();
        return addressKey + ":" + fulfillmentOptionKey;
    }

    @Override
    public void finalizeCart(PromotableOrder order) throws PricingException {
        if (order.isHasMultiShipOptions()) {
            ArrayList<OrderMultishipOption> multishipOptions = new ArrayList<OrderMultishipOption>(order.getMultiShipOptions());
            ArrayList<FulfillmentGroupItem> itemsToRemove = new ArrayList<FulfillmentGroupItem>();
            HashMap<String, FulfillmentGroup> fgMap = new HashMap<String, FulfillmentGroup>();
            for (OrderMultishipOption option : multishipOptions) {
                for (FulfillmentGroupItem item : order.getDelegate().getFulfillmentGroups().get(0).getFulfillmentGroupItems()) {
                    block10: {
                        FulfillmentGroup fg;
                        if (!option.getOrderItem().getId().equals(item.getOrderItem().getId())) continue;
                        String key = this.getKey(option.getAddress(), option.getFulfillmentOption());
                        if (fgMap.containsKey(key)) {
                            fg = (FulfillmentGroup)fgMap.get(key);
                        } else {
                            FulfillmentGroupRequest fgr = new FulfillmentGroupRequest();
                            fgr.setOrder(order.getDelegate());
                            if (option.getAddress() != null) {
                                fgr.setAddress(option.getAddress());
                            }
                            if (option.getFulfillmentOption() != null) {
                                fgr.setOption(option.getFulfillmentOption());
                            }
                            fg = this.fulfillmentGroupService.addFulfillmentGroupToOrder(fgr, false);
                            fg = this.fulfillmentGroupService.save(fg);
                            order.getDelegate().getFulfillmentGroups().add(fg);
                            fgMap.put(key, fg);
                        }
                        for (FulfillmentGroupItem fgItem : fg.getFulfillmentGroupItems()) {
                            if (!fgItem.getOrderItem().getId().equals(option.getOrderItem().getId())) continue;
                            fgItem.setQuantity(fgItem.getQuantity() + 1);
                            this.fulfillmentGroupItemDao.save(fgItem);
                            break block10;
                        }
                        FulfillmentGroupItem fulfillmentGroupItem = this.fulfillmentGroupItemDao.create();
                        fulfillmentGroupItem.setFulfillmentGroup(fg);
                        fulfillmentGroupItem.setOrderItem(option.getOrderItem());
                        fulfillmentGroupItem.setQuantity(1);
                        fulfillmentGroupItem = this.fulfillmentGroupItemDao.save(fulfillmentGroupItem);
                        fg.getFulfillmentGroupItems().add(fulfillmentGroupItem);
                    }
                    if (item.getQuantity() - 1 <= 0) {
                        itemsToRemove.add(item);
                        continue;
                    }
                    item.setQuantity(item.getQuantity() - 1);
                }
            }
            for (FulfillmentGroupItem item : itemsToRemove) {
                FulfillmentGroup fg = item.getFulfillmentGroup();
                fg.getFulfillmentGroupItems().remove(item);
                this.fulfillmentGroupItemDao.delete(item);
                if (fg.getFulfillmentGroupItems().size() != 0) continue;
                order.getDelegate().getFulfillmentGroups().remove(fg);
                fg.setOrder(null);
                this.fulfillmentGroupService.delete(fg);
                this.orderService.save(order.getDelegate(), false);
            }
        }
    }

    @Override
    public void prepareCart(PromotableOrder promotableOrder) {
        try {
            Order order = promotableOrder.getDelegate();
            if (!CollectionUtils.isEmpty(order.getFulfillmentGroups())) {
                List<OrderMultishipOption> options = this.orderMultishipOptionService.findOrderMultishipOptions(order.getId());
                promotableOrder.setMultiShipOptions(options);
                promotableOrder.setHasMultiShipOptions(!CollectionUtils.isEmpty(options) && order.getFulfillmentGroups().size() > 1);
                if (promotableOrder.isHasMultiShipOptions()) {
                    this.fulfillmentGroupService.collapseToOneFulfillmentGroup(order, false);
                    order.getFulfillmentGroups().get(0).setAddress(null);
                    order.getFulfillmentGroups().get(0).setFulfillmentOption(null);
                }
            }
        }
        catch (PricingException e) {
            throw new RuntimeException("Could not prepare the cart", e);
        }
    }

    @Override
    public void gatherCart(PromotableOrder promotableOrder) {
        Order order = promotableOrder.getDelegate();
        try {
            if (!CollectionUtils.isEmpty(order.getFulfillmentGroups())) {
                this.gatherFulfillmentGroupLinkedDiscreteOrderItems(order, promotableOrder.getMultiShipOptions());
                this.gatherFulfillmentGroupLinkedBundleOrderItems(order);
            } else {
                this.gatherOrderLinkedDiscreteOrderItems(order);
                this.gatherOrderLinkedBundleOrderItems(order);
            }
        }
        catch (PricingException e) {
            throw new RuntimeException("Could not gather the cart", e);
        }
        promotableOrder.resetDiscreteOrderItems();
    }

    @Override
    public void initializeBundleSplitItems(PromotableOrder order) {
        List<OrderItem> basicOrderItems = order.getDelegate().getOrderItems();
        for (OrderItem basicOrderItem : basicOrderItems) {
            if (!(basicOrderItem instanceof BundleOrderItem)) continue;
            BundleOrderItem bundleOrderItem = (BundleOrderItem)basicOrderItem;
            List<BundleOrderItem> searchHit = order.searchBundleSplitItems(bundleOrderItem);
            if (searchHit == null) {
                searchHit = new ArrayList<BundleOrderItem>();
                BundleOrderItemSplitContainer container = new BundleOrderItemSplitContainer();
                container.setKey(bundleOrderItem);
                container.setSplitItems(searchHit);
                order.getBundleSplitItems().add(container);
            }
            BundleOrderItem temp = (BundleOrderItem)bundleOrderItem.clone();
            for (int x = 0; x < temp.getDiscreteOrderItems().size(); ++x) {
                temp.getDiscreteOrderItems().get(x).setId(bundleOrderItem.getDiscreteOrderItems().get(x).getId());
            }
            temp.setId(-1L);
            searchHit.add(temp);
        }
    }

    @Override
    public void initializeSplitItems(PromotableOrder order) {
        List<PromotableOrderItem> items = order.getDiscountableDiscreteOrderItems();
        for (PromotableOrderItem item : items) {
            ArrayList<PromotableOrderItem> temp = new ArrayList<PromotableOrderItem>();
            temp.add(item);
            OrderItemSplitContainer container = new OrderItemSplitContainer();
            container.setKey(item.getDelegate());
            container.setSplitItems(temp);
            order.getSplitItems().add(container);
        }
    }

    protected void gatherOrderLinkedBundleOrderItems(Order order) throws PricingException {
        HashMap<String, BundleOrderItem> gatherBundle = new HashMap<String, BundleOrderItem>();
        ArrayList<BundleOrderItem> bundlesToRemove = new ArrayList<BundleOrderItem>();
        for (OrderItem orderItem : order.getOrderItems()) {
            if (!(orderItem instanceof BundleOrderItem)) continue;
            String identifier = this.buildIdentifier(orderItem, null);
            BundleOrderItem retrieved = (BundleOrderItem)gatherBundle.get(identifier);
            if (retrieved == null) {
                gatherBundle.put(identifier, (BundleOrderItem)orderItem);
                continue;
            }
            retrieved.setQuantity(retrieved.getQuantity() + orderItem.getQuantity());
            bundlesToRemove.add((BundleOrderItem)orderItem);
        }
        for (BundleOrderItem bundleOrderItem : gatherBundle.values()) {
            this.orderItemService.saveOrderItem(bundleOrderItem);
        }
        for (BundleOrderItem bundleOrderItem : bundlesToRemove) {
            try {
                this.orderService.removeItem(order.getId(), bundleOrderItem.getId(), false);
            }
            catch (RemoveFromCartException e) {
                throw new PricingException("Item could not be removed", e);
            }
        }
    }

    protected void gatherOrderLinkedDiscreteOrderItems(Order order) throws PricingException {
        ArrayList<DiscreteOrderItem> itemsToRemove = new ArrayList<DiscreteOrderItem>();
        HashMap<String, OrderItem> gatheredItem = new HashMap<String, OrderItem>();
        for (OrderItem orderItem : order.getOrderItems()) {
            if (orderItem instanceof BundleOrderItem) {
                for (DiscreteOrderItem discreteOrderItem : ((BundleOrderItem)orderItem).getDiscreteOrderItems()) {
                    this.gatherOrderLinkedDiscreteOrderItem(itemsToRemove, gatheredItem, discreteOrderItem, String.valueOf(orderItem.getId()));
                }
                continue;
            }
            this.gatherOrderLinkedDiscreteOrderItem(itemsToRemove, gatheredItem, (DiscreteOrderItem)orderItem, null);
        }
        for (OrderItem orderItem : gatheredItem.values()) {
            this.orderItemService.saveOrderItem(orderItem);
        }
        for (DiscreteOrderItem discreteOrderItem : itemsToRemove) {
            if (discreteOrderItem.getBundleOrderItem() == null) {
                try {
                    this.orderService.removeItem(order.getId(), discreteOrderItem.getId(), false);
                    continue;
                }
                catch (RemoveFromCartException e) {
                    throw new PricingException("Could not remove item", e);
                }
            }
            BundleOrderItem bundleOrderItem = discreteOrderItem.getBundleOrderItem();
            this.fulfillmentGroupService.removeOrderItemFromFullfillmentGroups(order, discreteOrderItem);
            bundleOrderItem.getDiscreteOrderItems().remove(discreteOrderItem);
            discreteOrderItem.setBundleOrderItem(null);
            this.orderItemService.saveOrderItem(bundleOrderItem);
        }
    }

    protected void gatherFulfillmentGroupLinkedBundleOrderItems(Order order) throws PricingException {
        ArrayList<BundleOrderItem> bundlesToRemove = new ArrayList<BundleOrderItem>();
        HashMap gatherBundle = new HashMap();
        for (FulfillmentGroup group : order.getFulfillmentGroups()) {
            HashMap<String, Object[]> gatheredItem = (HashMap<String, Object[]>)gatherBundle.get(group.getId());
            if (gatheredItem == null) {
                gatheredItem = new HashMap<String, Object[]>();
                gatherBundle.put(group.getId(), gatheredItem);
            }
            for (FulfillmentGroupItem fgItem : group.getFulfillmentGroupItems()) {
                OrderItem orderItem = fgItem.getOrderItem();
                if (!(orderItem instanceof BundleOrderItem)) continue;
                String identifier = this.buildIdentifier(orderItem, null);
                Object[] gatheredOrderItem = (Object[])gatheredItem.get(identifier);
                if (gatheredOrderItem == null) {
                    gatheredItem.put(identifier, new Object[]{orderItem, fgItem});
                    continue;
                }
                ((OrderItem)gatheredOrderItem[0]).setQuantity(((OrderItem)gatheredOrderItem[0]).getQuantity() + orderItem.getQuantity());
                ((FulfillmentGroupItem)gatheredOrderItem[1]).setQuantity(((FulfillmentGroupItem)gatheredOrderItem[1]).getQuantity() + fgItem.getQuantity());
                bundlesToRemove.add((BundleOrderItem)orderItem);
            }
        }
        for (Map values : gatherBundle.values()) {
            for (Object[] item : values.values()) {
                this.orderItemService.saveOrderItem((OrderItem)item[0]);
                this.fulfillmentGroupItemDao.save((FulfillmentGroupItem)item[1]);
            }
        }
        for (BundleOrderItem orderItem : bundlesToRemove) {
            try {
                this.orderService.removeItem(order.getId(), orderItem.getId(), false);
            }
            catch (RemoveFromCartException e) {
                throw new PricingException("Item could not be removed", e);
            }
        }
    }

    protected void gatherFulfillmentGroupLinkedDiscreteOrderItems(Order order, List<OrderMultishipOption> options) throws PricingException {
        ArrayList<DiscreteOrderItem> itemsToRemove = new ArrayList<DiscreteOrderItem>();
        ArrayList<FulfillmentGroupItem> fgItemsToRemove = new ArrayList<FulfillmentGroupItem>();
        HashMap<Long, HashMap<String, Object[]>> gatherMap = new HashMap<Long, HashMap<String, Object[]>>();
        for (FulfillmentGroup group : order.getFulfillmentGroups()) {
            HashMap<String, Object[]> gatheredItem = (HashMap<String, Object[]>)gatherMap.get(group.getId());
            if (gatheredItem == null) {
                gatheredItem = new HashMap<String, Object[]>();
                gatherMap.put(group.getId(), gatheredItem);
            }
            for (FulfillmentGroupItem fgItem : group.getFulfillmentGroupItems()) {
                OrderItem orderItem = fgItem.getOrderItem();
                if (orderItem instanceof BundleOrderItem) {
                    for (DiscreteOrderItem discreteOrderItem : ((BundleOrderItem)orderItem).getDiscreteOrderItems()) {
                        if (!CollectionUtils.isEmpty(orderItem.getOrderItemAdjustments())) continue;
                        this.gatherFulfillmentGroupLinkedDiscreteOrderItem(itemsToRemove, fgItemsToRemove, gatheredItem, fgItem, discreteOrderItem, String.valueOf(orderItem.getId()), options, true);
                    }
                    continue;
                }
                if (!CollectionUtils.isEmpty(orderItem.getOrderItemAdjustments())) continue;
                this.gatherFulfillmentGroupLinkedDiscreteOrderItem(itemsToRemove, fgItemsToRemove, gatheredItem, fgItem, (DiscreteOrderItem)orderItem, null, options, true);
            }
        }
        for (Map values : gatherMap.values()) {
            for (Object[] item : values.values()) {
                this.orderItemService.saveOrderItem((OrderItem)item[0]);
                this.fulfillmentGroupItemDao.save((FulfillmentGroupItem)item[1]);
            }
        }
        for (FulfillmentGroupItem fgItem : fgItemsToRemove) {
            FulfillmentGroup fg = fgItem.getFulfillmentGroup();
            fg.getFulfillmentGroupItems().remove(fgItem);
            this.fulfillmentGroupItemDao.delete(fgItem);
            if (!fg.getFulfillmentGroupItems().isEmpty()) continue;
            order.getFulfillmentGroups().remove(fg);
            fg.setOrder(null);
        }
        for (DiscreteOrderItem orderItem : itemsToRemove) {
            if (orderItem.getBundleOrderItem() == null) {
                orderItem.getOrder().getOrderItems().remove(orderItem);
                orderItem.setOrder(null);
                continue;
            }
            BundleOrderItem bundleOrderItem = orderItem.getBundleOrderItem();
            bundleOrderItem.getDiscreteOrderItems().remove(orderItem);
            orderItem.setBundleOrderItem(null);
            this.orderItemService.saveOrderItem(bundleOrderItem);
        }
    }

    protected void gatherOrderLinkedDiscreteOrderItem(List<DiscreteOrderItem> itemsToRemove, Map<String, OrderItem> gatheredItem, DiscreteOrderItem orderItem, String extraIdentifier) {
        if (CollectionUtils.isEmpty(orderItem.getOrderItemAdjustments())) {
            String identifier = this.buildIdentifier(orderItem, extraIdentifier);
            OrderItem gatheredOrderItem = gatheredItem.get(identifier);
            if (gatheredOrderItem == null) {
                gatheredItem.put(identifier, orderItem);
                return;
            }
            gatheredOrderItem.setQuantity(gatheredOrderItem.getQuantity() + orderItem.getQuantity());
            itemsToRemove.add(orderItem);
        }
    }

    protected void gatherFulfillmentGroupLinkedDiscreteOrderItem(List<DiscreteOrderItem> itemsToRemove, List<FulfillmentGroupItem> fgItemsToRemove, Map<String, Object[]> gatheredItem, FulfillmentGroupItem fgItem, DiscreteOrderItem orderItem, String extraIdentifier, List<OrderMultishipOption> options, boolean includePrice) {
        String identifier = this.buildIdentifier(orderItem, extraIdentifier, includePrice);
        Object[] gatheredOrderItem = gatheredItem.get(identifier);
        if (gatheredOrderItem == null) {
            gatheredItem.put(identifier, new Object[]{orderItem, fgItem});
            return;
        }
        for (OrderMultishipOption option : options) {
            if (!option.getOrderItem().getId().equals(orderItem.getId())) continue;
            option.setOrderItem((OrderItem)gatheredOrderItem[0]);
            this.orderMultishipOptionService.save(option);
        }
        ((FulfillmentGroupItem)gatheredOrderItem[1]).setQuantity(((FulfillmentGroupItem)gatheredOrderItem[1]).getQuantity() + fgItem.getQuantity());
        if (!((OrderItem)gatheredOrderItem[0]).getId().equals(orderItem.getId())) {
            ((OrderItem)gatheredOrderItem[0]).setQuantity(((OrderItem)gatheredOrderItem[0]).getQuantity() + fgItem.getQuantity());
            itemsToRemove.add(orderItem);
        }
        fgItemsToRemove.add(fgItem);
    }

    private Long getBundleId(OrderItem item) {
        DiscreteOrderItem discreteItem;
        if (item instanceof DiscreteOrderItem && (discreteItem = (DiscreteOrderItem)item).getBundleOrderItem() != null) {
            return discreteItem.getBundleOrderItem().getId();
        }
        return null;
    }

    protected void mergeSplitDiscreteOrderItems(PromotableOrder order) throws PricingException {
        if (CollectionUtils.isEmpty(order.getDelegate().getFulfillmentGroups())) {
            FulfillmentGroup fg = this.fulfillmentGroupService.createEmptyFulfillmentGroup();
            fg.setOrder(order.getDelegate());
            order.getDelegate().getFulfillmentGroups().add(fg);
        }
        ArrayList<PromotableOrderItem> itemsToRemove = new ArrayList<PromotableOrderItem>();
        ArrayList<DiscreteOrderItem> delegatesToRemove = new ArrayList<DiscreteOrderItem>();
        Iterator<PromotableOrderItem> finalItems = order.getDiscountableDiscreteOrderItems().iterator();
        HashMap<String, PromotableOrderItem> allItems = new HashMap<String, PromotableOrderItem>();
        while (finalItems.hasNext()) {
            PromotableOrderItem nextItem = finalItems.next();
            List<PromotableOrderItem> mySplits = order.searchSplitItems(nextItem);
            if (CollectionUtils.isEmpty(mySplits)) continue;
            PromotableOrderItem cloneItem = nextItem.clone();
            cloneItem.clearAllDiscount();
            cloneItem.clearAllQualifiers();
            cloneItem.removeAllAdjustments();
            cloneItem.setQuantity(0);
            Iterator<PromotableOrderItem> splitItemIterator = mySplits.iterator();
            while (splitItemIterator.hasNext()) {
                PromotableOrderItem splitItem = splitItemIterator.next();
                if (splitItem.isHasOrderItemAdjustments()) continue;
                cloneItem.setQuantity(cloneItem.getQuantity() + splitItem.getQuantity());
                splitItemIterator.remove();
            }
            if (cloneItem.getQuantity() > 0) {
                String identifier = String.valueOf(cloneItem.getSku().getId());
                Long bundleItemId = this.getBundleId(cloneItem.getDelegate());
                if (bundleItemId != null) {
                    identifier = identifier + bundleItemId;
                }
                if (allItems.containsKey(identifier)) {
                    PromotableOrderItem savedItem = (PromotableOrderItem)allItems.get(identifier);
                    savedItem.setQuantity(savedItem.getQuantity() + cloneItem.getQuantity());
                } else {
                    allItems.put(identifier, cloneItem);
                    mySplits.add(cloneItem);
                }
            }
            if (nextItem.getDelegate().getBundleOrderItem() == null) {
                if (mySplits.contains(nextItem)) {
                    mySplits.remove(nextItem);
                    continue;
                }
                itemsToRemove.add(nextItem);
                delegatesToRemove.add(nextItem.getDelegate());
                continue;
            }
            itemsToRemove.add(nextItem);
            delegatesToRemove.add(nextItem.getDelegate());
        }
        for (OrderItemSplitContainer key : order.getSplitItems()) {
            FulfillmentGroupItem fgItem;
            List<PromotableOrderItem> mySplits = key.getSplitItems();
            if (CollectionUtils.isEmpty(mySplits)) continue;
            FulfillmentGroup identifiedFg = null;
            for (FulfillmentGroup fg : order.getDelegate().getFulfillmentGroups()) {
                Iterator<FulfillmentGroupItem> fgItems = fg.getFulfillmentGroupItems().iterator();
                while (fgItems.hasNext()) {
                    fgItem = fgItems.next();
                    if (!fgItem.getOrderItem().equals(key.getKey())) continue;
                    if (identifiedFg == null) {
                        identifiedFg = fg;
                    }
                    this.fulfillmentGroupItemDao.delete(fgItem);
                    fgItems.remove();
                }
            }
            if (identifiedFg == null) {
                identifiedFg = order.getDelegate().getFulfillmentGroups().get(0);
            }
            for (PromotableOrderItem myItem : mySplits) {
                myItem.assignFinalPrice();
                DiscreteOrderItem delegateItem = myItem.getDelegate();
                if (delegateItem.getBundleOrderItem() == null) {
                    delegateItem = (DiscreteOrderItem)this.addOrderItemToOrder(order.getDelegate(), delegateItem, false);
                    block6: for (int j = 0; j < delegateItem.getQuantity(); ++j) {
                        Iterator<OrderMultishipOption> itr = new ArrayList<OrderMultishipOption>(order.getMultiShipOptions()).iterator();
                        while (itr.hasNext()) {
                            OrderMultishipOption option = itr.next();
                            if (!(option.getOrderItem() instanceof DiscreteOrderItem) || !option.getOrderItem().equals(key.getKey())) continue;
                            option.setOrderItem(delegateItem);
                            this.orderMultishipOptionService.save(option);
                            itr.remove();
                            continue block6;
                        }
                    }
                    fgItem = this.fulfillmentGroupItemDao.create();
                    fgItem.setQuantity(delegateItem.getQuantity());
                    fgItem.setOrderItem(delegateItem);
                    fgItem.setFulfillmentGroup(identifiedFg);
                    fgItem = this.fulfillmentGroupItemDao.save(fgItem);
                    identifiedFg.getFulfillmentGroupItems().add(fgItem);
                }
                myItem.setDelegate(delegateItem);
            }
        }
        ArrayList<GiftWrapOrderItem> giftWrapItems = new ArrayList<GiftWrapOrderItem>();
        for (DiscreteOrderItem discreteOrderItem : order.getDelegate().getDiscreteOrderItems()) {
            if (!(discreteOrderItem instanceof GiftWrapOrderItem)) continue;
            if (!delegatesToRemove.contains(discreteOrderItem)) {
                giftWrapItems.add((GiftWrapOrderItem)discreteOrderItem);
                continue;
            }
            Iterator<OrderItem> wrappedItems = ((GiftWrapOrderItem)discreteOrderItem).getWrappedItems().iterator();
            while (wrappedItems.hasNext()) {
                OrderItem wrappedItem = wrappedItems.next();
                wrappedItem.setGiftWrapOrderItem(null);
                wrappedItems.remove();
            }
        }
        for (PromotableOrderItem itemToRemove : itemsToRemove) {
            DiscreteOrderItem delegateItem = itemToRemove.getDelegate();
            this.mergeSplitGiftWrapOrderItems(order, giftWrapItems, itemToRemove, delegateItem);
            if (delegateItem.getBundleOrderItem() != null) continue;
            Iterator<OrderItem> orderItems = order.getDelegate().getOrderItems().iterator();
            while (orderItems.hasNext()) {
                OrderItem orderItem = orderItems.next();
                if (!orderItem.getId().equals(itemToRemove.getDelegate().getId())) continue;
                orderItem.setOrder(null);
                orderItems.remove();
            }
        }
    }

    protected OrderItem addOrderItemToOrder(Order order, OrderItem newOrderItem, Boolean priceOrder) throws PricingException {
        List<OrderItem> orderItems = order.getOrderItems();
        newOrderItem.setOrder(order);
        newOrderItem = this.orderItemService.saveOrderItem(newOrderItem);
        orderItems.add(newOrderItem);
        this.orderService.save(order, priceOrder);
        return newOrderItem;
    }

    protected void mergeSplitGiftWrapOrderItems(PromotableOrder order, List<GiftWrapOrderItem> giftWrapItems, PromotableOrderItem itemToRemove, DiscreteOrderItem delegateItem) {
        for (GiftWrapOrderItem giftWrapOrderItem : giftWrapItems) {
            ArrayList<DiscreteOrderItem> newItems = new ArrayList<DiscreteOrderItem>();
            Iterator<OrderItem> wrappedItems = giftWrapOrderItem.getWrappedItems().iterator();
            boolean foundItems = false;
            while (wrappedItems.hasNext()) {
                OrderItem wrappedItem = wrappedItems.next();
                if (!wrappedItem.equals(delegateItem)) continue;
                foundItems = true;
                List<PromotableOrderItem> searchHits = order.searchSplitItems(itemToRemove);
                if (!CollectionUtils.isEmpty(searchHits)) {
                    for (PromotableOrderItem searchHit : searchHits) {
                        newItems.add(searchHit.getDelegate());
                        searchHit.getDelegate().setGiftWrapOrderItem(giftWrapOrderItem);
                    }
                }
                delegateItem.setGiftWrapOrderItem(null);
                wrappedItems.remove();
            }
            if (!foundItems) continue;
            giftWrapOrderItem.getWrappedItems().addAll(newItems);
            this.orderItemService.saveOrderItem(giftWrapOrderItem);
        }
    }

    protected void mergeSplitBundleOrderItems(PromotableOrder order) throws PricingException {
        List<BundleOrderItemSplitContainer> bundleContainers = order.getBundleSplitItems();
        for (BundleOrderItemSplitContainer bundleOrderItemSplitContainer : bundleContainers) {
            if (!bundleOrderItemSplitContainer.getKey().shouldSumItems()) continue;
            BundleOrderItem val = bundleOrderItemSplitContainer.getSplitItems().get(0);
            val.getDiscreteOrderItems().clear();
            val.setId(null);
            ArrayList<DiscreteOrderItem> itemsToAdd = new ArrayList<DiscreteOrderItem>();
            for (DiscreteOrderItem discreteOrderItem : bundleOrderItemSplitContainer.getKey().getDiscreteOrderItems()) {
                FulfillmentGroup identifiedFg = null;
                for (FulfillmentGroup fg : order.getDelegate().getFulfillmentGroups()) {
                    Iterator<FulfillmentGroupItem> fgItems = fg.getFulfillmentGroupItems().iterator();
                    while (fgItems.hasNext()) {
                        FulfillmentGroupItem fgItem = fgItems.next();
                        if (!fgItem.getOrderItem().getId().equals(discreteOrderItem.getId())) continue;
                        if (identifiedFg == null) {
                            identifiedFg = fg;
                        }
                        this.fulfillmentGroupItemDao.delete(fgItem);
                        fgItems.remove();
                    }
                }
                if (identifiedFg == null) {
                    identifiedFg = order.getDelegate().getFulfillmentGroups().get(0);
                }
                PromotableOrderItemImpl poi = new PromotableOrderItemImpl(discreteOrderItem, null, null);
                List<PromotableOrderItem> items = order.searchSplitItems(poi);
                for (PromotableOrderItem temp : items) {
                    DiscreteOrderItem delegate = temp.getDelegate();
                    delegate.setId(null);
                    delegate.setBundleOrderItem(null);
                    delegate = (DiscreteOrderItem)this.orderItemService.saveOrderItem(delegate);
                    delegate.setBundleOrderItem(val);
                    itemsToAdd.add(delegate);
                    block5: for (int j = 0; j < delegate.getQuantity(); ++j) {
                        Iterator<OrderMultishipOption> itr = new ArrayList<OrderMultishipOption>(order.getMultiShipOptions()).iterator();
                        while (itr.hasNext()) {
                            OrderMultishipOption option = itr.next();
                            if (!(option.getOrderItem() instanceof DiscreteOrderItem) || !option.getOrderItem().equals(discreteOrderItem)) continue;
                            option.setOrderItem(delegate);
                            this.orderMultishipOptionService.save(option);
                            itr.remove();
                            continue block5;
                        }
                    }
                    FulfillmentGroupItem fgItem = this.fulfillmentGroupItemDao.create();
                    fgItem.setQuantity(delegate.getQuantity());
                    fgItem.setOrderItem(delegate);
                    fgItem.setFulfillmentGroup(identifiedFg);
                    fgItem = this.fulfillmentGroupItemDao.save(fgItem);
                    identifiedFg.getFulfillmentGroupItems().add(fgItem);
                }
            }
            val.getDiscreteOrderItems().addAll(itemsToAdd);
            order.getDelegate().getOrderItems().remove(bundleOrderItemSplitContainer.getKey());
            bundleOrderItemSplitContainer.getKey().setOrder(null);
            val = (BundleOrderItem)this.addOrderItemToOrder(order.getDelegate(), val, false);
        }
        this.orderService.save(order.getDelegate(), false);
    }

    @Override
    public String buildIdentifier(OrderItem orderItem, String extraIdentifier) {
        return this.buildIdentifier(orderItem, extraIdentifier, true);
    }

    public String buildIdentifier(OrderItem orderItem, String extraIdentifier, boolean includePrice) {
        StringBuffer identifier = new StringBuffer();
        if (orderItem.getSplitParentItemId() != null || this.orderService.getAutomaticallyMergeLikeItems()) {
            if (!this.orderService.getAutomaticallyMergeLikeItems()) {
                identifier.append(orderItem.getSplitParentItemId());
            } else if (orderItem instanceof BundleOrderItem) {
                BundleOrderItem bundleOrderItem = (BundleOrderItem)orderItem;
                if (bundleOrderItem.getSku() != null) {
                    identifier.append(bundleOrderItem.getSku().getId());
                } else if (orderItem.getSplitParentItemId() != null) {
                    identifier.append(orderItem.getSplitParentItemId());
                } else {
                    identifier.append(orderItem.getId());
                }
            } else if (orderItem instanceof DiscreteOrderItem) {
                DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
                identifier.append(discreteOrderItem.getSku().getId());
                identifier.append('_').append(discreteOrderItem.getBundleOrderItem());
            } else if (orderItem.getSplitParentItemId() != null) {
                identifier.append(orderItem.getSplitParentItemId());
            } else {
                identifier.append(orderItem.getId());
            }
            if (includePrice) {
                identifier.append('_').append(orderItem.getPrice().stringValue());
            }
            if (extraIdentifier != null) {
                identifier.append('_').append(extraIdentifier);
            }
            this.addOptionAttributesToIdentifier(identifier, orderItem);
        } else {
            identifier.append(orderItem.getId());
        }
        return identifier.toString();
    }

    protected void addOptionAttributesToIdentifier(StringBuffer identifier, OrderItem orderItem) {
        if (orderItem.getOrderItemAttributes() != null && orderItem.getOrderItemAttributes().size() > 0) {
            ArrayList<String> valueList = new ArrayList<String>();
            for (OrderItemAttribute itemAttribute : orderItem.getOrderItemAttributes().values()) {
                valueList.add(itemAttribute.getName() + "_" + itemAttribute.getValue());
            }
            Collections.sort(valueList);
            identifier.append('_');
            for (String value : valueList) {
                identifier.append(value);
            }
        }
    }

    @Override
    public FulfillmentGroupItemDao getFulfillmentGroupItemDao() {
        return this.fulfillmentGroupItemDao;
    }

    @Override
    public void setFulfillmentGroupItemDao(FulfillmentGroupItemDao fulfillmentGroupItemDao) {
        this.fulfillmentGroupItemDao = fulfillmentGroupItemDao;
    }

    @Override
    public FulfillmentGroupService getFulfillmentGroupService() {
        return this.fulfillmentGroupService;
    }

    @Override
    public void setFulfillmentGroupService(FulfillmentGroupService fulfillmentGroupService) {
        this.fulfillmentGroupService = fulfillmentGroupService;
    }

    @Override
    public OrderItemService getOrderItemService() {
        return this.orderItemService;
    }

    @Override
    public void setOrderItemService(OrderItemService orderItemService) {
        this.orderItemService = orderItemService;
    }

    @Override
    public OrderMultishipOptionService getOrderMultishipOptionService() {
        return this.orderMultishipOptionService;
    }

    @Override
    public void setOrderMultishipOptionService(OrderMultishipOptionService orderMultishipOptionService) {
        this.orderMultishipOptionService = orderMultishipOptionService;
    }

    @Override
    public OrderService getOrderService() {
        return this.orderService;
    }

    @Override
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    @Override
    public PromotableItemFactory getPromotableItemFactory() {
        return this.promotableItemFactory;
    }

    @Override
    public void setPromotableItemFactory(PromotableItemFactory promotableItemFactory) {
        this.promotableItemFactory = promotableItemFactory;
    }
}

