/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.workflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutContext;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.offer.dao.OfferAuditDao;
import org.broadleafcommerce.core.offer.domain.Adjustment;
import org.broadleafcommerce.core.offer.service.exception.OfferMaxUseExceededException;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class VerifyCustomerMaxOfferUsesActivity
extends BaseActivity {
    @Resource(name="blOfferAuditDao")
    private OfferAuditDao offerAuditDao;

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        HashMap<Long, Long> offerIdToAllowedUsesMap = new HashMap<Long, Long>();
        CheckoutSeed seed = ((CheckoutContext)context).getSeedData();
        Order order = seed.getOrder();
        if (order != null) {
            this.addOfferIds(order.getOrderAdjustments(), offerIdToAllowedUsesMap);
            if (order.getOrderItems() != null) {
                for (OrderItem item : order.getOrderItems()) {
                    this.addOfferIds(item.getOrderItemAdjustments(), offerIdToAllowedUsesMap);
                }
            }
            if (order.getFulfillmentGroups() != null) {
                for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                    this.addOfferIds(fg.getFulfillmentGroupAdjustments(), offerIdToAllowedUsesMap);
                }
            }
            if (!this.checkOffers(offerIdToAllowedUsesMap, order)) {
                throw new OfferMaxUseExceededException("The customer has used this offer code more than the maximum allowed number of times.");
            }
        }
        return context;
    }

    private boolean checkOffers(Map<Long, Long> offerIdToAllowedUsesMap, Order order) {
        boolean orderVerified = true;
        if (order.getCustomer() != null && order.getCustomer().getId() != null) {
            Long customerId = order.getCustomer().getId();
            for (Long offerId : offerIdToAllowedUsesMap.keySet()) {
                Long allowedUses = offerIdToAllowedUsesMap.get(offerId);
                Long currentUses = this.offerAuditDao.countUsesByCustomer(customerId, offerId);
                if (currentUses == null || currentUses < allowedUses) continue;
                return false;
            }
        }
        return true;
    }

    private void addOfferIds(List<? extends Adjustment> adjustments, Map<Long, Long> offerIdToAllowedUsesMap) {
        if (adjustments != null) {
            for (Adjustment adjustment : adjustments) {
                Long maxUsesPerCustomer;
                if (adjustment.getOffer() == null || (maxUsesPerCustomer = adjustment.getOffer().getMaxUsesPerCustomer()) == null || maxUsesPerCustomer <= 0L) continue;
                offerIdToAllowedUsesMap.put(adjustment.getOffer().getId(), maxUsesPerCustomer);
            }
        }
    }
}

