/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.MergeCartService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.MergeCartResponse;
import org.broadleafcommerce.core.order.service.call.ReconstructCartResponse;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.stereotype.Service;

@Service(value="blMergeCartService")
public class MergeCartServiceImpl
implements MergeCartService {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;

    @Override
    public MergeCartResponse mergeCart(Customer customer, Order anonymousCart) throws PricingException, RemoveFromCartException {
        return this.mergeCart(customer, anonymousCart, true);
    }

    @Override
    public ReconstructCartResponse reconstructCart(Customer customer) throws PricingException, RemoveFromCartException {
        return this.reconstructCart(customer, true);
    }

    @Override
    public MergeCartResponse mergeCart(Customer customer, Order anonymousCart, boolean priceOrder) throws PricingException, RemoveFromCartException {
        MergeCartResponse mergeCartResponse = new MergeCartResponse();
        mergeCartResponse.setMerged(false);
        ReconstructCartResponse reconstructCartResponse = this.reconstructCart(customer, false);
        mergeCartResponse.setRemovedItems(reconstructCartResponse.getRemovedItems());
        Order customerCart = reconstructCartResponse.getOrder();
        if (anonymousCart != null && customerCart != null && anonymousCart.equals(customerCart)) {
            this.setNewCartOwnership(anonymousCart, customer);
            mergeCartResponse.setOrder(anonymousCart);
        } else if (anonymousCart == null || anonymousCart.getOrderItems().size() == 0) {
            mergeCartResponse.setOrder(customerCart);
        } else if (customerCart == null || customerCart.getOrderItems().size() == 0) {
            this.setNewCartOwnership(anonymousCart, customer);
            mergeCartResponse.setOrder(anonymousCart);
        } else {
            this.setSavedCartAttributes(customerCart);
            this.orderService.save(customerCart, false);
            this.setNewCartOwnership(anonymousCart, customer);
            mergeCartResponse.setOrder(anonymousCart);
        }
        if (mergeCartResponse.getOrder() != null) {
            Order savedCart = this.orderService.save(mergeCartResponse.getOrder(), priceOrder);
            mergeCartResponse.setOrder(savedCart);
        }
        return mergeCartResponse;
    }

    @Override
    public ReconstructCartResponse reconstructCart(Customer customer, boolean priceOrder) throws PricingException, RemoveFromCartException {
        ReconstructCartResponse reconstructCartResponse = new ReconstructCartResponse();
        Order customerCart = this.orderService.findCartForCustomer(customer);
        if (customerCart != null) {
            ArrayList<OrderItem> itemsToRemove = new ArrayList<OrderItem>();
            for (OrderItem orderItem : customerCart.getOrderItems()) {
                if (orderItem instanceof DiscreteOrderItem) {
                    DiscreteOrderItem doi = (DiscreteOrderItem)orderItem;
                    if (this.checkActive(doi) && this.checkInventory(doi) && this.checkOtherValidity(orderItem)) continue;
                    itemsToRemove.add(orderItem);
                    continue;
                }
                if (!(orderItem instanceof BundleOrderItem)) continue;
                BundleOrderItem bundleOrderItem = (BundleOrderItem)orderItem;
                for (DiscreteOrderItem doi : bundleOrderItem.getDiscreteOrderItems()) {
                    if (this.checkActive(doi) && this.checkInventory(doi) && this.checkOtherValidity(orderItem)) continue;
                    itemsToRemove.add(doi.getBundleOrderItem());
                }
            }
            block2: for (OrderItem orderItem : customerCart.getOrderItems()) {
                if (!(orderItem instanceof GiftWrapOrderItem)) continue;
                for (OrderItem wrappedItem : ((GiftWrapOrderItem)orderItem).getWrappedItems()) {
                    if (!itemsToRemove.contains(wrappedItem)) continue;
                    itemsToRemove.add(orderItem);
                    continue block2;
                }
            }
            for (OrderItem item : itemsToRemove) {
                this.orderService.removeItem(customerCart.getId(), item.getId(), false);
            }
            reconstructCartResponse.setRemovedItems(itemsToRemove);
            customerCart = this.orderService.save(customerCart, priceOrder);
        }
        reconstructCartResponse.setOrder(customerCart);
        return reconstructCartResponse;
    }

    protected void setSavedCartAttributes(Order cart) {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, ''yy");
        Date cartLastUpdated = cart.getAuditable().getDateUpdated();
        cart.setName("Previously saved cart - " + sdf.format(cartLastUpdated));
        cart.setStatus(OrderStatus.NAMED);
    }

    protected void setNewCartOwnership(Order cart, Customer customer) {
        cart.setCustomer(customer);
        if (cart != null && StringUtils.isNotBlank((String)customer.getEmailAddress())) {
            cart.setEmailAddress(customer.getEmailAddress());
        }
    }

    protected boolean checkActive(DiscreteOrderItem orderItem) {
        return orderItem.getSku().isActive(orderItem.getProduct(), orderItem.getCategory());
    }

    protected boolean checkInventory(DiscreteOrderItem orderItem) {
        return true;
    }

    protected boolean checkOtherValidity(OrderItem orderItem) {
        return true;
    }
}

