/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.params.CoreAdminParams;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.SolrContext;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.springframework.stereotype.Service;

@Service(value="blSolrHelperService")
public class SolrHelperServiceImpl
implements SolrHelperService {
    private static final Log LOG = LogFactory.getLog(SolrHelperServiceImpl.class);
    private static final String GLOBAL_FACET_TAG_FIELD = "a";
    private static final String DEFAULT_NAMESPACE = "d";
    protected static Locale defaultLocale;
    protected static SolrServer server;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;

    @Override
    public void swapActiveCores() throws ServiceException {
        if (SolrContext.isSingleCoreMode()) {
            LOG.debug((Object)"In single core mode. There are no cores to swap.");
        } else {
            LOG.debug((Object)"Swapping active cores");
            CoreAdminRequest car = new CoreAdminRequest();
            car.setCoreName("primary");
            car.setOtherCoreName("reindex");
            car.setAction(CoreAdminParams.CoreAdminAction.SWAP);
            try {
                SolrContext.getServer().request((SolrRequest)car);
                SolrContext.getServer().commit();
            }
            catch (Exception e) {
                LOG.error((Object)e);
                throw new ServiceException("Unable to swap cores", (Throwable)e);
            }
        }
    }

    @Override
    public String getCurrentNamespace() {
        return DEFAULT_NAMESPACE;
    }

    @Override
    public String getGlobalFacetTagField() {
        return GLOBAL_FACET_TAG_FIELD;
    }

    @Override
    public String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType, String prefix) {
        return prefix + field.getPropertyName() + "_" + searchableFieldType.getType();
    }

    @Override
    public String getPropertyNameForFieldFacet(Field field, String prefix) {
        if (field.getFacetFieldType() == null) {
            return null;
        }
        return prefix + field.getPropertyName() + "_" + field.getFacetFieldType().getType();
    }

    @Override
    public String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType) {
        String prefix = "";
        if (!searchableFieldType.equals(FieldType.PRICE)) {
            prefix = this.getLocalePrefix();
        }
        return this.getPropertyNameForFieldSearchable(field, searchableFieldType, prefix);
    }

    @Override
    public String getPropertyNameForFieldFacet(Field field) {
        FieldType fieldType = field.getFacetFieldType();
        if (fieldType == null) {
            return null;
        }
        String prefix = "";
        if (!fieldType.equals(FieldType.PRICE)) {
            prefix = this.getLocalePrefix();
        }
        return this.getPropertyNameForFieldFacet(field, prefix);
    }

    @Override
    public String getNamespaceFieldName() {
        return "namespace";
    }

    @Override
    public String getIdFieldName() {
        return "id";
    }

    @Override
    public String getCategoryFieldName() {
        return "category";
    }

    @Override
    public String getExplicitCategoryFieldName() {
        return "explicitCategory";
    }

    @Override
    public String getSearchableFieldName(String prefix) {
        return prefix + "searchable";
    }

    @Override
    public String getSearchableFieldName() {
        return this.getSearchableFieldName(this.getLocalePrefix());
    }

    @Override
    public String getCategorySortFieldName(Category category) {
        return this.getCategoryFieldName() + "_" + category.getId() + "_" + "sort_i";
    }

    @Override
    public String getLocalePrefix() {
        Locale locale;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            return locale.getLocaleCode() + "_";
        }
        return this.getDefaultLocalePrefix();
    }

    @Override
    public String getDefaultLocalePrefix() {
        return this.getDefaultLocale().getLocaleCode() + "_";
    }

    @Override
    public Locale getDefaultLocale() {
        if (defaultLocale == null) {
            defaultLocale = this.localeService.findDefaultLocale();
        }
        return defaultLocale;
    }
}

