/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.offer.dao.OfferCodeDao;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.domain.OfferCodeImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blOfferCodeDao")
public class OfferCodeDaoImpl
implements OfferCodeDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public OfferCode create() {
        return (OfferCode)this.entityConfiguration.createEntityInstance(OfferCode.class.getName());
    }

    @Override
    public void delete(OfferCode offerCode) {
        if (!this.em.contains((Object)offerCode)) {
            offerCode = this.readOfferCodeById(offerCode.getId());
        }
        this.em.remove((Object)offerCode);
    }

    @Override
    public OfferCode save(OfferCode offerCode) {
        return (OfferCode)this.em.merge((Object)offerCode);
    }

    @Override
    public OfferCode readOfferCodeById(Long offerCodeId) {
        return (OfferCode)this.em.find(OfferCodeImpl.class, (Object)offerCodeId);
    }

    @Override
    public OfferCode readOfferCodeByCode(String code) {
        OfferCode offerCode = null;
        Query query = this.em.createNamedQuery("BC_READ_OFFER_CODE_BY_CODE");
        query.setParameter("code", (Object)code);
        List result = query.getResultList();
        if (result.size() > 0) {
            offerCode = (OfferCode)result.get(0);
        }
        return offerCode;
    }
}

