/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.rating.domain;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.core.rating.domain.RatingDetail;
import org.broadleafcommerce.core.rating.domain.RatingSummary;
import org.broadleafcommerce.core.rating.domain.RatingSummaryImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_RATING_DETAIL")
public class RatingDetailImpl
implements RatingDetail {
    @Id
    @GeneratedValue(generator="RatingDetailId", strategy=GenerationType.TABLE)
    @TableGenerator(name="RatingDetailId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="RatingDetailImpl", allocationSize=50)
    @Column(name="RATING_DETAIL_ID")
    private Long id;
    @Column(name="RATING", nullable=false)
    protected Double rating;
    @Column(name="RATING_SUBMITTED_DATE", nullable=false)
    protected Date ratingSubmittedDate;
    @ManyToOne(targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    @Index(name="RATING_CUSTOMER_INDEX", columnNames={"CUSTOMER_ID"})
    protected Customer customer;
    @ManyToOne(optional=false, targetEntity=RatingSummaryImpl.class)
    @JoinColumn(name="RATING_SUMMARY_ID")
    protected RatingSummary ratingSummary;

    public RatingDetailImpl() {
    }

    public RatingDetailImpl(RatingSummary ratingSummary, Double rating, Date ratingSubmittedDate, Customer customer) {
        this.ratingSummary = ratingSummary;
        this.rating = rating;
        this.ratingSubmittedDate = ratingSubmittedDate;
        this.customer = customer;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Double getRating() {
        return this.rating;
    }

    @Override
    public Date getRatingSubmittedDate() {
        return this.ratingSubmittedDate;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setRating(Double newRating) {
        this.rating = newRating;
    }

    @Override
    public RatingSummary getRatingSummary() {
        return this.ratingSummary;
    }
}

