/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutContext;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.service.CompositePaymentService;
import org.broadleafcommerce.core.payment.service.exception.InsufficientFundsException;
import org.broadleafcommerce.core.payment.service.workflow.CompositePaymentResponse;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.springframework.beans.factory.annotation.Value;

public class PaymentServiceActivity
extends BaseActivity {
    private static final Log LOG = LogFactory.getLog(PaymentServiceActivity.class);
    @Resource(name="blCompositePaymentService")
    private CompositePaymentService compositePaymentService;
    @Value(value="${stop.checkout.on.single.payment.failure}")
    protected Boolean stopCheckoutOnSinglePaymentFailure;

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        CheckoutSeed seed = ((CheckoutContext)context).getSeedData();
        CompositePaymentResponse response = this.compositePaymentService.executePayment(seed.getOrder(), seed.getInfos(), seed.getPaymentResponse());
        for (Map.Entry<PaymentInfo, PaymentResponseItem> entry : response.getPaymentResponse().getResponseItems().entrySet()) {
            this.checkTransactionStatus(context, entry.getValue());
            if (!context.isStopped()) continue;
            String log = "Stopping checkout workflow due to payment response code: ";
            log = log + entry.getValue().getProcessorResponseCode();
            log = log + " and text: ";
            log = log + entry.getValue().getProcessorResponseText();
            log = log + " for payment type: " + entry.getKey().getType().getType();
            LOG.debug((Object)log);
            break;
        }
        Money paidAmount = new Money(0);
        for (Map.Entry<PaymentInfo, PaymentResponseItem> entry : response.getPaymentResponse().getResponseItems().entrySet()) {
            if (!entry.getValue().getTransactionSuccess().booleanValue()) continue;
            paidAmount = paidAmount.add(entry.getValue().getTransactionAmount());
        }
        if (paidAmount.lessThan(seed.getOrder().getRemainingTotal())) {
            throw new InsufficientFundsException(String.format("Order remaining total was [%s] but paid amount was [%s]", seed.getOrder().getTotal(), paidAmount));
        }
        return context;
    }

    protected void checkTransactionStatus(ProcessContext context, PaymentResponseItem paymentResponseItem) {
        if (this.stopCheckoutOnSinglePaymentFailure != null && this.stopCheckoutOnSinglePaymentFailure.booleanValue() && paymentResponseItem.getTransactionSuccess() != null && !paymentResponseItem.getTransactionSuccess().booleanValue()) {
            context.stopProcess();
        }
    }
}

