/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.store.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.core.store.dao.ZipCodeDao;
import org.broadleafcommerce.core.store.domain.ZipCode;
import org.springframework.stereotype.Repository;

@Repository(value="blZipCodeDao")
public class ZipCodeDaoImpl
implements ZipCodeDao {
    @PersistenceContext(unitName="blPU")
    private EntityManager em;

    @Override
    public ZipCode findZipCodeByZipCode(Integer zipCode) {
        Query query = this.em.createNamedQuery("BC_FIND_ZIP_CODE_BY_ZIP_CODE");
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setParameter("zipCode", (Object)zipCode);
        List result = query.getResultList();
        return result.size() > 0 ? (ZipCode)result.get(0) : null;
    }

    @Override
    public ZipCode findBestZipCode(String pCity, String pCounty, String pState, Integer pZipCode, Long pZipGeo) {
        List result;
        Query query;
        if (pZipGeo != null) {
            query = this.em.createNamedQuery("FIND_ZIP_WITH_GEO");
            query.setHint("org.hibernate.cacheable", (Object)true);
            query.setParameter("geo", (Object)pZipGeo);
            query.setParameter("city", (Object)pCity);
            query.setParameter("zipCode", (Object)pZipCode);
            query.setParameter("state", (Object)pState);
            result = query.getResultList();
            if (result.size() > 0) {
                return (ZipCode)result.get(0);
            }
        }
        if (pCounty != null && !"".equals(pCounty.trim())) {
            query = this.em.createNamedQuery("FIND_ZIP_WITH_COUNTY");
            query.setHint("org.hibernate.cacheable", (Object)true);
            query.setParameter("county", (Object)pCounty);
            query.setParameter("city", (Object)pCity);
            query.setParameter("zipCode", (Object)pZipCode);
            query.setParameter("state", (Object)pState);
            result = query.getResultList();
            if (result.size() > 0) {
                return (ZipCode)result.get(0);
            }
        }
        query = this.em.createNamedQuery("FIND_ZIP_WITH_CITY_STATE_ZIP");
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setParameter("city", (Object)pCity);
        query.setParameter("zipCode", (Object)pZipCode);
        query.setParameter("state", (Object)pState);
        result = query.getResultList();
        if (result.size() > 0) {
            return (ZipCode)result.get(0);
        }
        query = this.em.createNamedQuery("FIND_ZIP_WITH_SOUNDEX");
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setParameter("city", (Object)pCity);
        query.setParameter("zipCode", (Object)pZipCode);
        query.setParameter("state", (Object)pState);
        result = query.getResultList();
        if (result.size() > 0) {
            return (ZipCode)result.get(0);
        }
        query = this.em.createNamedQuery("FIND_ZIP_WITH_STATE_ZIP");
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setParameter("zipCode", (Object)pZipCode);
        query.setParameter("state", (Object)pState);
        result = query.getResultList();
        if (result.size() > 0) {
            return (ZipCode)result.get(0);
        }
        query = this.em.createNamedQuery("FIND_ZIP_WITH_STATE");
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setParameter("state", (Object)pState);
        result = query.getResultList();
        if (result.size() > 0) {
            return (ZipCode)result.get(0);
        }
        return null;
    }
}

