/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.marketing.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.marketing.dao.TargetContentDao;
import org.broadleafcommerce.core.marketing.domain.TargetContent;
import org.broadleafcommerce.core.marketing.domain.TargetContentImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blTargetContentDao")
@Deprecated
public class TargetContentDaoImpl
implements TargetContentDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public void delete(Long targetContentId) {
        TargetContent tc = this.readTargetContentById(targetContentId);
        this.em.remove((Object)tc);
    }

    @Override
    public TargetContent save(TargetContent targetContent) {
        return (TargetContent)this.em.merge((Object)targetContent);
    }

    @Override
    public List<TargetContent> readCurrentTargetContentByNameType(String name, String type) {
        Query query = this.em.createNamedQuery("BC_READ_TARGET_CONTENTS_BY_NAME_TYPE");
        query.setParameter("name", (Object)name);
        query.setParameter("type", (Object)type);
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    @Override
    public List<TargetContent> readCurrentTargetContentsByPriority(int priority) {
        Query query = this.em.createNamedQuery("BC_READ_TARGET_CONTENTS_BY_PRIORITY");
        query.setParameter("priority", (Object)priority);
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    @Override
    public TargetContent readTargetContentById(Long targetContentId) {
        return (TargetContent)this.em.find(TargetContentImpl.class, (Object)targetContentId);
    }

    @Override
    public List<TargetContent> readTargetContents() {
        Query query = this.em.createNamedQuery("BC_READ_TARGET_CONTENTS");
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }
}

