/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.domain;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class FieldEntity
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, FieldEntity> TYPES = new HashMap<String, FieldEntity>();
    public static final FieldEntity PRODUCT = new FieldEntity("PRODUCT", "product");
    public static final FieldEntity CUSTOMER = new FieldEntity("CUSTOMER", "customer");
    public static final FieldEntity ORDER = new FieldEntity("ORDER", "order");
    public static final FieldEntity ORDERITEM = new FieldEntity("ORDERITEM", "orderItem");
    public static final FieldEntity OFFER = new FieldEntity("OFFER", "offer");
    private String type;
    private String friendlyType;

    public static FieldEntity getInstance(String type) {
        return TYPES.get(type);
    }

    public FieldEntity() {
    }

    public FieldEntity(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldEntity other = (FieldEntity)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

