/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadleafcommerce.cms.page.dto.PageDTO;
import org.broadleafcommerce.cms.page.service.AbstractPageRuleProcessor;
import org.broadleafcommerce.cms.structure.dto.ItemCriteriaDTO;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.profile.core.domain.Customer;

public class PageCartRuleProcessor
extends AbstractPageRuleProcessor {
    private OrderDao orderDao;

    public boolean checkForMatch(PageDTO page, Map<String, Object> valueMap) {
        List itemCriterias = page.getItemCriteriaDTOList();
        if (itemCriterias != null && itemCriterias.size() > 0) {
            Order order = this.lookupOrderForCustomer((Customer)valueMap.get("customer"));
            if (order == null || order.getOrderItems() == null || order.getOrderItems().size() < 1) {
                return false;
            }
            for (ItemCriteriaDTO itemCriteria : itemCriterias) {
                if (this.checkItemCriteria(itemCriteria, order.getOrderItems())) continue;
                return false;
            }
        }
        return true;
    }

    private Order lookupOrderForCustomer(Customer c) {
        Order o = null;
        if (c != null) {
            o = this.orderDao.readCartForCustomer(c);
        }
        return o;
    }

    private boolean checkItemCriteria(ItemCriteriaDTO itemCriteria, List<OrderItem> orderItems) {
        HashMap<String, OrderItem> vars = new HashMap<String, OrderItem>();
        int foundCount = 0;
        Iterator<OrderItem> items = orderItems.iterator();
        while (foundCount < itemCriteria.getQty() && items.hasNext()) {
            OrderItem currentItem = items.next();
            vars.put("discreteOrderItem", currentItem);
            vars.put("orderItem", currentItem);
            boolean match = this.executeExpression(itemCriteria.getMatchRule(), vars);
            if (!match) continue;
            foundCount += currentItem.getQuantity();
        }
        return foundCount >= itemCriteria.getQty();
    }

    public void setOrderDao(OrderDao orderDao) {
        this.orderDao = orderDao;
    }

    public OrderDao getOrderDao() {
        return this.orderDao;
    }
}

