/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.OrderItemPriceComparator;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemContainer;

public class PromotableOrderImpl
implements PromotableOrder {
    private static final long serialVersionUID = 1L;
    protected PromotableItemFactory itemFactory;
    protected Order order;
    protected List<PromotableOrderItem> allOrderItems;
    protected List<PromotableOrderItem> discountableOrderItems;
    protected boolean currentSortParam = false;
    protected List<PromotableFulfillmentGroup> fulfillmentGroups;
    protected List<PromotableOrderAdjustment> candidateOrderOfferAdjustments = new ArrayList<PromotableOrderAdjustment>();
    protected boolean includeOrderAndItemAdjustments = false;

    public PromotableOrderImpl(Order order, PromotableItemFactory itemFactory, boolean includeOrderAndItemAdjustments) {
        this.order = order;
        this.itemFactory = itemFactory;
        this.includeOrderAndItemAdjustments = includeOrderAndItemAdjustments;
        if (includeOrderAndItemAdjustments) {
            this.createExistingOrderAdjustments();
        }
    }

    protected void createExistingOrderAdjustments() {
        if (this.order.getOrderAdjustments() != null) {
            for (OrderAdjustment adjustment : this.order.getOrderAdjustments()) {
                if (adjustment.getOffer() == null) continue;
                PromotableCandidateOrderOffer pcoo = this.itemFactory.createPromotableCandidateOrderOffer(this, adjustment.getOffer(), adjustment.getValue());
                PromotableOrderAdjustment adj = this.itemFactory.createPromotableOrderAdjustment(pcoo, this, adjustment.getValue());
                this.candidateOrderOfferAdjustments.add(adj);
            }
        }
    }

    @Override
    public void setOrderSubTotalToPriceWithoutAdjustments() {
        Money calculatedSubTotal = this.calculateOrderSubTotalWithoutOrderAdjustments();
        this.order.setSubTotal(calculatedSubTotal);
    }

    @Override
    public void setOrderSubTotalToPriceWithAdjustments() {
        Money calculatedSubTotal = this.calculateSubtotalWithAdjustments();
        this.order.setSubTotal(calculatedSubTotal);
    }

    private Money calculateOrderSubTotalWithoutOrderAdjustments() {
        Money calculatedSubTotal = BroadleafCurrencyUtils.getMoney((BroadleafCurrency)this.order.getCurrency());
        for (OrderItem orderItem : this.order.getOrderItems()) {
            calculatedSubTotal = calculatedSubTotal.add(orderItem.getTotalPrice());
        }
        return calculatedSubTotal;
    }

    @Override
    public List<PromotableOrderItem> getAllOrderItems() {
        if (this.allOrderItems == null) {
            this.allOrderItems = new ArrayList<PromotableOrderItem>();
            for (OrderItem orderItem : this.order.getOrderItems()) {
                this.addPromotableOrderItem(orderItem, this.allOrderItems);
            }
        }
        return this.allOrderItems;
    }

    @Override
    public List<PromotableOrderItem> getDiscountableOrderItems() {
        return this.getDiscountableOrderItems(this.currentSortParam);
    }

    @Override
    public List<PromotableOrderItem> getDiscountableOrderItems(boolean applyDiscountToSalePrice) {
        OrderItemPriceComparator priceComparator;
        if (this.discountableOrderItems == null || this.discountableOrderItems.isEmpty()) {
            this.discountableOrderItems = this.buildPromotableOrderItemsList();
            priceComparator = new OrderItemPriceComparator(applyDiscountToSalePrice);
            Collections.sort(this.discountableOrderItems, priceComparator);
            this.currentSortParam = applyDiscountToSalePrice;
        }
        if (this.currentSortParam != applyDiscountToSalePrice) {
            priceComparator = new OrderItemPriceComparator(applyDiscountToSalePrice);
            Collections.sort(this.discountableOrderItems, priceComparator);
            this.currentSortParam = applyDiscountToSalePrice;
        }
        return this.discountableOrderItems;
    }

    protected List<PromotableOrderItem> buildPromotableOrderItemsList() {
        ArrayList<PromotableOrderItem> discountableOrderItems = new ArrayList<PromotableOrderItem>();
        for (PromotableOrderItem promotableOrderItem : this.getAllOrderItems()) {
            OrderItemContainer orderItemContainer;
            if (promotableOrderItem.isDiscountingAllowed()) {
                discountableOrderItems.add(promotableOrderItem);
                continue;
            }
            if (!promotableOrderItem.isOrderItemContainer() || !(orderItemContainer = promotableOrderItem.getOrderItemContainer()).getAllowDiscountsOnChildItems()) continue;
            for (OrderItem orderItem : orderItemContainer.getOrderItems()) {
                if (!orderItem.isDiscountingAllowed()) continue;
                this.addPromotableOrderItem(orderItem, discountableOrderItems);
            }
        }
        return discountableOrderItems;
    }

    protected void addPromotableOrderItem(OrderItem orderItem, List<PromotableOrderItem> discountableOrderItems) {
        PromotableOrderItem item = this.itemFactory.createPromotableOrderItem(orderItem, this, this.includeOrderAndItemAdjustments);
        discountableOrderItems.add(item);
    }

    @Override
    public List<PromotableFulfillmentGroup> getFulfillmentGroups() {
        if (this.fulfillmentGroups == null) {
            this.fulfillmentGroups = new ArrayList<PromotableFulfillmentGroup>();
            for (FulfillmentGroup fulfillmentGroup : this.order.getFulfillmentGroups()) {
                this.fulfillmentGroups.add(this.itemFactory.createPromotableFulfillmentGroup(fulfillmentGroup, this));
            }
        }
        return Collections.unmodifiableList(this.fulfillmentGroups);
    }

    @Override
    public boolean isHasOrderAdjustments() {
        return this.candidateOrderOfferAdjustments.size() > 0;
    }

    @Override
    public List<PromotableOrderAdjustment> getCandidateOrderAdjustments() {
        return this.candidateOrderOfferAdjustments;
    }

    @Override
    public void addCandidateOrderAdjustment(PromotableOrderAdjustment orderAdjustment) {
        this.candidateOrderOfferAdjustments.add(orderAdjustment);
    }

    @Override
    public void removeAllCandidateOfferAdjustments() {
        this.removeAllCandidateItemOfferAdjustments();
        this.removeAllCandidateFulfillmentOfferAdjustments();
        this.removeAllCandidateOrderOfferAdjustments();
    }

    @Override
    public void removeAllCandidateOrderOfferAdjustments() {
        this.candidateOrderOfferAdjustments.clear();
    }

    @Override
    public void removeAllCandidateItemOfferAdjustments() {
        for (PromotableOrderItem promotableOrderItem : this.getDiscountableOrderItems()) {
            promotableOrderItem.removeAllItemAdjustments();
        }
    }

    @Override
    public void removeAllCandidateFulfillmentOfferAdjustments() {
        for (PromotableFulfillmentGroup fulfillmentGroup : this.getFulfillmentGroups()) {
            fulfillmentGroup.removeAllCandidateAdjustments();
        }
    }

    @Override
    public void updateRuleVariables(Map<String, Object> ruleVars) {
        ruleVars.put("order", this.order);
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public boolean isTotalitarianOfferApplied() {
        return this.isTotalitarianFgOfferApplied() || this.isTotalitarianItemOfferApplied() || this.isTotalitarianOrderOfferApplied();
    }

    @Override
    public boolean isTotalitarianOrderOfferApplied() {
        for (PromotableOrderAdjustment adjustment : this.candidateOrderOfferAdjustments) {
            if (!adjustment.isTotalitarian()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTotalitarianItemOfferApplied() {
        for (PromotableOrderItemPriceDetail itemPriceDetail : this.getAllPromotableOrderItemPriceDetails()) {
            if (!itemPriceDetail.isTotalitarianOfferApplied()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTotalitarianFgOfferApplied() {
        for (PromotableFulfillmentGroup fg : this.getFulfillmentGroups()) {
            if (!fg.isTotalitarianOfferApplied()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Money calculateOrderAdjustmentTotal() {
        Money orderAdjustmentTotal = BroadleafCurrencyUtils.getMoney((BroadleafCurrency)this.order.getCurrency());
        for (PromotableOrderAdjustment adjustment : this.candidateOrderOfferAdjustments) {
            orderAdjustmentTotal = orderAdjustmentTotal.add(adjustment.getAdjustmentValue());
        }
        return orderAdjustmentTotal;
    }

    @Override
    public Money calculateItemAdjustmentTotal() {
        Money itemAdjustmentTotal = BroadleafCurrencyUtils.getMoney((BroadleafCurrency)this.order.getCurrency());
        for (PromotableOrderItem item : this.getDiscountableOrderItems()) {
            itemAdjustmentTotal = itemAdjustmentTotal.add(item.calculateTotalAdjustmentValue());
        }
        return itemAdjustmentTotal;
    }

    @Override
    public List<PromotableOrderItemPriceDetail> getAllPromotableOrderItemPriceDetails() {
        ArrayList<PromotableOrderItemPriceDetail> allPriceDetails = new ArrayList<PromotableOrderItemPriceDetail>();
        for (PromotableOrderItem item : this.getDiscountableOrderItems()) {
            allPriceDetails.addAll(item.getPromotableOrderItemPriceDetails());
        }
        return allPriceDetails;
    }

    @Override
    public BroadleafCurrency getOrderCurrency() {
        return this.order.getCurrency();
    }

    @Override
    public void setTotalFufillmentCharges(Money totalFulfillmentCharges) {
        this.order.setTotalFulfillmentCharges(totalFulfillmentCharges);
    }

    protected boolean isNotCombinableOrderOfferApplied() {
        for (PromotableOrderAdjustment adjustment : this.candidateOrderOfferAdjustments) {
            if (adjustment.isCombinable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canApplyOrderOffer(PromotableCandidateOrderOffer offer) {
        if (this.isNotCombinableOrderOfferApplied()) {
            return false;
        }
        if (!offer.isCombinable() || offer.isTotalitarian()) {
            return this.candidateOrderOfferAdjustments.size() == 0;
        }
        return true;
    }

    @Override
    public Money calculateSubtotalWithoutAdjustments() {
        Money calculatedSubTotal = BroadleafCurrencyUtils.getMoney((BroadleafCurrency)this.order.getCurrency());
        for (PromotableOrderItem orderItem : this.getAllOrderItems()) {
            calculatedSubTotal = calculatedSubTotal.add(orderItem.calculateTotalWithoutAdjustments());
        }
        return calculatedSubTotal;
    }

    @Override
    public Money calculateSubtotalWithAdjustments() {
        Money calculatedSubTotal = BroadleafCurrencyUtils.getMoney((BroadleafCurrency)this.order.getCurrency());
        for (PromotableOrderItem orderItem : this.getAllOrderItems()) {
            calculatedSubTotal = calculatedSubTotal.add(orderItem.calculateTotalWithAdjustments());
        }
        return calculatedSubTotal;
    }

    @Override
    public boolean isIncludeOrderAndItemAdjustments() {
        return this.includeOrderAndItemAdjustments;
    }
}

