/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.core.offer.dao.OfferCodeDao;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustmentImpl;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.OfferServiceImpl;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.processor.OfferTimeZoneProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferItemRestrictionRuleType;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.dao.OrderItemDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderMultishipOption;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.easymock.EasyMock;
import org.easymock.IAnswer;

public class ItemOfferProcessorTest
extends TestCase {
    protected OfferDao offerDaoMock;
    protected OrderItemDao orderItemDaoMock;
    protected OrderService orderServiceMock;
    protected OfferServiceImpl offerService;
    protected OrderItemService orderItemServiceMock;
    protected FulfillmentGroupItemDao fgItemDaoMock;
    protected OfferDataItemProvider dataProvider = new OfferDataItemProvider();
    protected FulfillmentGroupService fgServiceMock;
    protected OrderMultishipOptionService multishipOptionServiceMock;
    protected OfferTimeZoneProcessor offerTimeZoneProcessorMock;
    protected ItemOfferProcessorImpl itemProcessor;

    protected void setUp() throws Exception {
        CustomerOfferDao customerOfferDaoMock = (CustomerOfferDao)EasyMock.createMock(CustomerOfferDao.class);
        OfferCodeDao offerCodeDaoMock = (OfferCodeDao)EasyMock.createMock(OfferCodeDao.class);
        this.offerDaoMock = (OfferDao)EasyMock.createMock(OfferDao.class);
        this.orderItemDaoMock = (OrderItemDao)EasyMock.createMock(OrderItemDao.class);
        this.orderServiceMock = (OrderService)EasyMock.createMock(OrderService.class);
        this.orderItemServiceMock = (OrderItemService)EasyMock.createMock(OrderItemService.class);
        this.fgItemDaoMock = (FulfillmentGroupItemDao)EasyMock.createMock(FulfillmentGroupItemDao.class);
        this.fgServiceMock = (FulfillmentGroupService)EasyMock.createMock(FulfillmentGroupService.class);
        this.multishipOptionServiceMock = (OrderMultishipOptionService)EasyMock.createMock(OrderMultishipOptionService.class);
        this.offerTimeZoneProcessorMock = (OfferTimeZoneProcessor)EasyMock.createMock(OfferTimeZoneProcessor.class);
        this.itemProcessor = new ItemOfferProcessorImpl();
        this.itemProcessor.setOfferDao(this.offerDaoMock);
        this.itemProcessor.setOrderItemDao(this.orderItemDaoMock);
        this.itemProcessor.setOfferTimeZoneProcessor(this.offerTimeZoneProcessorMock);
        this.itemProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerService = new OfferServiceImpl();
        OrderOfferProcessorImpl orderProcessor = new OrderOfferProcessorImpl();
        orderProcessor.setOfferDao(this.offerDaoMock);
        orderProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        orderProcessor.setOfferTimeZoneProcessor(this.offerTimeZoneProcessorMock);
        orderProcessor.setOrderItemDao(this.orderItemDaoMock);
        this.offerService.setCustomerOfferDao(customerOfferDaoMock);
        this.offerService.setOfferCodeDao(offerCodeDaoMock);
        this.offerService.setOfferDao(this.offerDaoMock);
        this.offerService.setOrderOfferProcessor((OrderOfferProcessor)orderProcessor);
        this.offerService.setItemOfferProcessor((ItemOfferProcessor)this.itemProcessor);
        this.offerService.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerService.setOrderService(this.orderServiceMock);
    }

    public void replay() throws Exception {
        EasyMock.expect((Object)this.orderItemDaoMock.createOrderItemPriceDetail()).andAnswer(OfferDataItemProvider.getCreateOrderItemPriceDetailAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderItemDaoMock.createOrderItemQualifier()).andAnswer(OfferDataItemProvider.getCreateOrderItemQualifierAnswer()).anyTimes();
        EasyMock.expect((Object)this.offerDaoMock.createOrderItemPriceDetailAdjustment()).andAnswer(OfferDataItemProvider.getCreateOrderItemPriceDetailAdjustmentAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgServiceMock.addItemToFulfillmentGroup((FulfillmentGroupItemRequest)EasyMock.isA(FulfillmentGroupItemRequest.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddItemToFulfillmentGroupAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.removeItem((Long)EasyMock.isA(Long.class), (Long)EasyMock.isA(Long.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getRemoveItemFromOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.save((Order)EasyMock.isA(Order.class), (Boolean)EasyMock.isA(Boolean.class))).andAnswer(OfferDataItemProvider.getSaveOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.getAutomaticallyMergeLikeItems()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.orderItemServiceMock.saveOrderItem((OrderItem)EasyMock.isA(OrderItem.class))).andAnswer(OfferDataItemProvider.getSaveOrderItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.save((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class))).andAnswer(OfferDataItemProvider.getSaveFulfillmentGroupItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.multishipOptionServiceMock.findOrderMultishipOptions((Long)EasyMock.isA(Long.class))).andAnswer((IAnswer)new IAnswer<List<OrderMultishipOption>>(){

            public List<OrderMultishipOption> answer() throws Throwable {
                return new ArrayList<OrderMultishipOption>();
            }
        }).anyTimes();
        this.multishipOptionServiceMock.deleteAllOrderMultishipOptions((Order)EasyMock.isA(Order.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.fgServiceMock.collapseToOneFulfillmentGroup((Order)EasyMock.isA(Order.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getSameOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.create()).andAnswer(OfferDataItemProvider.getCreateFulfillmentGroupItemAnswer()).anyTimes();
        this.fgItemDaoMock.delete((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.offerTimeZoneProcessorMock.getTimeZone((Offer)EasyMock.isA(OfferImpl.class))).andReturn((Object)TimeZone.getTimeZone("CST")).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.offerDaoMock});
        EasyMock.replay((Object[])new Object[]{this.orderItemDaoMock});
        EasyMock.replay((Object[])new Object[]{this.orderServiceMock});
        EasyMock.replay((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.replay((Object[])new Object[]{this.fgItemDaoMock});
        EasyMock.replay((Object[])new Object[]{this.fgServiceMock});
        EasyMock.replay((Object[])new Object[]{this.multishipOptionServiceMock});
        EasyMock.replay((Object[])new Object[]{this.offerTimeZoneProcessorMock});
    }

    public void verify() {
        EasyMock.verify((Object[])new Object[]{this.offerDaoMock});
        EasyMock.verify((Object[])new Object[]{this.orderItemDaoMock});
        EasyMock.verify((Object[])new Object[]{this.orderServiceMock});
        EasyMock.verify((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.verify((Object[])new Object[]{this.fgItemDaoMock});
        EasyMock.verify((Object[])new Object[]{this.fgServiceMock});
        EasyMock.verify((Object[])new Object[]{this.multishipOptionServiceMock});
        EasyMock.verify((Object[])new Object[]{this.offerTimeZoneProcessorMock});
    }

    public void testFilterItemLevelOffer() throws Exception {
        this.replay();
        ArrayList qualifiedOffers = new ArrayList();
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, null, null);
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offers.get(0));
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offers.get(0));
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        offers.get(0).setQualifyingItemSubTotal(new Money(1));
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offers.get(0));
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        offers.get(0).setQualifyingItemSubTotal(new Money(99999));
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offers.get(0));
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 0 ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.itemProcessor.filterItemLevelOffer(order, qualifiedOffers, offers.get(0));
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testCouldOfferApplyToOrder() throws Exception {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, null, null);
        boolean couldApply = this.itemProcessor.couldOfferApplyToOrder(offers.get(0), order, (PromotableOrderItem)order.getDiscountableOrderItems().get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        ItemOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()==0", OfferDiscountType.PERCENT_OFF, null, null);
        couldApply = this.itemProcessor.couldOfferApplyToOrder(offers.get(0), order, (PromotableOrderItem)order.getDiscountableOrderItems().get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        ItemOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOrderItemMeetOfferRequirement() throws Exception {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        boolean couldApply = this.itemProcessor.couldOrderItemMeetOfferRequirement((OfferItemCriteria)offers.get(0).getQualifyingItemCriteria().iterator().next(), (PromotableOrderItem)order.getDiscountableOrderItems().get(0));
        ItemOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        couldApply = this.itemProcessor.couldOrderItemMeetOfferRequirement((OfferItemCriteria)offers.get(0).getQualifyingItemCriteria().iterator().next(), (PromotableOrderItem)order.getDiscountableOrderItems().get(0));
        ItemOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOfferApplyToOrderItems() throws Exception {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        ArrayList<PromotableOrderItem> orderItems = new ArrayList<PromotableOrderItem>();
        for (PromotableOrderItem orderItem : order.getDiscountableOrderItems()) {
            orderItems.add(orderItem);
        }
        CandidatePromotionItems candidates = this.itemProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        ItemOfferProcessorTest.assertTrue((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 && ((List)candidates.getCandidateQualifiersMap().values().iterator().next()).size() == 2 && candidates.isMatchedTarget() && candidates.getCandidateTargetsMap().size() == 1 && ((List)candidates.getCandidateTargetsMap().values().iterator().next()).size() == 2 ? 1 : 0) != 0);
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        candidates = this.itemProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        ItemOfferProcessorTest.assertFalse((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        this.verify();
    }

    private int checkOrderItemOfferAppliedCount(Order order) {
        int count = 0;
        for (OrderItem item : order.getOrderItems()) {
            for (OrderItemPriceDetail detail : item.getOrderItemPriceDetails()) {
                count += detail.getOrderItemPriceDetailAdjustments().size() * detail.getQuantity();
            }
        }
        return count;
    }

    private int checkOrderItemOfferAppliedQuantity(Order order, Offer offer) {
        int count = 0;
        for (OrderItem item : order.getOrderItems()) {
            for (OrderItemPriceDetail detail : item.getOrderItemPriceDetails()) {
                for (OrderItemPriceDetailAdjustment adjustment : detail.getOrderItemPriceDetailAdjustments()) {
                    if (!adjustment.getOffer().getId().equals(offer.getId())) continue;
                    count += detail.getQuantity();
                }
            }
        }
        return count;
    }

    private int countPriceDetails(Order order) {
        int count = 0;
        for (OrderItem item : order.getOrderItems()) {
            count += item.getOrderItemPriceDetails().size();
        }
        return count;
    }

    public void testApplyAllItemOffers() throws Exception {
        this.replay();
        Order order = this.dataProvider.createBasicOrder();
        Offer offer1 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer1.setId(Long.valueOf(1L));
        ArrayList<Offer> offers = new ArrayList<Offer>();
        offers.add(offer1);
        ArrayList qualifiedOffers = new ArrayList();
        this.offerService.applyOffersToOrder(offers, order);
        ItemOfferProcessorTest.assertTrue((order.getTotalAdjustmentsValue().getAmount().doubleValue() > 0.0 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicOrder();
        qualifiedOffers = new ArrayList();
        offer1.setApplyDiscountToSalePrice(false);
        ((OrderItem)order.getOrderItems().get(0)).setSalePrice(new Money(1.0));
        ((OrderItem)order.getOrderItems().get(1)).setSalePrice(new Money(1.0));
        this.offerService.applyOffersToOrder(offers, order);
        ItemOfferProcessorTest.assertTrue((order.getTotalAdjustmentsValue().getAmount().doubleValue() == 0.0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testApplyAdjustments() throws Exception {
        this.replay();
        Order order = this.dataProvider.createBasicOrder();
        Offer offer1 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer1.setId(Long.valueOf(1L));
        ((OfferItemCriteria)offer1.getQualifyingItemCriteria().iterator().next()).setQuantity(Integer.valueOf(2));
        offer1.setCombinableWithOtherOffers(false);
        Offer offer2 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer2.setId(Long.valueOf(2L));
        ArrayList<Offer> offerListWithOneOffer = new ArrayList<Offer>();
        offerListWithOneOffer.add(offer1);
        ArrayList<Offer> offerListWithTwoOffers = new ArrayList<Offer>();
        offerListWithTwoOffers.add(offer1);
        offerListWithTwoOffers.add(offer2);
        this.offerService.applyOffersToOrder(offerListWithOneOffer, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedCount(order) == 1 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer1) == 1 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicOrder();
        this.offerService.applyOffersToOrder(offerListWithTwoOffers, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedCount(order) == 2 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer2) == 2 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer1) == 0 ? 1 : 0) != 0);
        offer1.setCombinableWithOtherOffers(true);
        order = this.dataProvider.createBasicOrder();
        this.offerService.applyOffersToOrder(offerListWithTwoOffers, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedCount(order) == 2 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer2) == 2 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer1) == 0 ? 1 : 0) != 0);
        offer1.setCombinableWithOtherOffers(false);
        offer1.setApplyDiscountToSalePrice(false);
        order = this.dataProvider.createBasicOrder();
        ((OrderItem)order.getOrderItems().get(1)).setSalePrice(new Money(10.0));
        this.offerService.applyOffersToOrder(offerListWithOneOffer, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedCount(order) == 0 ? 1 : 0) != 0);
        this.offerService.applyOffersToOrder(offerListWithTwoOffers, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedCount(order) == 2 ? 1 : 0) != 0);
        offer1.setCombinableWithOtherOffers(true);
        ((OrderItem)order.getOrderItems().get(1)).setSalePrice(null);
        offer2.setCombinableWithOtherOffers(false);
        this.offerService.applyOffersToOrder(offerListWithOneOffer, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedCount(order) == 1 ? 1 : 0) != 0);
        this.offerService.applyOffersToOrder(offerListWithTwoOffers, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer2) == 2 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer1) == 0 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicOrder();
        ((OfferItemCriteria)offer1.getQualifyingItemCriteria().iterator().next()).setQuantity(Integer.valueOf(1));
        ((OfferItemCriteria)offer1.getTargetItemCriteria().iterator().next()).setQuantity(Integer.valueOf(2));
        this.offerService.applyOffersToOrder(offerListWithOneOffer, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer1) == 2 ? 1 : 0) != 0);
        offer1.setCombinableWithOtherOffers(true);
        offer2.setCombinableWithOtherOffers(true);
        offer1.setOfferItemQualifierRuleType(OfferItemRestrictionRuleType.QUALIFIER_TARGET);
        offer1.setOfferItemTargetRuleType(OfferItemRestrictionRuleType.QUALIFIER_TARGET);
        offer2.setOfferItemQualifierRuleType(OfferItemRestrictionRuleType.QUALIFIER_TARGET);
        offer2.setOfferItemTargetRuleType(OfferItemRestrictionRuleType.QUALIFIER_TARGET);
        order = this.dataProvider.createBasicOrder();
        this.offerService.applyOffersToOrder(offerListWithTwoOffers, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedCount(order) == 4 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer2) == 2 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer1) == 2 ? 1 : 0) != 0);
        this.verify();
    }

    public void testApplyItemQualifiersAndTargets() throws Exception {
        this.replay();
        ArrayList qualifiedOffers = new ArrayList();
        Offer offer1 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer1.setId(Long.valueOf(1L));
        Offer offer2 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        offer2.setId(Long.valueOf(2L));
        ((OfferItemCriteria)offer2.getTargetItemCriteria().iterator().next()).setQuantity(Integer.valueOf(4));
        offer2.getQualifyingItemCriteria().clear();
        offer2.setOfferItemTargetRuleType(OfferItemRestrictionRuleType.TARGET);
        Offer offer3 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))").get(0);
        PromotableOrder promotableOrder = this.dataProvider.createBasicPromotableOrder();
        this.itemProcessor.filterItemLevelOffer(promotableOrder, qualifiedOffers, offer1);
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getOffer().equals(offer1) && ((PromotableCandidateItemOffer)qualifiedOffers.get(0)).getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        this.itemProcessor.filterItemLevelOffer(promotableOrder, qualifiedOffers, offer2);
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 2 && ((PromotableCandidateItemOffer)qualifiedOffers.get(1)).getOffer().equals(offer2) && ((PromotableCandidateItemOffer)qualifiedOffers.get(1)).getCandidateQualifiersMap().size() == 0 ? 1 : 0) != 0);
        this.itemProcessor.filterItemLevelOffer(promotableOrder, qualifiedOffers, offer3);
        ItemOfferProcessorTest.assertTrue((qualifiedOffers.size() == 3 && ((PromotableCandidateItemOffer)qualifiedOffers.get(2)).getOffer().equals(offer3) && ((PromotableCandidateItemOffer)qualifiedOffers.get(2)).getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        Order order = this.dataProvider.createBasicOrder();
        ArrayList<Offer> offerList = new ArrayList<Offer>();
        offerList.add(offer2);
        this.offerService.applyOffersToOrder(offerList, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer2) == 4 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.countPriceDetails(order) == 3 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicOrder();
        offerList.add(offer1);
        this.offerService.applyOffersToOrder(offerList, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer2) == 4 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.countPriceDetails(order) == 3 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicOrder();
        offerList.add(offer3);
        offer3.setPriority(-1);
        this.offerService.applyOffersToOrder(offerList, order);
        ItemOfferProcessorTest.assertTrue((this.checkOrderItemOfferAppliedQuantity(order, offer3) == 2 ? 1 : 0) != 0);
        ItemOfferProcessorTest.assertTrue((this.countPriceDetails(order) == 4 ? 1 : 0) != 0);
        this.verify();
    }

    public class Answer2
    implements IAnswer<OrderItemAdjustment> {
        public OrderItemAdjustment answer() throws Throwable {
            return new OrderItemAdjustmentImpl();
        }
    }

    public class Answer
    implements IAnswer<CandidateItemOffer> {
        public CandidateItemOffer answer() throws Throwable {
            return new CandidateItemOfferImpl();
        }
    }
}

