/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.AdvancedOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferTier;
import org.broadleafcommerce.core.offer.service.discount.domain.OfferHolder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotionRounding;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;

public class PromotableOfferUtility {
    public static Money computeAdjustmentValue(Money currentPriceDetailValue, BigDecimal offerUnitValue, OfferHolder offerHolder, PromotionRounding rounding) {
        Offer offer = offerHolder.getOffer();
        BroadleafCurrency currency = offerHolder.getCurrency();
        OfferDiscountType discountType = offer.getDiscountType();
        Money adjustmentValue = currency != null ? new Money(currency) : new Money();
        if (OfferDiscountType.AMOUNT_OFF.equals(discountType)) {
            adjustmentValue = new Money(offerUnitValue, currency);
        }
        if (OfferDiscountType.FIX_PRICE.equals(discountType)) {
            adjustmentValue = currentPriceDetailValue.subtract(new Money(offerUnitValue, currency));
        }
        if (OfferDiscountType.PERCENT_OFF.equals(discountType)) {
            BigDecimal offerValue = currentPriceDetailValue.getAmount().multiply(offerUnitValue.divide(new BigDecimal("100"), 5, RoundingMode.HALF_EVEN));
            if (rounding.isRoundOfferValues()) {
                offerValue = offerValue.setScale(rounding.getRoundingScale(), rounding.getRoundingMode());
            }
            adjustmentValue = new Money(offerValue, currency);
        }
        if (currentPriceDetailValue.lessThan(adjustmentValue)) {
            adjustmentValue = currentPriceDetailValue;
        }
        return adjustmentValue;
    }

    public static BigDecimal determineOfferUnitValue(Offer offer, PromotableCandidateItemOffer promotableCandidateItemOffer) {
        AdvancedOffer advancedOffer;
        if (offer instanceof AdvancedOffer && (advancedOffer = (AdvancedOffer)((Object)offer)).isTieredOffer()) {
            int quantity = promotableCandidateItemOffer.calculateTargetQuantityForTieredOffer();
            List<OfferTier> offerTiers = advancedOffer.getOfferTiers();
            Collections.sort(offerTiers, new BeanComparator("minQuantity"));
            OfferTier maxTier = null;
            for (OfferTier currentTier : offerTiers) {
                if ((long)quantity < currentTier.getMinQuantity()) break;
                maxTier = currentTier;
            }
            if (maxTier != null) {
                return maxTier.getAmount();
            }
            return BigDecimal.ZERO;
        }
        return offer.getValue();
    }
}

