/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class ProductOptionType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ProductOptionType> TYPES = new LinkedHashMap<String, ProductOptionType>();
    public static final ProductOptionType COLOR = new ProductOptionType("COLOR", "Color");
    public static final ProductOptionType SIZE = new ProductOptionType("SIZE", "Size");
    public static final ProductOptionType DATE = new ProductOptionType("DATE", "Date");
    public static final ProductOptionType TEXT = new ProductOptionType("TEXT", "Text");
    public static final ProductOptionType BOOLEAN = new ProductOptionType("BOOLEAN", "Boolean");
    public static final ProductOptionType DECIMAL = new ProductOptionType("DECIMAL", "Decimal");
    public static final ProductOptionType INTEGER = new ProductOptionType("INTEGER", "Integer");
    public static final ProductOptionType INPUT = new ProductOptionType("INPUT", "Input");
    public static final ProductOptionType PRODUCT = new ProductOptionType("PRODUCT", "Product");
    public static final ProductOptionType SELECT = new ProductOptionType("SELECT", "Select");
    private String type;
    private String friendlyType;

    public static ProductOptionType getInstance(String type) {
        return TYPES.get(type);
    }

    public ProductOptionType() {
    }

    public ProductOptionType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductOptionType other = (ProductOptionType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

