/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class OfferRuleType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, OfferRuleType> TYPES = new LinkedHashMap<String, OfferRuleType>();
    public static final OfferRuleType ORDER = new OfferRuleType("ORDER", "Order");
    public static final OfferRuleType FULFILLMENT_GROUP = new OfferRuleType("FULFILLMENT_GROUP", "Fulfillment Group");
    public static final OfferRuleType CUSTOMER = new OfferRuleType("CUSTOMER", "Customer");
    public static final OfferRuleType TIME = new OfferRuleType("TIME", "Time");
    public static final OfferRuleType REQUEST = new OfferRuleType("REQUEST", "Request");
    private String type;
    private String friendlyType;

    public static OfferRuleType getInstance(String type) {
        return TYPES.get(type);
    }

    public OfferRuleType() {
    }

    public OfferRuleType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfferRuleType other = (OfferRuleType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

