/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrencyImpl;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.currency.util.CurrencyCodeIdentifiable;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetail;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetailType;
import org.broadleafcommerce.core.payment.domain.PaymentInfoImpl;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_PAYMENT_DETAILS")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
public class PaymentInfoDetailImpl
implements PaymentInfoDetail,
CurrencyCodeIdentifiable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PaymentInfoDetailId")
    @GenericGenerator(name="PaymentInfoDetailId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="PaymentInfoDetailImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.payment.domain.PaymentInfoDetailImpl")})
    @Column(name="PAYMENT_DETAIL_ID")
    protected Long id;
    @ManyToOne(targetEntity=PaymentInfoImpl.class, optional=false)
    @JoinColumn(name="PAYMENT_INFO")
    @AdminPresentation(excluded=true)
    protected PaymentInfo paymentInfo;
    @Column(name="PAYMENT_INFO_DETAIL_TYPE")
    @AdminPresentation(friendlyName="PaymentInfoDetailTypeImpl_Type", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.payment.domain.PaymentInfoDetailType", prominent=true, gridOrder=1000)
    protected String type;
    @Column(name="PAYMENT_AMOUNT")
    @AdminPresentation(friendlyName="PaymentInfoDetailTypeImpl_Amount", fieldType=SupportedFieldType.MONEY, prominent=true, gridOrder=2000)
    protected BigDecimal amount;
    @ManyToOne(targetEntity=BroadleafCurrencyImpl.class)
    @JoinColumn(name="CURRENCY_CODE")
    @AdminPresentation(excluded=true)
    protected BroadleafCurrency currency;
    @Column(name="DATE_RECORDED")
    @AdminPresentation(friendlyName="PaymentInfoDetailTypeImpl_Date", prominent=true, gridOrder=3000)
    protected Date date;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public PaymentInfo getPaymentInfo() {
        return this.paymentInfo;
    }

    @Override
    public void setPaymentInfo(PaymentInfo paymentInfo) {
        this.paymentInfo = paymentInfo;
    }

    @Override
    public PaymentInfoDetailType getType() {
        return PaymentInfoDetailType.getInstance(this.type);
    }

    @Override
    public void setType(PaymentInfoDetailType type) {
        this.type = type == null ? null : type.getType();
    }

    @Override
    public Money getAmount() {
        return this.amount == null ? BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getCurrency()) : BroadleafCurrencyUtils.getMoney((BigDecimal)this.amount, (BroadleafCurrency)this.getCurrency());
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = amount.getAmount();
    }

    @Override
    public BroadleafCurrency getCurrency() {
        return this.currency;
    }

    @Override
    public void setCurrency(BroadleafCurrency currency) {
        this.currency = currency;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    public String getCurrencyCode() {
        if (this.currency != null) {
            return this.currency.getCurrencyCode();
        }
        return ((CurrencyCodeIdentifiable)this.paymentInfo).getCurrencyCode();
    }
}

