/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.util.StopWatch;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuActiveDatesService;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPricingService;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuActiveDateConsiderationContext;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.broadleafcommerce.core.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.search.dao.FieldDao;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.SolrContext;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrIndexService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="blSolrIndexService")
public class SolrIndexServiceImpl
implements SolrIndexService {
    private static final Log LOG = LogFactory.getLog(SolrIndexServiceImpl.class);
    @Value(value="${solr.index.product.pageSize}")
    protected int pageSize;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blFieldDao")
    protected FieldDao fieldDao;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;
    @Resource(name="blSolrHelperService")
    protected SolrHelperService shs;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;
    @Resource(name="blTransactionManager")
    protected PlatformTransactionManager transactionManager;
    public static String ATTR_MAP = "productAttributes";

    @Override
    public void rebuildIndex() throws ServiceException, IOException {
        LOG.info((Object)"Rebuilding the solr index...");
        StopWatch s = new StopWatch();
        if (SolrContext.isSingleCoreMode()) {
            this.deleteAllDocuments();
        }
        BroadleafRequestContext savedContext = BroadleafRequestContext.getBroadleafRequestContext();
        HashMap savedPricing = SkuPricingConsiderationContext.getSkuPricingConsiderationContext();
        DynamicSkuPricingService savedPricingService = SkuPricingConsiderationContext.getSkuPricingService();
        DynamicSkuActiveDatesService savedActiveDateServcie = SkuActiveDateConsiderationContext.getSkuActiveDatesService();
        try {
            Long numProducts = this.productDao.readCountAllActiveProducts(SystemTime.asDate());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("There are " + numProducts + " total products"));
            }
            int page = 0;
            while ((long)(page * this.pageSize) < numProducts) {
                this.buildIncrementalIndex(page, this.pageSize);
                ++page;
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Optimizing the index...");
                }
                SolrContext.getReindexServer().optimize();
            }
            catch (SolrServerException e) {
                throw new ServiceException("Could not rebuild index", (Throwable)e);
            }
        }
        catch (ServiceException e) {
            throw e;
        }
        finally {
            BroadleafRequestContext.setBroadleafRequestContext((BroadleafRequestContext)savedContext);
            SkuPricingConsiderationContext.setSkuPricingConsiderationContext(savedPricing);
            SkuPricingConsiderationContext.setSkuPricingService(savedPricingService);
            SkuActiveDateConsiderationContext.setSkuActiveDatesService(savedActiveDateServcie);
        }
        this.shs.swapActiveCores();
        if (!SolrContext.isSingleCoreMode()) {
            this.deleteAllDocuments();
        }
        LOG.info((Object)String.format("Finished building index in %s", s.toLapString()));
    }

    protected void deleteAllDocuments() throws ServiceException {
        try {
            String deleteQuery = "*:*";
            LOG.debug((Object)("Deleting by query: " + deleteQuery));
            SolrContext.getReindexServer().deleteByQuery(deleteQuery);
            SolrContext.getReindexServer().commit();
        }
        catch (Exception e) {
            throw new ServiceException("Could not delete documents", (Throwable)e);
        }
    }

    protected void buildIncrementalIndex(int page, int pageSize) throws ServiceException {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("saveOrder");
        def.setReadOnly(true);
        def.setPropagationBehavior(0);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Building index - page: [%s], pageSize: [%s]", page, pageSize));
        }
        StopWatch s = new StopWatch();
        try {
            List<Product> products = this.readAllActiveProducts(page, pageSize);
            List<Field> fields = this.fieldDao.readAllProductFields();
            List<Locale> locales = this.getAllLocales();
            ArrayList<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
            for (Product product : products) {
                documents.add(this.buildDocument(product, fields, locales));
            }
            if (LOG.isTraceEnabled()) {
                for (SolrInputDocument document : documents) {
                    LOG.trace((Object)document);
                }
            }
            if (!CollectionUtils.isEmpty(documents)) {
                SolrContext.getReindexServer().add(documents);
                SolrContext.getReindexServer().commit();
            }
            this.finalizeTransaction(status, false);
        }
        catch (SolrServerException e) {
            this.finalizeTransaction(status, true);
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        catch (IOException e) {
            this.finalizeTransaction(status, true);
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.finalizeTransaction(status, true);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Built index - page: [%s], pageSize: [%s] in [%s]", page, pageSize, s.toLapString()));
        }
    }

    protected void finalizeTransaction(TransactionStatus status, boolean isError) {
        boolean isActive = false;
        try {
            if (!status.isRollbackOnly()) {
                isActive = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (isActive) {
            if (isError) {
                this.transactionManager.rollback(status);
            } else {
                this.transactionManager.commit(status);
            }
        }
    }

    protected List<Product> readAllActiveProducts() {
        return this.productDao.readAllActiveProducts(SystemTime.asDate());
    }

    protected List<Product> readAllActiveProducts(int page, int pageSize) {
        return this.productDao.readAllActiveProducts(page, pageSize, SystemTime.asDate());
    }

    protected List<Locale> getAllLocales() {
        return this.localeService.findAllLocales();
    }

    protected SolrInputDocument buildDocument(Product product, List<Field> fields, List<Locale> locales) {
        SolrInputDocument document = new SolrInputDocument();
        this.attachBasicDocumentFields(product, document);
        ArrayList<String> addedProperties = new ArrayList<String>();
        for (Field field : fields) {
            try {
                FieldType facetType;
                if (field.getSearchable().booleanValue()) {
                    List<FieldType> searchableFieldTypes = this.shs.getSearchableFieldTypes(field);
                    for (FieldType sft : searchableFieldTypes) {
                        Map<String, Object> propertyValues = this.getPropertyValues(product, field, sft, locales);
                        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                            String prefix = entry.getKey();
                            prefix = StringUtils.isBlank((CharSequence)prefix) ? prefix : prefix + "_";
                            String solrPropertyName = this.shs.getPropertyNameForFieldSearchable(field, sft, prefix);
                            Object value = entry.getValue();
                            document.addField(solrPropertyName, value);
                            addedProperties.add(solrPropertyName);
                        }
                    }
                }
                if ((facetType = field.getFacetFieldType()) == null) continue;
                Map<String, Object> propertyValues = this.getPropertyValues(product, field, facetType, locales);
                for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                    String prefix = entry.getKey();
                    prefix = StringUtils.isBlank((CharSequence)prefix) ? prefix : prefix + "_";
                    String solrFacetPropertyName = this.shs.getPropertyNameForFieldFacet(field, prefix);
                    Object value = entry.getValue();
                    if (addedProperties.contains(solrFacetPropertyName)) continue;
                    document.addField(solrFacetPropertyName, value);
                }
            }
            catch (Exception e) {
                LOG.trace((Object)("Could not get value for property[" + field.getQualifiedFieldName() + "] for product id[" + product.getId() + "]"), (Throwable)e);
            }
        }
        return document;
    }

    protected void attachBasicDocumentFields(Product product, SolrInputDocument document) {
        document.addField(this.shs.getNamespaceFieldName(), (Object)this.shs.getCurrentNamespace());
        document.addField(this.shs.getIdFieldName(), (Object)this.shs.getSolrDocumentId(document, product));
        document.addField(this.shs.getProductIdFieldName(), (Object)product.getId());
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).attachAdditionalBasicFields(product, document, this.shs);
        for (CategoryProductXref categoryXref : product.getAllParentCategoryXrefs()) {
            document.addField(this.shs.getExplicitCategoryFieldName(), (Object)categoryXref.getCategory().getId());
            String categorySortFieldName = this.shs.getCategorySortFieldName(categoryXref.getCategory());
            int index = -1;
            int count = 0;
            for (CategoryProductXref productXref : categoryXref.getCategory().getAllProductXrefs()) {
                if (productXref.getProduct().equals(product)) {
                    index = count;
                    break;
                }
                ++count;
            }
            document.addField(categorySortFieldName, (Object)index);
        }
        HashSet<Category> fullCategoryHierarchy = new HashSet<Category>();
        for (CategoryProductXref categoryXref : product.getAllParentCategoryXrefs()) {
            fullCategoryHierarchy.addAll(categoryXref.getCategory().buildFullCategoryHierarchy(null));
        }
        for (Category category : fullCategoryHierarchy) {
            document.addField(this.shs.getCategoryFieldName(), (Object)category.getId());
        }
    }

    protected Map<String, Object> getPropertyValues(Product product, Field field, FieldType fieldType, List<Locale> locales) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ExtensionResultStatusType result;
        String propertyName = field.getPropertyName();
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.extensionManager != null && ExtensionResultStatusType.NOT_HANDLED.equals((Object)(result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).addPropertyValues(product, field, fieldType, values, propertyName, locales)))) {
            Object propertyValue = propertyName.contains(ATTR_MAP) ? PropertyUtils.getMappedProperty((Object)product, (String)ATTR_MAP, (String)propertyName.substring(ATTR_MAP.length() + 1)) : PropertyUtils.getProperty((Object)product, (String)propertyName);
            values.put("", propertyValue);
        }
        return values;
    }

    protected String convertToMappedProperty(String propertyName, String listPropertyName, String mapPropertyName) {
        String[] splitName = StringUtils.split((String)propertyName, (String)".");
        StringBuilder convertedProperty = new StringBuilder();
        for (int i = 0; i < splitName.length; ++i) {
            if (convertedProperty.length() > 0) {
                convertedProperty.append(".");
            }
            if (splitName[i].equals(listPropertyName)) {
                convertedProperty.append(mapPropertyName).append("(");
                convertedProperty.append(splitName[i + 1]).append(").value");
                ++i;
                continue;
            }
            convertedProperty.append(splitName[i]);
        }
        return convertedProperty.toString();
    }
}

