/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.broadleafcommerce.core.order.domain.OrderItemQualifier;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_ITEM_OFFER_QUALIFIER")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class OrderItemQualifierImpl
implements OrderItemQualifier {
    public static final Log LOG = LogFactory.getLog(OrderItemQualifierImpl.class);
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderItemQualifierId")
    @GenericGenerator(name="OrderItemQualifierId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OrderItemQualifierImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.order.domain.OrderItemQualifierImpl")})
    @Column(name="ITEM_OFFER_QUALIFIER_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderItemImpl.class)
    @JoinColumn(name="ORDER_ITEM_ID")
    protected OrderItem orderItem;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    protected Offer offer;
    @Column(name="QUANTITY")
    protected Long quantity;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    @Override
    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Override
    public Long getQuantity() {
        return this.quantity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        result = 31 * result + (this.orderItem == null ? 0 : this.orderItem.hashCode());
        result = 31 * result + (this.quantity == null ? 0 : this.quantity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderItemQualifierImpl other = (OrderItemQualifierImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.offer == null ? other.offer != null : !this.offer.equals(other.offer)) {
            return false;
        }
        if (this.orderItem == null ? other.orderItem != null : !this.orderItem.equals(other.orderItem)) {
            return false;
        }
        return !(this.quantity == null ? other.quantity != null : !this.quantity.equals(other.quantity));
    }
}

