/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.config.domain.ModuleConfiguration;
import org.broadleafcommerce.common.config.service.ModuleConfigurationService;
import org.broadleafcommerce.common.config.service.type.ModuleConfigurationType;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.pricing.service.TaxService;
import org.broadleafcommerce.core.pricing.service.exception.TaxException;
import org.broadleafcommerce.core.pricing.service.tax.provider.TaxProvider;

public class TaxServiceImpl
implements TaxService {
    protected boolean mustCalculate = false;
    @Resource(name="blTaxProviders")
    protected List<TaxProvider> providers;
    @Resource(name="blModuleConfigurationService")
    protected ModuleConfigurationService moduleConfigService;

    @Override
    public Order calculateTaxForOrder(Order order) throws TaxException {
        List configurations = this.moduleConfigService.findActiveConfigurationsByType(ModuleConfigurationType.TAX_CALCULATION);
        if (configurations != null && !configurations.isEmpty()) {
            ModuleConfiguration config = null;
            for (ModuleConfiguration configuration : configurations) {
                if (!configuration.getIsDefault().booleanValue()) continue;
                config = configuration;
                break;
            }
            if (config == null) {
                config = (ModuleConfiguration)configurations.get(0);
            }
            if (this.providers != null && !this.providers.isEmpty()) {
                for (TaxProvider provider : this.providers) {
                    if (!provider.canRespond(config)) continue;
                    return provider.calculateTaxForOrder(order, config);
                }
            }
        }
        if (!this.mustCalculate) {
            return order;
        }
        throw new TaxException("No eligible tax providers were configured.");
    }

    @Override
    public Order commitTaxForOrder(Order order) throws TaxException {
        List configurations = this.moduleConfigService.findActiveConfigurationsByType(ModuleConfigurationType.TAX_CALCULATION);
        if (configurations != null && !configurations.isEmpty()) {
            ModuleConfiguration config = null;
            for (ModuleConfiguration configuration : configurations) {
                if (!configuration.getIsDefault().booleanValue()) continue;
                config = configuration;
                break;
            }
            if (config == null) {
                config = (ModuleConfiguration)configurations.get(0);
            }
            if (this.providers != null && !this.providers.isEmpty()) {
                for (TaxProvider provider : this.providers) {
                    if (!provider.canRespond(config)) continue;
                    return provider.commitTaxForOrder(order, config);
                }
            }
        }
        if (!this.mustCalculate) {
            return order;
        }
        throw new TaxException("No eligible tax providers were configured.");
    }

    @Override
    public void cancelTax(Order order) throws TaxException {
        List configurations = this.moduleConfigService.findActiveConfigurationsByType(ModuleConfigurationType.TAX_CALCULATION);
        if (configurations != null && !configurations.isEmpty()) {
            ModuleConfiguration config = null;
            for (ModuleConfiguration configuration : configurations) {
                if (!configuration.getIsDefault().booleanValue()) continue;
                config = configuration;
                break;
            }
            if (config == null) {
                config = (ModuleConfiguration)configurations.get(0);
            }
            if (this.providers != null && !this.providers.isEmpty()) {
                for (TaxProvider provider : this.providers) {
                    if (!provider.canRespond(config)) continue;
                    provider.cancelTax(order, config);
                    return;
                }
            }
        }
        if (this.mustCalculate) {
            throw new TaxException("No eligible tax providers were configured.");
        }
    }

    public void setTaxProviders(List<TaxProvider> providers) {
        this.providers = providers;
    }

    public void setMustCalculate(boolean mustCalculate) {
        this.mustCalculate = mustCalculate;
    }
}

