/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.rating.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.util.dao.BatchRetrieveDao;
import org.broadleafcommerce.core.rating.dao.RatingSummaryDao;
import org.broadleafcommerce.core.rating.domain.RatingDetail;
import org.broadleafcommerce.core.rating.domain.RatingSummary;
import org.broadleafcommerce.core.rating.domain.RatingSummaryImpl;
import org.broadleafcommerce.core.rating.domain.ReviewDetail;
import org.broadleafcommerce.core.rating.service.type.RatingType;
import org.springframework.stereotype.Repository;

@Repository(value="blRatingSummaryDao")
public class RatingSummaryDaoImpl
extends BatchRetrieveDao
implements RatingSummaryDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public void deleteRatingSummary(RatingSummary summary) {
        RatingSummary lSummary = summary;
        if (!this.em.contains((Object)lSummary)) {
            lSummary = (RatingSummary)this.em.find(RatingSummaryImpl.class, (Object)lSummary.getId());
        }
        this.em.remove((Object)lSummary);
    }

    @Override
    public RatingSummary saveRatingSummary(RatingSummary summary) {
        summary.resetAverageRating();
        return (RatingSummary)this.em.merge((Object)summary);
    }

    @Override
    public List<RatingSummary> readRatingSummaries(List<String> itemIds, RatingType type) {
        Query query = this.em.createNamedQuery("BC_READ_RATING_SUMMARIES_BY_ITEM_ID_AND_TYPE");
        query.setParameter("ratingType", (Object)type.getType());
        List ratings = this.batchExecuteReadQuery(query, itemIds, "itemIds");
        return ratings;
    }

    @Override
    public RatingSummary readRatingSummary(String itemId, RatingType type) {
        Query query = this.em.createNamedQuery("BC_READ_RATING_SUMMARY_BY_ITEM_ID_AND_TYPE");
        query.setParameter("itemId", (Object)itemId);
        query.setParameter("ratingType", (Object)type.getType());
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        RatingSummary ratingSummary = null;
        try {
            ratingSummary = (RatingSummary)query.getSingleResult();
        }
        catch (NoResultException e) {
            // empty catch block
        }
        return ratingSummary;
    }

    @Override
    public RatingDetail readRating(Long customerId, Long ratingSummaryId) {
        Query query = this.em.createNamedQuery("BC_READ_RATING_DETAIL_BY_CUSTOMER_ID_AND_RATING_SUMMARY_ID");
        query.setParameter("customerId", (Object)customerId);
        query.setParameter("ratingSummaryId", (Object)ratingSummaryId);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        RatingDetail ratingDetail = null;
        try {
            ratingDetail = (RatingDetail)query.getSingleResult();
        }
        catch (NoResultException e) {
            // empty catch block
        }
        return ratingDetail;
    }

    @Override
    public ReviewDetail readReview(Long customerId, Long ratingSummaryId) {
        Query query = this.em.createNamedQuery("BC_READ_REVIEW_DETAIL_BY_CUSTOMER_ID_AND_RATING_SUMMARY_ID");
        query.setParameter("customerId", (Object)customerId);
        query.setParameter("ratingSummaryId", (Object)ratingSummaryId);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        ReviewDetail reviewDetail = null;
        try {
            reviewDetail = (ReviewDetail)query.getSingleResult();
        }
        catch (NoResultException e) {
            // empty catch block
        }
        return reviewDetail;
    }
}

