/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.core.offer.dao.OfferCodeDao;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOfferImpl;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferRuleImpl;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderAdjustmentImpl;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustmentImpl;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.OfferServiceImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.processor.OfferTimeZoneProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.dao.OrderItemDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetailImpl;
import org.broadleafcommerce.core.order.domain.OrderItemQualifier;
import org.broadleafcommerce.core.order.domain.OrderItemQualifierImpl;
import org.broadleafcommerce.core.order.domain.OrderMultishipOption;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.easymock.EasyMock;
import org.easymock.IAnswer;

public class OfferServiceTest
extends TestCase {
    protected OfferServiceImpl offerService;
    protected CustomerOfferDao customerOfferDaoMock;
    protected OfferCodeDao offerCodeDaoMock;
    protected OfferDao offerDaoMock;
    protected OrderItemDao orderItemDaoMock;
    protected OrderService orderServiceMock;
    protected OrderItemService orderItemServiceMock;
    protected FulfillmentGroupItemDao fgItemDaoMock;
    protected OfferDataItemProvider dataProvider = new OfferDataItemProvider();
    protected OfferTimeZoneProcessor offerTimeZoneProcessorMock;
    private FulfillmentGroupService fgServiceMock;
    private OrderMultishipOptionService multishipOptionServiceMock;

    protected void setUp() throws Exception {
        this.offerService = new OfferServiceImpl();
        this.customerOfferDaoMock = (CustomerOfferDao)EasyMock.createMock(CustomerOfferDao.class);
        this.orderServiceMock = (OrderService)EasyMock.createMock(OrderService.class);
        this.offerCodeDaoMock = (OfferCodeDao)EasyMock.createMock(OfferCodeDao.class);
        this.offerDaoMock = (OfferDao)EasyMock.createMock(OfferDao.class);
        this.orderItemDaoMock = (OrderItemDao)EasyMock.createMock(OrderItemDao.class);
        this.offerService.setCustomerOfferDao(this.customerOfferDaoMock);
        this.offerService.setOfferCodeDao(this.offerCodeDaoMock);
        this.offerService.setOfferDao(this.offerDaoMock);
        this.offerService.setOrderService(this.orderServiceMock);
        this.orderItemServiceMock = (OrderItemService)EasyMock.createMock(OrderItemService.class);
        this.fgItemDaoMock = (FulfillmentGroupItemDao)EasyMock.createMock(FulfillmentGroupItemDao.class);
        this.fgServiceMock = (FulfillmentGroupService)EasyMock.createMock(FulfillmentGroupService.class);
        this.multishipOptionServiceMock = (OrderMultishipOptionService)EasyMock.createMock(OrderMultishipOptionService.class);
        this.offerTimeZoneProcessorMock = (OfferTimeZoneProcessor)EasyMock.createMock(OfferTimeZoneProcessor.class);
        OrderOfferProcessorImpl orderProcessor = new OrderOfferProcessorImpl();
        orderProcessor.setOfferDao(this.offerDaoMock);
        orderProcessor.setOrderItemDao(this.orderItemDaoMock);
        orderProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        orderProcessor.setOfferTimeZoneProcessor(this.offerTimeZoneProcessorMock);
        this.offerService.setOrderOfferProcessor((OrderOfferProcessor)orderProcessor);
        ItemOfferProcessorImpl itemProcessor = new ItemOfferProcessorImpl();
        itemProcessor.setOfferDao(this.offerDaoMock);
        itemProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerService.setItemOfferProcessor((ItemOfferProcessor)itemProcessor);
        FulfillmentGroupOfferProcessorImpl fgProcessor = new FulfillmentGroupOfferProcessorImpl();
        fgProcessor.setOfferDao(this.offerDaoMock);
        fgProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerService.setFulfillmentGroupOfferProcessor((FulfillmentGroupOfferProcessor)fgProcessor);
        this.offerService.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
    }

    public void replay() {
        EasyMock.replay((Object[])new Object[]{this.customerOfferDaoMock});
        EasyMock.replay((Object[])new Object[]{this.offerCodeDaoMock});
        EasyMock.replay((Object[])new Object[]{this.offerDaoMock});
        EasyMock.replay((Object[])new Object[]{this.orderItemDaoMock});
        EasyMock.replay((Object[])new Object[]{this.orderServiceMock});
        EasyMock.replay((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.replay((Object[])new Object[]{this.fgItemDaoMock});
        EasyMock.replay((Object[])new Object[]{this.fgServiceMock});
        EasyMock.replay((Object[])new Object[]{this.multishipOptionServiceMock});
        EasyMock.replay((Object[])new Object[]{this.offerTimeZoneProcessorMock});
    }

    public void verify() {
        EasyMock.verify((Object[])new Object[]{this.customerOfferDaoMock});
        EasyMock.verify((Object[])new Object[]{this.offerCodeDaoMock});
        EasyMock.verify((Object[])new Object[]{this.offerDaoMock});
        EasyMock.verify((Object[])new Object[]{this.orderItemDaoMock});
        EasyMock.verify((Object[])new Object[]{this.orderServiceMock});
        EasyMock.verify((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.verify((Object[])new Object[]{this.fgItemDaoMock});
        EasyMock.verify((Object[])new Object[]{this.fgServiceMock});
        EasyMock.verify((Object[])new Object[]{this.multishipOptionServiceMock});
        EasyMock.verify((Object[])new Object[]{this.offerTimeZoneProcessorMock});
    }

    public void testApplyOffersToOrder_Order() throws Exception {
        final ThreadLocal<Order> myOrder = new ThreadLocal<Order>();
        EasyMock.expect((Object)this.offerDaoMock.createOrderItemPriceDetailAdjustment()).andAnswer(OfferDataItemProvider.getCreateOrderItemPriceDetailAdjustmentAnswer()).anyTimes();
        CandidateOrderOfferAnswer candidateOrderOfferAnswer = new CandidateOrderOfferAnswer();
        OrderAdjustmentAnswer orderAdjustmentAnswer = new OrderAdjustmentAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createOrderAdjustment()).andAnswer((IAnswer)orderAdjustmentAnswer).atLeastOnce();
        OrderItemPriceDetailAnswer orderItemPriceDetailAnswer = new OrderItemPriceDetailAnswer();
        EasyMock.expect((Object)this.orderItemDaoMock.createOrderItemPriceDetail()).andAnswer((IAnswer)orderItemPriceDetailAnswer).atLeastOnce();
        OrderItemQualifierAnswer orderItemQualifierAnswer = new OrderItemQualifierAnswer();
        EasyMock.expect((Object)this.orderItemDaoMock.createOrderItemQualifier()).andAnswer((IAnswer)orderItemQualifierAnswer).atLeastOnce();
        CandidateItemOfferAnswer candidateItemOfferAnswer = new CandidateItemOfferAnswer();
        OrderItemAdjustmentAnswer orderItemAdjustmentAnswer = new OrderItemAdjustmentAnswer();
        EasyMock.expect((Object)this.fgServiceMock.addItemToFulfillmentGroup((FulfillmentGroupItemRequest)EasyMock.isA(FulfillmentGroupItemRequest.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddItemToFulfillmentGroupAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.removeItem((Long)EasyMock.isA(Long.class), (Long)EasyMock.isA(Long.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getRemoveItemFromOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.save((Order)EasyMock.isA(Order.class), (Boolean)EasyMock.isA(Boolean.class))).andAnswer(OfferDataItemProvider.getSaveOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.findOrderById((Long)EasyMock.isA(Long.class))).andAnswer((IAnswer)new IAnswer<Order>(){

            public Order answer() throws Throwable {
                return (Order)myOrder.get();
            }
        }).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.getAutomaticallyMergeLikeItems()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.orderItemServiceMock.saveOrderItem((OrderItem)EasyMock.isA(OrderItem.class))).andAnswer(OfferDataItemProvider.getSaveOrderItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.save((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class))).andAnswer(OfferDataItemProvider.getSaveFulfillmentGroupItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.multishipOptionServiceMock.findOrderMultishipOptions((Long)EasyMock.isA(Long.class))).andAnswer((IAnswer)new IAnswer<List<OrderMultishipOption>>(){

            public List<OrderMultishipOption> answer() throws Throwable {
                return new ArrayList<OrderMultishipOption>();
            }
        }).anyTimes();
        this.multishipOptionServiceMock.deleteAllOrderMultishipOptions((Order)EasyMock.isA(Order.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.fgServiceMock.collapseToOneFulfillmentGroup((Order)EasyMock.isA(Order.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getSameOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.create()).andAnswer(OfferDataItemProvider.getCreateFulfillmentGroupItemAnswer()).anyTimes();
        this.fgItemDaoMock.delete((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.offerTimeZoneProcessorMock.getTimeZone((Offer)EasyMock.isA(OfferImpl.class))).andReturn((Object)TimeZone.getTimeZone("CST")).anyTimes();
        this.replay();
        Order order = this.dataProvider.createBasicOrder();
        myOrder.set(order);
        List<Offer> offers = this.dataProvider.createOrderBasedOffer("order.subTotal.getAmount()>126", OfferDiscountType.PERCENT_OFF);
        this.offerService.applyOffersToOrder(offers, order);
        int adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(116.95)));
        order = this.dataProvider.createBasicOrder();
        myOrder.set(order);
        offers = this.dataProvider.createOrderBasedOffer("order.subTotal.getAmount()>126", OfferDiscountType.PERCENT_OFF);
        List<Offer> offers2 = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        offers.addAll(offers2);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = this.countItemAdjustments(order);
        int qualifierCount = this.countItemQualifiers(order);
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((qualifierCount == 2 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 0 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicOrder();
        myOrder.set(order);
        OfferRuleImpl orderRule = new OfferRuleImpl();
        orderRule.setMatchRule("order.subTotal.getAmount()>100");
        offers.get(0).getOfferMatchRules().put(OfferRuleType.ORDER.getType(), orderRule);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = this.countItemAdjustments(order);
        qualifierCount = this.countItemQualifiers(order);
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((qualifierCount == 2 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(112.45)));
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().equals((Object)new Money(124.95)));
        order = this.dataProvider.createBasicPromotableOrder().getOrder();
        myOrder.set(order);
        List<Offer> offers3 = this.dataProvider.createOrderBasedOffer("order.subTotal.getAmount()>20", OfferDiscountType.AMOUNT_OFF);
        offers.addAll(offers3);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicPromotableOrder().getOrder();
        myOrder.set(order);
        offers.get(0).setCombinableWithOtherOffers(false);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = this.countItemAdjustments(order);
        qualifierCount = this.countItemQualifiers(order);
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((qualifierCount == 2 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(112.45)));
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().equals((Object)new Money(124.95)));
        order = this.dataProvider.createBasicPromotableOrder().getOrder();
        myOrder.set(order);
        offers.get(0).setTotalitarianOffer(Boolean.valueOf(true));
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = this.countItemAdjustments(order);
        qualifierCount = this.countItemQualifiers(order);
        OfferServiceTest.assertTrue((adjustmentCount == 0 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((qualifierCount == 0 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(116.95)));
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().equals((Object)new Money(129.95)));
        order = this.dataProvider.createBasicPromotableOrder().getOrder();
        myOrder.set(order);
        offers.get(0).setValue(new BigDecimal(".05"));
        offers.get(2).setValue(new BigDecimal(".01"));
        offers.get(2).setDiscountType(OfferDiscountType.PERCENT_OFF);
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = this.countItemAdjustments(order);
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        adjustmentCount = order.getOrderAdjustments().size();
        OfferServiceTest.assertTrue((adjustmentCount == 1 ? 1 : 0) != 0);
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().subtract(order.getOrderAdjustmentsValue()).equals((Object)new Money(124.94)));
        OfferServiceTest.assertTrue((boolean)order.getSubTotal().equals((Object)new Money(124.95)));
        this.verify();
    }

    private int countItemAdjustments(Order order) {
        int adjustmentCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            for (OrderItemPriceDetail detail : item.getOrderItemPriceDetails()) {
                if (detail.getOrderItemPriceDetailAdjustments() == null) continue;
                adjustmentCount += detail.getOrderItemPriceDetailAdjustments().size();
            }
        }
        return adjustmentCount;
    }

    private int countItemQualifiers(Order order) {
        int qualifierCount = 0;
        for (OrderItem item : order.getOrderItems()) {
            for (OrderItemQualifier qualifier : item.getOrderItemQualifiers()) {
                qualifierCount = (int)((long)qualifierCount + qualifier.getQuantity());
            }
        }
        return qualifierCount;
    }

    public void testApplyOffersToOrder_Items() throws Exception {
        final ThreadLocal<Order> myOrder = new ThreadLocal<Order>();
        EasyMock.expect((Object)this.offerDaoMock.createOrderItemPriceDetailAdjustment()).andAnswer(OfferDataItemProvider.getCreateOrderItemPriceDetailAdjustmentAnswer()).anyTimes();
        CandidateItemOfferAnswer answer = new CandidateItemOfferAnswer();
        OrderItemAdjustmentAnswer answer2 = new OrderItemAdjustmentAnswer();
        OrderItemPriceDetailAnswer orderItemPriceDetailAnswer = new OrderItemPriceDetailAnswer();
        EasyMock.expect((Object)this.orderItemDaoMock.createOrderItemPriceDetail()).andAnswer((IAnswer)orderItemPriceDetailAnswer).atLeastOnce();
        OrderItemQualifierAnswer orderItemQualifierAnswer = new OrderItemQualifierAnswer();
        EasyMock.expect((Object)this.orderItemDaoMock.createOrderItemQualifier()).andAnswer((IAnswer)orderItemQualifierAnswer).atLeastOnce();
        EasyMock.expect((Object)this.orderServiceMock.getAutomaticallyMergeLikeItems()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.save((Order)EasyMock.isA(Order.class), (Boolean)EasyMock.isA(Boolean.class))).andAnswer(OfferDataItemProvider.getSaveOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderItemServiceMock.saveOrderItem((OrderItem)EasyMock.isA(OrderItem.class))).andAnswer(OfferDataItemProvider.getSaveOrderItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.save((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class))).andAnswer(OfferDataItemProvider.getSaveFulfillmentGroupItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgServiceMock.addItemToFulfillmentGroup((FulfillmentGroupItemRequest)EasyMock.isA(FulfillmentGroupItemRequest.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddItemToFulfillmentGroupAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.removeItem((Long)EasyMock.isA(Long.class), (Long)EasyMock.isA(Long.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getRemoveItemFromOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.multishipOptionServiceMock.findOrderMultishipOptions((Long)EasyMock.isA(Long.class))).andAnswer((IAnswer)new IAnswer<List<OrderMultishipOption>>(){

            public List<OrderMultishipOption> answer() throws Throwable {
                return new ArrayList<OrderMultishipOption>();
            }
        }).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.findOrderById((Long)EasyMock.isA(Long.class))).andAnswer((IAnswer)new IAnswer<Order>(){

            public Order answer() throws Throwable {
                return (Order)myOrder.get();
            }
        }).anyTimes();
        this.multishipOptionServiceMock.deleteAllOrderMultishipOptions((Order)EasyMock.isA(Order.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.fgServiceMock.collapseToOneFulfillmentGroup((Order)EasyMock.isA(Order.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getSameOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.create()).andAnswer(OfferDataItemProvider.getCreateFulfillmentGroupItemAnswer()).anyTimes();
        this.fgItemDaoMock.delete((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.offerTimeZoneProcessorMock.getTimeZone((Offer)EasyMock.isA(OfferImpl.class))).andReturn((Object)TimeZone.getTimeZone("CST")).anyTimes();
        this.replay();
        Order order = this.dataProvider.createBasicPromotableOrder().getOrder();
        myOrder.set(order);
        List<Offer> offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.offerService.applyOffersToOrder(offers, order);
        int adjustmentCount = this.countItemAdjustments(order);
        OfferServiceTest.assertTrue((adjustmentCount == 2 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicPromotableOrder().getOrder();
        myOrder.set(order);
        offers = this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.offerService.applyOffersToOrder(offers, order);
        adjustmentCount = this.countItemAdjustments(order);
        OfferServiceTest.assertTrue((adjustmentCount == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testBuildOfferListForOrder() throws Exception {
        EasyMock.expect((Object)this.customerOfferDaoMock.readCustomerOffersByCustomer((Customer)EasyMock.isA(Customer.class))).andReturn(new ArrayList());
        EasyMock.expect((Object)this.offerDaoMock.readOffersByAutomaticDeliveryType()).andReturn(this.dataProvider.createCustomerBasedOffer(null, this.dataProvider.yesterday(), this.dataProvider.tomorrow(), OfferDiscountType.PERCENT_OFF));
        this.replay();
        Order order = this.dataProvider.createBasicPromotableOrder().getOrder();
        List offers = this.offerService.buildOfferListForOrder(order);
        OfferServiceTest.assertTrue((offers.size() == 1 ? 1 : 0) != 0);
        this.verify();
    }

    public class OrderItemQualifierAnswer
    implements IAnswer<OrderItemQualifier> {
        public OrderItemQualifier answer() throws Throwable {
            return new OrderItemQualifierImpl();
        }
    }

    public class OrderItemPriceDetailAnswer
    implements IAnswer<OrderItemPriceDetail> {
        public OrderItemPriceDetail answer() throws Throwable {
            return new OrderItemPriceDetailImpl();
        }
    }

    public class OrderAdjustmentAnswer
    implements IAnswer<OrderAdjustment> {
        public OrderAdjustment answer() throws Throwable {
            return new OrderAdjustmentImpl();
        }
    }

    public class CandidateOrderOfferAnswer
    implements IAnswer<CandidateOrderOffer> {
        public CandidateOrderOffer answer() throws Throwable {
            return new CandidateOrderOfferImpl();
        }
    }

    public class OrderItemAdjustmentAnswer
    implements IAnswer<OrderItemAdjustment> {
        public OrderItemAdjustment answer() throws Throwable {
            return new OrderItemAdjustmentImpl();
        }
    }

    public class CandidateItemOfferAnswer
    implements IAnswer<CandidateItemOffer> {
        public CandidateItemOffer answer() throws Throwable {
            return new CandidateItemOfferImpl();
        }
    }
}

