/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryXref;
import org.broadleafcommerce.core.catalog.domain.CategoryXrefPK;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Polymorphism;
import org.hibernate.annotations.PolymorphismType;

@Entity
@Polymorphism(type=PolymorphismType.EXPLICIT)
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CATEGORY_XREF")
@AdminPresentationClass(excludeFromPolymorphism=false)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class CategoryXrefImpl
implements CategoryXref {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    CategoryXrefPK categoryXrefPK = new CategoryXrefPK();
    @Column(name="DISPLAY_ORDER")
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long displayOrder;

    public CategoryXrefPK getCategoryXrefPK() {
        return this.categoryXrefPK;
    }

    public void setCategoryXrefPK(CategoryXrefPK categoryXrefPK) {
        this.categoryXrefPK = categoryXrefPK;
    }

    @Override
    public Long getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public void setDisplayOrder(Long displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Override
    public Category getCategory() {
        return this.categoryXrefPK.getCategory();
    }

    @Override
    public void setCategory(Category category) {
        this.categoryXrefPK.setCategory(category);
    }

    @Override
    public Category getSubCategory() {
        return this.categoryXrefPK.getSubCategory();
    }

    @Override
    public void setSubCategory(Category subCategory) {
        this.categoryXrefPK.setSubCategory(subCategory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategoryXrefImpl)) {
            return false;
        }
        CategoryXrefImpl that = (CategoryXrefImpl)o;
        if (this.categoryXrefPK != null ? !this.categoryXrefPK.equals(that.categoryXrefPK) : that.categoryXrefPK != null) {
            return false;
        }
        return !(this.displayOrder != null ? !this.displayOrder.equals(that.displayOrder) : that.displayOrder != null);
    }

    public int hashCode() {
        int result = this.categoryXrefPK != null ? this.categoryXrefPK.hashCode() : 0;
        result = 31 * result + (this.displayOrder != null ? this.displayOrder.hashCode() : 0);
        return result;
    }
}

