/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.math.BigDecimal;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrencyImpl;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuFee;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.type.SkuFeeType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU_FEE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class SkuFeeImpl
implements SkuFee {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuFeeId")
    @GenericGenerator(name="SkuFeeId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="SkuFeeImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.order.domain.SkuFeeImpl")})
    @Column(name="SKU_FEE_ID")
    protected Long id;
    @Column(name="NAME")
    protected String name;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="AMOUNT", precision=19, scale=5, nullable=false)
    protected BigDecimal amount;
    @Column(name="TAXABLE")
    protected Boolean taxable = Boolean.FALSE;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="EXPRESSION", length=0x7FFFFFFE)
    protected String expression;
    @Column(name="FEE_TYPE")
    @AdminPresentation(fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.catalog.service.type.SkuFeeType")
    protected String feeType = SkuFeeType.FULFILLMENT.getType();
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=SkuImpl.class)
    @JoinTable(name="BLC_SKU_FEE_XREF", joinColumns={@JoinColumn(name="SKU_FEE_ID", referencedColumnName="SKU_FEE_ID", nullable=true)}, inverseJoinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID", nullable=true)})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected List<Sku> skus;
    @ManyToOne(targetEntity=BroadleafCurrencyImpl.class)
    @JoinColumn(name="CURRENCY_CODE")
    @AdminPresentation(friendlyName="TaxDetailImpl_Currency_Code", order=1, group="FixedPriceFulfillmentOptionImpl_Details", prominent=true)
    protected BroadleafCurrency currency;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Money getAmount() {
        return BroadleafCurrencyUtils.getMoney((BigDecimal)this.amount, (BroadleafCurrency)this.getCurrency());
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = Money.toAmount((Money)amount);
    }

    @Override
    public Boolean getTaxable() {
        return this.taxable;
    }

    @Override
    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public SkuFeeType getFeeType() {
        return SkuFeeType.getInstance(this.feeType);
    }

    @Override
    public void setFeeType(SkuFeeType feeType) {
        this.feeType = feeType == null ? null : feeType.getType();
    }

    @Override
    public List<Sku> getSkus() {
        return this.skus;
    }

    @Override
    public void setSkus(List<Sku> skus) {
        this.skus = skus;
    }

    @Override
    public BroadleafCurrency getCurrency() {
        return this.currency;
    }

    @Override
    public void setCurrency(BroadleafCurrency currency) {
        this.currency = currency;
    }
}

