/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import java.util.List;
import java.util.ListIterator;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.dao.OrderDaoExtensionHandler;
import org.broadleafcommerce.core.order.dao.OrderDaoExtensionManager;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.profile.core.dao.CustomerDao;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.stereotype.Repository;

@Repository(value="blOrderDao")
public class OrderDaoImpl
implements OrderDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    @Resource(name="blCustomerDao")
    protected CustomerDao customerDao;
    @Resource(name="blOrderDaoExtensionManager")
    protected OrderDaoExtensionManager extensionManager;

    @Override
    public Order readOrderById(Long orderId) {
        return (Order)this.em.find(OrderImpl.class, (Object)orderId);
    }

    @Override
    public Order save(Order order) {
        Order response = (Order)this.em.merge((Object)order);
        return response;
    }

    @Override
    public void delete(Order salesOrder) {
        if (!this.em.contains((Object)salesOrder)) {
            salesOrder = this.readOrderById(salesOrder.getId());
        }
        this.em.remove((Object)salesOrder);
    }

    @Override
    public List<Order> readOrdersForCustomer(Customer customer, OrderStatus orderStatus) {
        if (orderStatus == null) {
            return this.readOrdersForCustomer(customer.getId());
        }
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_BY_CUSTOMER_ID_AND_STATUS");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("orderStatus", (Object)orderStatus.getType());
        return query.getResultList();
    }

    @Override
    public List<Order> readOrdersForCustomer(Long customerId) {
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        return query.getResultList();
    }

    @Override
    public Order readCartForCustomer(Customer customer) {
        Order order = null;
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_BY_CUSTOMER_ID_AND_NAME_NULL");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("orderStatus", (Object)OrderStatus.IN_PROCESS.getType());
        List temp = query.getResultList();
        if (temp != null && !temp.isEmpty()) {
            order = (Order)temp.get(0);
        }
        return order;
    }

    @Override
    public Order createNewCartForCustomer(Customer customer) {
        Order order = this.create();
        if (customer.getUsername() == null) {
            customer.setUsername(String.valueOf(customer.getId()));
            if (this.customerDao.readCustomerById(customer.getId()) != null) {
                throw new IllegalArgumentException("Attempting to save a customer with an id (" + customer.getId() + ") that already exists in the database. This can occur when legacy customers have been migrated to Broadleaf customers, but the batchStart setting has not been declared for id generation. In such a case, the defaultBatchStart property of IdGenerationDaoImpl (spring id of blIdGenerationDao) should be set to the appropriate start value.");
            }
            customer = this.customerDao.save(customer);
        }
        order.setCustomer(customer);
        order.setEmailAddress(customer.getEmailAddress());
        order.setStatus(OrderStatus.IN_PROCESS);
        if (BroadleafRequestContext.getBroadleafRequestContext() != null) {
            order.setCurrency(BroadleafRequestContext.getBroadleafRequestContext().getBroadleafCurrency());
            order.setLocale(BroadleafRequestContext.getBroadleafRequestContext().getLocale());
        }
        if (this.extensionManager != null) {
            ((OrderDaoExtensionHandler)this.extensionManager.getProxy()).attachAdditionalDataToNewCart(customer, order);
        }
        order = this.save(order);
        return order;
    }

    @Override
    public Order submitOrder(Order cartOrder) {
        cartOrder.setStatus(OrderStatus.SUBMITTED);
        return this.save(cartOrder);
    }

    @Override
    public Order create() {
        Order order = (Order)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.order.domain.Order");
        return order;
    }

    @Override
    public Order readNamedOrderForCustomer(Customer customer, String name) {
        Query query = this.em.createNamedQuery("BC_READ_NAMED_ORDER_FOR_CUSTOMER");
        query.setParameter("customerId", (Object)customer.getId());
        query.setParameter("orderStatus", (Object)OrderStatus.NAMED.getType());
        query.setParameter("orderName", (Object)name);
        List orders = query.getResultList();
        if (BroadleafRequestContext.getBroadleafRequestContext() != null) {
            ListIterator iter = orders.listIterator();
            while (iter.hasNext()) {
                Locale locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale();
                Order order = (Order)iter.next();
                if (locale == null || locale.equals(order.getLocale())) continue;
                iter.remove();
            }
        }
        if (orders != null && !orders.isEmpty() && this.extensionManager != null) {
            ((OrderDaoExtensionHandler)this.extensionManager.getProxy()).applyAdditionalOrderLookupFilter(customer, name, orders);
        }
        return orders == null || orders.isEmpty() ? null : (Order)orders.get(0);
    }

    @Override
    public Order readOrderByOrderNumber(String orderNumber) {
        if (orderNumber == null || "".equals(orderNumber)) {
            return null;
        }
        Query query = this.em.createNamedQuery("BC_READ_ORDER_BY_ORDER_NUMBER");
        query.setParameter("orderNumber", (Object)orderNumber);
        List orders = query.getResultList();
        return orders == null || orders.isEmpty() ? null : (Order)orders.get(0);
    }

    @Override
    public Order updatePrices(Order order) {
        if ((order = (Order)this.em.merge((Object)order)).updatePrices()) {
            order = this.save(order);
        }
        return order;
    }
}

