/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.rule.MvelHelper;
import org.broadleafcommerce.core.catalog.domain.SkuFee;
import org.broadleafcommerce.core.catalog.service.type.SkuFeeType;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.pricing.service.workflow.PricingContext;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class ConsolidateFulfillmentFeesActivity
extends BaseActivity<PricingContext> {
    protected static final Map EXPRESSION_CACHE = Collections.synchronizedMap(new LRUMap(1000));
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;

    @Override
    public PricingContext execute(PricingContext context) throws Exception {
        Order order = context.getSeedData();
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem item : fulfillmentGroup.getFulfillmentGroupItems()) {
                List<SkuFee> fees = null;
                if (item.getOrderItem() instanceof BundleOrderItem) {
                    fees = ((BundleOrderItem)item.getOrderItem()).getSku().getFees();
                } else if (item.getOrderItem() instanceof DiscreteOrderItem) {
                    fees = ((DiscreteOrderItem)item.getOrderItem()).getSku().getFees();
                }
                if (fees == null) continue;
                for (SkuFee fee : fees) {
                    if (!SkuFeeType.FULFILLMENT.equals(fee.getFeeType()) || !this.shouldApplyFeeToFulfillmentGroup(fee, fulfillmentGroup)) continue;
                    FulfillmentGroupFee fulfillmentFee = this.fulfillmentGroupService.createFulfillmentGroupFee();
                    fulfillmentFee.setName(fee.getName());
                    fulfillmentFee.setTaxable(fee.getTaxable());
                    fulfillmentFee.setAmount(fee.getAmount());
                    fulfillmentFee.setFulfillmentGroup(fulfillmentGroup);
                    fulfillmentGroup.addFulfillmentGroupFee(fulfillmentFee);
                }
            }
            if (fulfillmentGroup.getFulfillmentGroupFees().size() <= 0) continue;
            fulfillmentGroup = this.fulfillmentGroupService.save(fulfillmentGroup);
        }
        context.setSeedData(order);
        return context;
    }

    protected boolean shouldApplyFeeToFulfillmentGroup(SkuFee fee, FulfillmentGroup fulfillmentGroup) {
        boolean appliesToFulfillmentGroup = true;
        String feeExpression = fee.getExpression();
        if (!StringUtils.isEmpty((String)feeExpression)) {
            Serializable exp = (Serializable)EXPRESSION_CACHE.get(feeExpression);
            if (exp == null) {
                ParserContext mvelContext = new ParserContext();
                mvelContext.addImport("MVEL", MVEL.class);
                mvelContext.addImport("MvelHelper", MvelHelper.class);
                exp = MVEL.compileExpression((String)feeExpression, (ParserContext)mvelContext);
                EXPRESSION_CACHE.put(feeExpression, exp);
            }
            HashMap<String, FulfillmentGroup> vars = new HashMap<String, FulfillmentGroup>();
            vars.put("fulfillmentGroup", fulfillmentGroup);
            return (Boolean)MVEL.executeExpression((Object)feeExpression, vars);
        }
        return appliesToFulfillmentGroup;
    }
}

