/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryXref;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Polymorphism;
import org.hibernate.annotations.PolymorphismType;

@Entity
@Polymorphism(type=PolymorphismType.EXPLICIT)
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CATEGORY_XREF")
@AdminPresentationClass(excludeFromPolymorphism=false)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class CategoryXrefImpl
implements CategoryXref {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CategoryXrefId")
    @GenericGenerator(name="CategoryXrefId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CategoryXrefImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.CategoryXrefImpl")})
    @Column(name="CATEGORY_XREF_ID")
    protected Long id;
    @ManyToOne(targetEntity=CategoryImpl.class, optional=false)
    @JoinColumn(name="CATEGORY_ID")
    protected Category category = new CategoryImpl();
    @ManyToOne(targetEntity=CategoryImpl.class, optional=false)
    @JoinColumn(name="SUB_CATEGORY_ID")
    protected Category subCategory = new CategoryImpl();
    @Column(name="DISPLAY_ORDER", precision=10, scale=6)
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected BigDecimal displayOrder;

    @Override
    public BigDecimal getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public void setDisplayOrder(BigDecimal displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category category) {
        this.category = category;
    }

    @Override
    public Category getSubCategory() {
        return this.subCategory;
    }

    @Override
    public void setSubCategory(Category subCategory) {
        this.subCategory = subCategory;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategoryXrefImpl)) {
            return false;
        }
        CategoryXrefImpl that = (CategoryXrefImpl)o;
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        return !(this.subCategory != null ? !this.subCategory.equals(that.subCategory) : that.subCategory != null);
    }

    public int hashCode() {
        int result = this.category != null ? this.category.hashCode() : 0;
        result = 31 * result + (this.subCategory != null ? this.subCategory.hashCode() : 0);
        return result;
    }
}

