/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.service.OrderToPaymentRequestDTOService;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.springframework.stereotype.Service;

@Service(value="blOrderToPaymentRequestDTOService")
public class OrderToPaymentRequestDTOServiceImpl
implements OrderToPaymentRequestDTOService {
    public static final String ZERO_TOTAL = "0";
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fgService;

    @Override
    public PaymentRequestDTO translateOrder(Order order) {
        if (order != null) {
            PaymentRequestDTO requestDTO = new PaymentRequestDTO().orderId(order.getId().toString()).orderCurrencyCode(order.getCurrency().getCurrencyCode());
            this.populateCustomerInfo(order, requestDTO);
            this.populateShipTo(order, requestDTO);
            this.populateBillTo(order, requestDTO);
            this.populateTotals(order, requestDTO);
            this.populateDefaultLineItemsAndSubtotal(order, requestDTO);
            return requestDTO;
        }
        return null;
    }

    @Override
    public PaymentRequestDTO translatePaymentTransaction(Money transactionAmount, PaymentTransaction paymentTransaction) {
        PaymentRequestDTO requestDTO = new PaymentRequestDTO().transactionTotal(transactionAmount.getAmount().toPlainString()).orderSubtotal(transactionAmount.getAmount().toPlainString()).shippingTotal(ZERO_TOTAL).taxTotal(ZERO_TOTAL).orderCurrencyCode(paymentTransaction.getOrderPayment().getCurrency().getCurrencyCode()).orderId(paymentTransaction.getOrderPayment().getOrder().getId().toString());
        Map<String, String> additionalFields = paymentTransaction.getAdditionalFields();
        for (String key : additionalFields.keySet()) {
            requestDTO.additionalField(key, (Object)additionalFields.get(key));
        }
        return requestDTO;
    }

    protected void populateTotals(Order order, PaymentRequestDTO requestDTO) {
        String total = ZERO_TOTAL;
        String shippingTotal = ZERO_TOTAL;
        String taxTotal = ZERO_TOTAL;
        if (order.getTotalAfterAppliedPayments() != null) {
            total = order.getTotalAfterAppliedPayments().toString();
        }
        if (order.getTotalShipping() != null) {
            shippingTotal = order.getTotalShipping().toString();
        }
        if (order.getTotalTax() != null) {
            taxTotal = order.getTotalTax().toString();
        }
        requestDTO.transactionTotal(total).shippingTotal(shippingTotal).taxTotal(taxTotal).orderCurrencyCode(order.getCurrency().getCurrencyCode());
    }

    protected void populateCustomerInfo(Order order, PaymentRequestDTO requestDTO) {
        Customer customer = order.getCustomer();
        String phoneNumber = null;
        if (customer.getCustomerPhones() != null && !customer.getCustomerPhones().isEmpty()) {
            for (CustomerPhone phone : customer.getCustomerPhones()) {
                if (!phone.getPhone().isDefault()) continue;
                phoneNumber = phone.getPhone().getPhoneNumber();
            }
        }
        String orderEmail = customer.getEmailAddress() == null ? order.getEmailAddress() : customer.getEmailAddress();
        requestDTO.customer().customerId(customer.getId().toString()).firstName(customer.getFirstName()).lastName(customer.getLastName()).email(orderEmail).phone(phoneNumber);
    }

    protected void populateShipTo(Order order, PaymentRequestDTO requestDTO) {
        FulfillmentGroup defaultFg;
        List<FulfillmentGroup> fgs = order.getFulfillmentGroups();
        if (fgs != null && fgs.size() > 0 && (defaultFg = this.fgService.getFirstShippableFulfillmentGroup(order)) != null && defaultFg.getAddress() != null) {
            Address fgAddress = defaultFg.getAddress();
            String stateAbbr = null;
            String countryAbbr = null;
            String phone = null;
            if (fgAddress.getState() != null) {
                stateAbbr = fgAddress.getState().getAbbreviation();
            }
            if (fgAddress.getCountry() != null) {
                countryAbbr = fgAddress.getCountry().getAbbreviation();
            }
            if (fgAddress.getPhonePrimary() != null) {
                phone = fgAddress.getPhonePrimary().getPhoneNumber();
            }
            requestDTO.shipTo().addressFirstName(fgAddress.getFirstName()).addressLastName(fgAddress.getLastName()).addressCompanyName(fgAddress.getCompanyName()).addressLine1(fgAddress.getAddressLine1()).addressLine2(fgAddress.getAddressLine2()).addressCityLocality(fgAddress.getCity()).addressStateRegion(stateAbbr).addressPostalCode(fgAddress.getPostalCode()).addressCountryCode(countryAbbr).addressPhone(phone).addressEmail(fgAddress.getEmailAddress());
        }
    }

    protected void populateBillTo(Order order, PaymentRequestDTO requestDTO) {
        for (OrderPayment payment : order.getPayments()) {
            if (!payment.isActive() || !PaymentType.CREDIT_CARD.equals((Object)payment.getType())) continue;
            Address billAddress = payment.getBillingAddress();
            String stateAbbr = null;
            String countryAbbr = null;
            String phone = null;
            if (billAddress.getState() != null) {
                stateAbbr = billAddress.getState().getAbbreviation();
            }
            if (billAddress.getCountry() != null) {
                countryAbbr = billAddress.getCountry().getAbbreviation();
            }
            if (billAddress.getPhonePrimary() != null) {
                phone = billAddress.getPhonePrimary().getPhoneNumber();
            }
            requestDTO.billTo().addressFirstName(billAddress.getFirstName()).addressLastName(billAddress.getLastName()).addressCompanyName(billAddress.getCompanyName()).addressLine1(billAddress.getAddressLine1()).addressLine2(billAddress.getAddressLine2()).addressCityLocality(billAddress.getCity()).addressStateRegion(stateAbbr).addressPostalCode(billAddress.getPostalCode()).addressCountryCode(countryAbbr).addressPhone(phone).addressEmail(billAddress.getEmailAddress());
        }
    }

    protected void populateDefaultLineItemsAndSubtotal(Order order, PaymentRequestDTO requestDTO) {
        requestDTO.orderSubtotal(order.getSubTotal().toString());
    }
}

