/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.util.StopWatch;
import org.broadleafcommerce.common.util.TransactionUtils;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuActiveDatesService;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPricingService;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuActiveDateConsiderationContext;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.broadleafcommerce.core.search.dao.FieldDao;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.SolrContext;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrIndexService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

@Service(value="blSolrIndexService")
public class SolrIndexServiceImpl
implements SolrIndexService {
    private static final Log LOG = LogFactory.getLog(SolrIndexServiceImpl.class);
    @Value(value="${solr.index.product.pageSize}")
    protected int pageSize;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blFieldDao")
    protected FieldDao fieldDao;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;
    @Resource(name="blSolrHelperService")
    protected SolrHelperService shs;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;
    @Resource(name="blTransactionManager")
    protected PlatformTransactionManager transactionManager;
    public static String ATTR_MAP = "productAttributes";

    @Override
    public void rebuildIndex() throws ServiceException, IOException {
        LOG.info((Object)"Rebuilding the solr index...");
        StopWatch s = new StopWatch();
        if (SolrContext.isSingleCoreMode()) {
            this.deleteAllDocuments();
        }
        Object[] pack = this.saveState();
        try {
            Long numProducts = this.productDao.readCountAllActiveProducts();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("There are " + numProducts + " total products"));
            }
            int page = 0;
            while ((long)(page * this.pageSize) < numProducts) {
                this.buildIncrementalIndex(page, this.pageSize);
                ++page;
            }
            this.optimizeIndex(SolrContext.getReindexServer());
        }
        catch (ServiceException e) {
            throw e;
        }
        finally {
            this.restoreState(pack);
        }
        this.shs.swapActiveCores();
        if (!SolrContext.isSingleCoreMode()) {
            this.deleteAllDocuments();
        }
        LOG.info((Object)String.format("Finished building index in %s", s.toLapString()));
    }

    protected void deleteAllDocuments() throws ServiceException {
        try {
            String deleteQuery = this.shs.getNamespaceFieldName() + ":(\"" + this.shs.getCurrentNamespace() + "\")";
            LOG.debug((Object)("Deleting by query: " + deleteQuery));
            SolrContext.getReindexServer().deleteByQuery(deleteQuery);
            SolrContext.getReindexServer().commit();
        }
        catch (Exception e) {
            throw new ServiceException("Could not delete documents", (Throwable)e);
        }
    }

    protected void buildIncrementalIndex(int page, int pageSize) throws ServiceException {
        this.buildIncrementalIndex(page, pageSize, true);
    }

    @Override
    public void buildIncrementalIndex(int page, int pageSize, boolean useReindexServer) throws ServiceException {
        TransactionStatus status = TransactionUtils.createTransaction((String)"readProducts", (int)0, (PlatformTransactionManager)this.transactionManager, (boolean)true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Building index - page: [%s], pageSize: [%s]", page, pageSize));
        }
        StopWatch s = new StopWatch();
        try {
            List<Product> products = this.readAllActiveProducts(page, pageSize);
            List<Field> fields = this.fieldDao.readAllProductFields();
            List<Locale> locales = this.getAllLocales();
            ArrayList<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
            for (Product product : products) {
                SolrInputDocument doc = this.buildDocument(product, fields, locales);
                if (doc == null) continue;
                documents.add(doc);
            }
            this.logDocuments(documents);
            if (!CollectionUtils.isEmpty(documents)) {
                SolrServer server = useReindexServer ? SolrContext.getReindexServer() : SolrContext.getServer();
                server.add(documents);
                server.commit();
            }
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)false);
        }
        catch (SolrServerException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        catch (IOException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        catch (RuntimeException e) {
            TransactionUtils.finalizeTransaction((TransactionStatus)status, (PlatformTransactionManager)this.transactionManager, (boolean)true);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Built index - page: [%s], pageSize: [%s] in [%s]", page, pageSize, s.toLapString()));
        }
    }

    protected List<Product> readAllActiveProducts() {
        return this.productDao.readAllActiveProducts();
    }

    protected List<Product> readAllActiveProducts(int page, int pageSize) {
        return this.productDao.readAllActiveProducts(page, pageSize);
    }

    @Override
    public List<Locale> getAllLocales() {
        return this.localeService.findAllLocales();
    }

    @Override
    public SolrInputDocument buildDocument(Product product, List<Field> fields, List<Locale> locales) {
        SolrInputDocument document = new SolrInputDocument();
        this.attachBasicDocumentFields(product, document);
        ArrayList<String> addedProperties = new ArrayList<String>();
        for (Field field : fields) {
            try {
                FieldType facetType;
                if (field.getSearchable().booleanValue()) {
                    List<FieldType> searchableFieldTypes = this.shs.getSearchableFieldTypes(field);
                    for (FieldType sft : searchableFieldTypes) {
                        Map<String, Object> propertyValues = this.getPropertyValues(product, field, sft, locales);
                        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                            String prefix = entry.getKey();
                            prefix = StringUtils.isBlank((CharSequence)prefix) ? prefix : prefix + "_";
                            String solrPropertyName = this.shs.getPropertyNameForFieldSearchable(field, sft, prefix);
                            Object value = entry.getValue();
                            document.addField(solrPropertyName, value);
                            addedProperties.add(solrPropertyName);
                        }
                    }
                }
                if ((facetType = field.getFacetFieldType()) == null) continue;
                Map<String, Object> propertyValues = this.getPropertyValues(product, field, facetType, locales);
                for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
                    String prefix = entry.getKey();
                    prefix = StringUtils.isBlank((CharSequence)prefix) ? prefix : prefix + "_";
                    String solrFacetPropertyName = this.shs.getPropertyNameForFieldFacet(field, prefix);
                    Object value = entry.getValue();
                    if (addedProperties.contains(solrFacetPropertyName)) continue;
                    document.addField(solrFacetPropertyName, value);
                }
            }
            catch (Exception e) {
                LOG.trace((Object)("Could not get value for property[" + field.getQualifiedFieldName() + "] for product id[" + product.getId() + "]"), (Throwable)e);
            }
        }
        return document;
    }

    protected void attachBasicDocumentFields(Product product, SolrInputDocument document) {
        document.addField(this.shs.getNamespaceFieldName(), (Object)this.shs.getCurrentNamespace());
        document.addField(this.shs.getIdFieldName(), (Object)this.shs.getSolrDocumentId(document, product));
        document.addField(this.shs.getProductIdFieldName(), (Object)product.getId());
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).attachAdditionalBasicFields(product, document, this.shs);
        for (CategoryProductXref categoryXref : product.getAllParentCategoryXrefs()) {
            document.addField(this.shs.getExplicitCategoryFieldName(), (Object)this.shs.getCategoryId(categoryXref.getCategory().getId()));
            String categorySortFieldName = this.shs.getCategorySortFieldName(categoryXref.getCategory());
            int index = -1;
            int count = 0;
            for (CategoryProductXref productXref : categoryXref.getCategory().getAllProductXrefs()) {
                if (productXref.getProduct().equals(product)) {
                    index = count;
                    break;
                }
                ++count;
            }
            if (document.getField(categorySortFieldName) != null) continue;
            document.addField(categorySortFieldName, (Object)index);
        }
        HashSet<Category> fullCategoryHierarchy = new HashSet<Category>();
        for (CategoryProductXref categoryXref : product.getAllParentCategoryXrefs()) {
            fullCategoryHierarchy.addAll(categoryXref.getCategory().buildFullCategoryHierarchy(null));
        }
        for (Category category : fullCategoryHierarchy) {
            document.addField(this.shs.getCategoryFieldName(), (Object)this.shs.getCategoryId(category.getId()));
        }
    }

    protected Map<String, Object> getPropertyValues(Product product, Field field, FieldType fieldType, List<Locale> locales) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ExtensionResultStatusType result;
        String propertyName = field.getPropertyName();
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.extensionManager != null && ExtensionResultStatusType.NOT_HANDLED.equals((Object)(result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).addPropertyValues(product, field, fieldType, values, propertyName, locales)))) {
            Object propertyValue;
            if (propertyName.contains(ATTR_MAP)) {
                propertyValue = PropertyUtils.getMappedProperty((Object)product, (String)ATTR_MAP, (String)propertyName.substring(ATTR_MAP.length() + 1));
                if (propertyValue != null) {
                    try {
                        propertyValue = PropertyUtils.getProperty((Object)propertyValue, (String)"value");
                    }
                    catch (NoSuchMethodException e) {}
                }
            } else {
                propertyValue = PropertyUtils.getProperty((Object)product, (String)propertyName);
            }
            values.put("", propertyValue);
        }
        return values;
    }

    protected String convertToMappedProperty(String propertyName, String listPropertyName, String mapPropertyName) {
        String[] splitName = StringUtils.split((String)propertyName, (String)".");
        StringBuilder convertedProperty = new StringBuilder();
        for (int i = 0; i < splitName.length; ++i) {
            if (convertedProperty.length() > 0) {
                convertedProperty.append(".");
            }
            if (splitName[i].equals(listPropertyName)) {
                convertedProperty.append(mapPropertyName).append("(");
                convertedProperty.append(splitName[i + 1]).append(").value");
                ++i;
                continue;
            }
            convertedProperty.append(splitName[i]);
        }
        return convertedProperty.toString();
    }

    @Override
    public Object[] saveState() {
        return new Object[]{BroadleafRequestContext.getBroadleafRequestContext(), SkuPricingConsiderationContext.getSkuPricingConsiderationContext(), SkuPricingConsiderationContext.getSkuPricingService(), SkuActiveDateConsiderationContext.getSkuActiveDatesService()};
    }

    @Override
    public void restoreState(Object[] pack) {
        BroadleafRequestContext.setBroadleafRequestContext((BroadleafRequestContext)((BroadleafRequestContext)pack[0]));
        SkuPricingConsiderationContext.setSkuPricingConsiderationContext((HashMap)pack[1]);
        SkuPricingConsiderationContext.setSkuPricingService((DynamicSkuPricingService)pack[2]);
        SkuActiveDateConsiderationContext.setSkuActiveDatesService((DynamicSkuActiveDatesService)pack[3]);
    }

    @Override
    public void optimizeIndex(SolrServer server) throws ServiceException, IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Optimizing the index...");
            }
            server.optimize();
        }
        catch (SolrServerException e) {
            throw new ServiceException("Could not optimize index", (Throwable)e);
        }
    }

    @Override
    public void logDocuments(Collection<SolrInputDocument> documents) {
        if (LOG.isTraceEnabled()) {
            for (SolrInputDocument document : documents) {
                LOG.trace((Object)document);
            }
        }
    }
}

