/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow.remove;

import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class ValidateRemoveRequestActivity
extends BaseActivity<ProcessContext<CartOperationRequest>> {
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;

    @Override
    public ProcessContext<CartOperationRequest> execute(ProcessContext<CartOperationRequest> context) throws Exception {
        DiscreteOrderItem doi;
        CartOperationRequest request = context.getSeedData();
        OrderItemRequestDTO orderItemRequestDTO = request.getItemRequest();
        if (orderItemRequestDTO.getOrderItemId() == null) {
            throw new IllegalArgumentException("OrderItemId must be specified when removing from order");
        }
        if (request.getOrder() == null) {
            throw new IllegalArgumentException("Order is required when updating item quantities");
        }
        OrderItem orderItem = null;
        for (OrderItem oi : request.getOrder().getOrderItems()) {
            if (!oi.getId().equals(orderItemRequestDTO.getOrderItemId())) continue;
            orderItem = oi;
        }
        if (orderItem == null) {
            throw new IllegalArgumentException("Could not find order item to remove");
        }
        if (orderItem != null && orderItem instanceof DiscreteOrderItem && (doi = (DiscreteOrderItem)orderItem).getBundleOrderItem() != null) {
            throw new IllegalArgumentException("Cannot remove an item that is part of a bundle");
        }
        request.setOrderItem(orderItem);
        return context;
    }
}

