/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_CANDIDATE_FG_OFFER")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class CandidateFulfillmentGroupOfferImpl
implements CandidateFulfillmentGroupOffer {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CandidateFGOfferId")
    @GenericGenerator(name="CandidateFGOfferId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CandidateFulfillmentGroupOfferImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOfferImpl")})
    @Column(name="CANDIDATE_FG_OFFER_ID")
    protected Long id;
    @ManyToOne(targetEntity=FulfillmentGroupImpl.class)
    @JoinColumn(name="FULFILLMENT_GROUP_ID")
    @Index(name="CANDIDATE_FG_INDEX", columnNames={"FULFILLMENT_GROUP_ID"})
    protected FulfillmentGroup fulfillmentGroup;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    @Index(name="CANDIDATE_FGOFFER_INDEX", columnNames={"OFFER_ID"})
    protected Offer offer;
    @Column(name="DISCOUNTED_PRICE", precision=19, scale=5)
    protected BigDecimal discountedPrice;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public void setOffer(Offer offer) {
        this.offer = offer;
        this.discountedPrice = null;
    }

    @Override
    public Money getDiscountedPrice() {
        return this.discountedPrice == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.discountedPrice, (BroadleafCurrency)this.getFulfillmentGroup().getOrder().getCurrency());
    }

    @Override
    public void setDiscountedPrice(Money discountedPrice) {
        this.discountedPrice = discountedPrice.getAmount();
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    @Override
    public void setFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroup = fulfillmentGroup;
        this.discountedPrice = null;
    }

    @Override
    public int getPriority() {
        return this.offer.getPriority();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.discountedPrice == null ? 0 : this.discountedPrice.hashCode());
        result = 31 * result + (this.fulfillmentGroup == null ? 0 : this.fulfillmentGroup.hashCode());
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        CandidateFulfillmentGroupOfferImpl other = (CandidateFulfillmentGroupOfferImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.discountedPrice == null ? other.discountedPrice != null : !this.discountedPrice.equals(other.discountedPrice)) {
            return false;
        }
        if (this.fulfillmentGroup == null ? other.fulfillmentGroup != null : !this.fulfillmentGroup.equals(other.fulfillmentGroup)) {
            return false;
        }
        return !(this.offer == null ? other.offer != null : !this.offer.equals(other.offer));
    }
}

