/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.CoreAdminParams;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.SolrContext;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.stereotype.Service;

@Service(value="blSolrHelperService")
public class SolrHelperServiceImpl
implements SolrHelperService {
    private static final Log LOG = LogFactory.getLog(SolrHelperServiceImpl.class);
    protected static final String GLOBAL_FACET_TAG_FIELD = "a";
    protected static final String DEFAULT_NAMESPACE = "d";
    protected static final String PREFIX_SEPARATOR = "_";
    protected static Locale defaultLocale;
    protected static SolrServer server;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;

    @Override
    public void swapActiveCores() throws ServiceException {
        if (SolrContext.isSingleCoreMode()) {
            LOG.debug((Object)"In single core mode. There are no cores to swap.");
        } else {
            LOG.debug((Object)"Swapping active cores");
            CoreAdminRequest car = new CoreAdminRequest();
            car.setCoreName("primary");
            car.setOtherCoreName("reindex");
            car.setAction(CoreAdminParams.CoreAdminAction.SWAP);
            try {
                SolrContext.getAdminServer().request((SolrRequest)car);
            }
            catch (Exception e) {
                LOG.error((Object)e);
                throw new ServiceException("Unable to swap cores", (Throwable)e);
            }
        }
    }

    @Override
    public String getCurrentNamespace() {
        return DEFAULT_NAMESPACE;
    }

    @Override
    public String getGlobalFacetTagField() {
        return GLOBAL_FACET_TAG_FIELD;
    }

    @Override
    public String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType, String prefix) {
        return prefix + field.getAbbreviation() + PREFIX_SEPARATOR + searchableFieldType.getType();
    }

    @Override
    public String getPropertyNameForFieldFacet(Field field, String prefix) {
        if (field.getFacetFieldType() == null) {
            return null;
        }
        return prefix + field.getAbbreviation() + PREFIX_SEPARATOR + field.getFacetFieldType().getType();
    }

    @Override
    public List<FieldType> getSearchableFieldTypes(Field field) {
        ArrayList<FieldType> typesToConsider = new ArrayList<FieldType>();
        if (CollectionUtils.isNotEmpty(field.getSearchableFieldTypes())) {
            typesToConsider.addAll(field.getSearchableFieldTypes());
        }
        if (CollectionUtils.isEmpty(typesToConsider)) {
            typesToConsider.add(FieldType.TEXT);
        }
        return typesToConsider;
    }

    @Override
    public String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType) {
        ArrayList<String> prefixList = new ArrayList<String>();
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).buildPrefixListForSearchableField(field, searchableFieldType, prefixList);
        String prefix = this.convertPrefixListToString(prefixList);
        return this.getPropertyNameForFieldSearchable(field, searchableFieldType, prefix);
    }

    @Override
    public String getPropertyNameForFieldFacet(Field field) {
        FieldType fieldType = field.getFacetFieldType();
        if (fieldType == null) {
            return null;
        }
        ArrayList<String> prefixList = new ArrayList<String>();
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).buildPrefixListForSearchableFacet(field, prefixList);
        String prefix = this.convertPrefixListToString(prefixList);
        return this.getPropertyNameForFieldFacet(field, prefix);
    }

    protected String convertPrefixListToString(List<String> prefixList) {
        StringBuilder prefixString = new StringBuilder();
        for (String prefix : prefixList) {
            if (prefix == null || prefix.isEmpty()) continue;
            prefixString = prefixString.append(prefix).append(PREFIX_SEPARATOR);
        }
        return prefixString.toString();
    }

    @Override
    public Long getCategoryId(Long tentativeCategoryId) {
        Long[] returnId = new Long[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getCategoryId(tentativeCategoryId, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return tentativeCategoryId;
    }

    @Override
    public Long getProductId(Long tentativeProductId) {
        Long[] returnId = new Long[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getProductId(tentativeProductId, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return tentativeProductId;
    }

    @Override
    public String getSolrDocumentId(SolrInputDocument document, Product product) {
        String[] returnId = new String[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getSolrDocumentId(document, product, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return String.valueOf(product.getId());
    }

    @Override
    public String getNamespaceFieldName() {
        return "namespace";
    }

    @Override
    public String getIdFieldName() {
        return "id";
    }

    @Override
    public String getProductIdFieldName() {
        return "productId";
    }

    @Override
    public String getCategoryFieldName() {
        return "category";
    }

    @Override
    public String getExplicitCategoryFieldName() {
        return "explicitCategory";
    }

    @Override
    public String getCategorySortFieldName(Category category) {
        Long categoryId = this.getCategoryId(category.getId());
        return this.getCategoryFieldName() + PREFIX_SEPARATOR + categoryId + PREFIX_SEPARATOR + "sort_d";
    }

    @Override
    public String getCategorySortFieldName(Long categoryId) {
        categoryId = this.getCategoryId(categoryId);
        return this.getCategoryFieldName() + PREFIX_SEPARATOR + categoryId + PREFIX_SEPARATOR + "sort_d";
    }

    @Override
    public String getLocalePrefix() {
        Locale locale;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            return locale.getLocaleCode() + PREFIX_SEPARATOR;
        }
        return this.getDefaultLocalePrefix();
    }

    @Override
    public String getDefaultLocalePrefix() {
        return this.getDefaultLocale().getLocaleCode() + PREFIX_SEPARATOR;
    }

    @Override
    public Locale getDefaultLocale() {
        if (defaultLocale == null) {
            defaultLocale = this.localeService.findDefaultLocale();
        }
        return defaultLocale;
    }
}

