/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.rating.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.broadleafcommerce.core.rating.domain.RatingDetail;
import org.broadleafcommerce.core.rating.domain.RatingDetailImpl;
import org.broadleafcommerce.core.rating.domain.RatingSummary;
import org.broadleafcommerce.core.rating.domain.RatingSummaryImpl;
import org.broadleafcommerce.core.rating.domain.ReviewDetail;
import org.broadleafcommerce.core.rating.domain.ReviewFeedback;
import org.broadleafcommerce.core.rating.domain.ReviewFeedbackImpl;
import org.broadleafcommerce.core.rating.service.type.ReviewStatusType;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_REVIEW_DETAIL")
public class ReviewDetailImpl
implements ReviewDetail {
    @Id
    @GeneratedValue(generator="ReviewDetailId")
    @GenericGenerator(name="ReviewDetailId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="ReviewDetailImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.rating.domain.ReviewDetailImpl")})
    @Column(name="REVIEW_DETAIL_ID")
    private Long id;
    @ManyToOne(targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    @Index(name="REVIEWDETAIL_CUSTOMER_INDEX", columnNames={"CUSTOMER_ID"})
    protected Customer customer;
    @Column(name="REVIEW_SUBMITTED_DATE", nullable=false)
    protected Date reivewSubmittedDate;
    @Column(name="REVIEW_TEXT", nullable=false)
    protected String reviewText;
    @Column(name="REVIEW_STATUS", nullable=false)
    @Index(name="REVIEWDETAIL_STATUS_INDEX", columnNames={"REVIEW_STATUS"})
    protected String reviewStatus;
    @Column(name="HELPFUL_COUNT", nullable=false)
    protected Integer helpfulCount;
    @Column(name="NOT_HELPFUL_COUNT", nullable=false)
    protected Integer notHelpfulCount;
    @ManyToOne(optional=false, targetEntity=RatingSummaryImpl.class)
    @JoinColumn(name="RATING_SUMMARY_ID")
    @Index(name="REVIEWDETAIL_SUMMARY_INDEX", columnNames={"RATING_SUMMARY_ID"})
    protected RatingSummary ratingSummary;
    @OneToMany(mappedBy="reviewDetail", targetEntity=ReviewFeedbackImpl.class, cascade={CascadeType.ALL})
    protected List<ReviewFeedback> reviewFeedback;
    @OneToOne(targetEntity=RatingDetailImpl.class)
    @JoinColumn(name="RATING_DETAIL_ID")
    @Index(name="REVIEWDETAIL_RATING_INDEX", columnNames={"RATING_DETAIL_ID"})
    protected RatingDetail ratingDetail;

    public ReviewDetailImpl() {
    }

    public ReviewDetailImpl(Customer customer, Date reivewSubmittedDate, RatingDetail ratingDetail, String reviewText, RatingSummary ratingSummary) {
        this.customer = customer;
        this.reivewSubmittedDate = reivewSubmittedDate;
        this.reviewText = reviewText;
        this.ratingSummary = ratingSummary;
        this.reviewFeedback = new ArrayList<ReviewFeedback>();
        this.helpfulCount = 0;
        this.notHelpfulCount = 0;
        this.reviewStatus = ReviewStatusType.PENDING.getType();
        this.ratingDetail = ratingDetail;
    }

    @Override
    public Date getReviewSubmittedDate() {
        return this.reivewSubmittedDate;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getReviewText() {
        return this.reviewText;
    }

    @Override
    public void setReviewText(String reviewText) {
        this.reviewText = reviewText;
    }

    @Override
    public ReviewStatusType getStatus() {
        return new ReviewStatusType(this.reviewStatus);
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public Integer helpfulCount() {
        return this.helpfulCount;
    }

    @Override
    public Integer notHelpfulCount() {
        return this.notHelpfulCount;
    }

    @Override
    public RatingSummary getRatingSummary() {
        return this.ratingSummary;
    }

    @Override
    public RatingDetail getRatingDetail() {
        return this.ratingDetail;
    }

    @Override
    public List<ReviewFeedback> getReviewFeedback() {
        return this.reviewFeedback == null ? new ArrayList() : this.reviewFeedback;
    }
}

