/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.util.DimensionUnitOfMeasureType;
import org.broadleafcommerce.common.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.common.vendor.service.type.ContainerSizeType;

@Embeddable
public class Dimension
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="WIDTH")
    @AdminPresentation(friendlyName="ProductDimension_Product_Width", order=1000, tab="ProductImpl_Shipping_Tab", tabOrder=6000, group="ProductWeight_Shipping", groupOrder=1000)
    protected BigDecimal width;
    @Column(name="HEIGHT")
    @AdminPresentation(friendlyName="ProductDimension_Product_Height", order=2000, tab="ProductImpl_Shipping_Tab", tabOrder=6000, group="ProductWeight_Shipping", groupOrder=1000)
    protected BigDecimal height;
    @Column(name="DEPTH")
    @AdminPresentation(friendlyName="ProductDimension_Product_Depth", order=3000, tab="ProductImpl_Shipping_Tab", tabOrder=6000, group="ProductWeight_Shipping", groupOrder=1000)
    protected BigDecimal depth;
    @Column(name="GIRTH")
    @AdminPresentation(friendlyName="ProductDimension_Product_Girth", order=4000, tab="ProductImpl_Shipping_Tab", tabOrder=6000, group="ProductWeight_Shipping", groupOrder=1000)
    protected BigDecimal girth;
    @Column(name="CONTAINER_SIZE")
    @AdminPresentation(friendlyName="ProductDimension_Product_Container_Size", order=5000, tab="ProductImpl_Shipping_Tab", tabOrder=6000, group="ProductWeight_Shipping", groupOrder=1000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.common.vendor.service.type.ContainerSizeType")
    protected String size;
    @Column(name="CONTAINER_SHAPE")
    @AdminPresentation(friendlyName="ProductDimension_Product_Container_Shape", order=6000, tab="ProductImpl_Shipping_Tab", tabOrder=6000, group="ProductWeight_Shipping", groupOrder=1000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.common.vendor.service.type.ContainerShapeType")
    protected String container;
    @Column(name="DIMENSION_UNIT_OF_MEASURE")
    @AdminPresentation(friendlyName="ProductDimension_Product_Dimension_Units", order=7000, tab="ProductImpl_Shipping_Tab", tabOrder=6000, group="ProductWeight_Shipping", groupOrder=1000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.common.util.DimensionUnitOfMeasureType")
    protected String dimensionUnitOfMeasure;

    public BigDecimal getWidth() {
        return this.width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeight() {
        return this.height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getDepth() {
        return this.depth;
    }

    public void setDepth(BigDecimal depth) {
        this.depth = depth;
    }

    public String getDimensionString() {
        return this.height + "Hx" + this.width + "Wx" + this.depth + "D\"";
    }

    public BigDecimal getGirth() {
        return this.girth;
    }

    public void setGirth(BigDecimal girth) {
        this.girth = girth;
    }

    public ContainerSizeType getSize() {
        return ContainerSizeType.getInstance((String)this.size);
    }

    public void setSize(ContainerSizeType size) {
        if (size != null) {
            this.size = size.getType();
        }
    }

    public ContainerShapeType getContainer() {
        return ContainerShapeType.getInstance((String)this.container);
    }

    public void setContainer(ContainerShapeType container) {
        if (container != null) {
            this.container = container.getType();
        }
    }

    public DimensionUnitOfMeasureType getDimensionUnitOfMeasure() {
        return DimensionUnitOfMeasureType.getInstance((String)this.dimensionUnitOfMeasure);
    }

    public void setDimensionUnitOfMeasure(DimensionUnitOfMeasureType dimensionUnitOfMeasure) {
        if (dimensionUnitOfMeasure != null) {
            this.dimensionUnitOfMeasure = dimensionUnitOfMeasure.getType();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        Dimension dimension = (Dimension)o;
        if (this.container != null ? !this.container.equals(dimension.container) : dimension.container != null) {
            return false;
        }
        if (this.depth != null ? !this.depth.equals(dimension.depth) : dimension.depth != null) {
            return false;
        }
        if (this.dimensionUnitOfMeasure != null ? !this.dimensionUnitOfMeasure.equals(dimension.dimensionUnitOfMeasure) : dimension.dimensionUnitOfMeasure != null) {
            return false;
        }
        if (this.girth != null ? !this.girth.equals(dimension.girth) : dimension.girth != null) {
            return false;
        }
        if (this.height != null ? !this.height.equals(dimension.height) : dimension.height != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(dimension.size) : dimension.size != null) {
            return false;
        }
        return !(this.width != null ? !this.width.equals(dimension.width) : dimension.width != null);
    }

    public int hashCode() {
        int result = this.width != null ? this.width.hashCode() : 0;
        result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
        result = 31 * result + (this.depth != null ? this.depth.hashCode() : 0);
        result = 31 * result + (this.girth != null ? this.girth.hashCode() : 0);
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        result = 31 * result + (this.container != null ? this.container.hashCode() : 0);
        result = 31 * result + (this.dimensionUnitOfMeasure != null ? this.dimensionUnitOfMeasure.hashCode() : 0);
        return result;
    }
}

