/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.dao.OrderPaymentDao;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.OrderPaymentImpl;
import org.broadleafcommerce.core.payment.domain.PaymentLog;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.domain.PaymentTransactionImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blOrderPaymentDao")
public class OrderPaymentDaoImpl
implements OrderPaymentDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public OrderPayment save(OrderPayment payment) {
        return (OrderPayment)this.em.merge((Object)payment);
    }

    @Override
    public PaymentTransaction save(PaymentTransaction transaction) {
        return (PaymentTransaction)this.em.merge((Object)transaction);
    }

    @Override
    public PaymentLog save(PaymentLog log) {
        return (PaymentLog)this.em.merge((Object)log);
    }

    @Override
    public OrderPayment readPaymentById(Long paymentId) {
        return (OrderPayment)this.em.find(OrderPaymentImpl.class, (Object)paymentId);
    }

    @Override
    public List<OrderPayment> readPaymentsForOrder(Order order) {
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_PAYMENTS_BY_ORDER_ID");
        query.setParameter("orderId", (Object)order.getId());
        return query.getResultList();
    }

    @Override
    public OrderPayment create() {
        return (OrderPayment)this.entityConfiguration.createEntityInstance(OrderPayment.class.getName());
    }

    @Override
    public PaymentTransaction createTransaction() {
        return (PaymentTransaction)this.entityConfiguration.createEntityInstance(PaymentTransaction.class.getName(), PaymentTransaction.class);
    }

    @Override
    public PaymentTransaction readTransactionById(Long transactionId) {
        return (PaymentTransaction)this.em.find(PaymentTransactionImpl.class, (Object)transactionId);
    }

    @Override
    public PaymentLog createLog() {
        return (PaymentLog)this.entityConfiguration.createEntityInstance(PaymentLog.class.getName(), PaymentLog.class);
    }

    @Override
    public void delete(OrderPayment paymentInfo) {
        if (!this.em.contains((Object)paymentInfo)) {
            paymentInfo = this.readPaymentById(paymentInfo.getId());
        }
        this.em.remove((Object)paymentInfo);
    }
}

