/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.workflow;

import java.util.Set;
import javax.annotation.Resource;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.OfferAuditService;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.exception.OfferMaxUseExceededException;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class VerifyCustomerMaxOfferUsesActivity
extends BaseActivity<ProcessContext<CheckoutSeed>> {
    @Resource(name="blOfferAuditService")
    protected OfferAuditService offerAuditService;
    @Resource(name="blOfferService")
    protected OfferService offerService;

    @Override
    public ProcessContext<CheckoutSeed> execute(ProcessContext<CheckoutSeed> context) throws Exception {
        Order order = context.getSeedData().getOrder();
        Set<Offer> appliedOffers = this.offerService.getUniqueOffersFromOrder(order);
        for (Offer offer : appliedOffers) {
            Long currentUses;
            if (!offer.isLimitedUsePerCustomer() || (currentUses = this.offerAuditService.countUsesByCustomer(order.getCustomer().getId(), offer.getId())) < offer.getMaxUsesPerCustomer()) continue;
            throw new OfferMaxUseExceededException("The customer has used this offer more than the maximum allowed number of times.");
        }
        for (OfferCode code : order.getAddedOfferCodes()) {
            Long currentCodeUses;
            if (!code.isLimitedUse() || (currentCodeUses = this.offerAuditService.countOfferCodeUses(code.getId())) < (long)code.getMaxUses()) continue;
            throw new OfferMaxUseExceededException("Offer code " + code.getOfferCode() + " with id " + code.getId() + " has been than the maximum allowed number of times.");
        }
        return context;
    }
}

