/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.PaymentAdditionalFieldType;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.AddressDTO;
import org.broadleafcommerce.common.payment.dto.GatewayCustomerDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayCheckoutService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfiguration;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.service.AddressService;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.PhoneService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="blPaymentGatewayCheckoutService")
public class DefaultPaymentGatewayCheckoutService
implements PaymentGatewayCheckoutService {
    private static final Log LOG = LogFactory.getLog(DefaultPaymentGatewayCheckoutService.class);
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderPaymentService")
    protected OrderPaymentService orderPaymentService;
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blAddressService")
    protected AddressService addressService;
    @Resource(name="blStateService")
    protected StateService stateService;
    @Resource(name="blCountryService")
    protected CountryService countryService;
    @Resource(name="blPhoneService")
    protected PhoneService phoneService;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Value(value="${default.payment.gateway.checkout.useGatewayBillingAddress}")
    protected boolean useBillingAddressFromGateway = true;

    public Long applyPaymentToOrder(PaymentResponseDTO responseDTO, PaymentGatewayConfiguration config) {
        GatewayCustomerDTO gatewayCustomer;
        if (!responseDTO.isValid()) {
            throw new IllegalArgumentException("Invalid payment responses cannot be parsed into the order payment domain");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config service cannot be null");
        }
        Long orderId = Long.parseLong(responseDTO.getOrderId());
        Order order = this.orderService.findOrderById(orderId);
        if (!OrderStatus.IN_PROCESS.equals(order.getStatus()) && !OrderStatus.CSR_OWNED.equals(order.getStatus())) {
            throw new IllegalArgumentException("Cannot apply another payment to an Order that is not IN_PROCESS or CSR_OWNED");
        }
        Customer customer = order.getCustomer();
        if (customer.isAnonymous()) {
            gatewayCustomer = responseDTO.getCustomer();
            if (StringUtils.isEmpty((CharSequence)customer.getFirstName()) && gatewayCustomer != null) {
                customer.setFirstName(gatewayCustomer.getFirstName());
            }
            if (StringUtils.isEmpty((CharSequence)customer.getLastName()) && gatewayCustomer != null) {
                customer.setLastName(gatewayCustomer.getLastName());
            }
            if (StringUtils.isEmpty((CharSequence)customer.getEmailAddress()) && gatewayCustomer != null) {
                customer.setEmailAddress(gatewayCustomer.getEmail());
            }
        }
        gatewayCustomer = responseDTO.getCustomer();
        if (order.getEmailAddress() == null && gatewayCustomer != null) {
            order.setEmailAddress(gatewayCustomer.getEmail());
        }
        this.populateShippingInfo(responseDTO, order);
        OrderPayment payment = this.orderPaymentService.create();
        payment.setType(responseDTO.getPaymentType());
        payment.setPaymentGatewayType(responseDTO.getPaymentGatewayType());
        payment.setAmount(responseDTO.getAmount());
        ArrayList<OrderPayment> paymentsToInvalidate = new ArrayList<OrderPayment>();
        Address tempBillingAddress = null;
        if (!config.handlesMultiplePayments()) {
            PaymentGatewayType gateway = config.getGatewayType();
            for (OrderPayment orderPayment : order.getPayments()) {
                if (!PaymentGatewayType.TEMPORARY.equals((Object)orderPayment.getGatewayType()) && (!orderPayment.isFinalPayment() || !payment.isFinalPayment()) && (orderPayment.getGatewayType() == null || !orderPayment.getGatewayType().equals((Object)gateway))) continue;
                paymentsToInvalidate.add(orderPayment);
                if (!PaymentType.CREDIT_CARD.equals((Object)orderPayment.getType()) || !PaymentGatewayType.TEMPORARY.equals((Object)orderPayment.getGatewayType())) continue;
                tempBillingAddress = orderPayment.getBillingAddress();
            }
        }
        for (OrderPayment invalid : paymentsToInvalidate) {
            order.getPayments().remove(invalid);
            this.markPaymentAsInvalid(invalid.getId());
        }
        this.populateBillingInfo(responseDTO, payment, tempBillingAddress);
        PaymentTransaction transaction = this.orderPaymentService.createTransaction();
        transaction.setAmount(responseDTO.getAmount());
        transaction.setRawResponse(responseDTO.getRawResponse());
        transaction.setSuccess(responseDTO.isSuccessful());
        transaction.setType(responseDTO.getPaymentTransactionType());
        for (Map.Entry entry : responseDTO.getResponseMap().entrySet()) {
            transaction.getAdditionalFields().put((String)entry.getKey(), (String)entry.getValue());
        }
        if (PaymentType.CREDIT_CARD.equals((Object)responseDTO.getPaymentType()) && responseDTO.getCreditCard().creditCardPopulated()) {
            transaction.getAdditionalFields().put(PaymentAdditionalFieldType.NAME_ON_CARD.getType(), responseDTO.getCreditCard().getCreditCardHolderName());
            transaction.getAdditionalFields().put(PaymentAdditionalFieldType.CARD_TYPE.getType(), responseDTO.getCreditCard().getCreditCardType());
            transaction.getAdditionalFields().put(PaymentAdditionalFieldType.EXP_DATE.getType(), responseDTO.getCreditCard().getCreditCardExpDate());
            transaction.getAdditionalFields().put(PaymentAdditionalFieldType.LAST_FOUR.getType(), responseDTO.getCreditCard().getCreditCardLastFour());
        }
        payment.setOrder(order);
        transaction.setOrderPayment(payment);
        payment.addTransaction(transaction);
        payment = this.orderPaymentService.save(payment);
        if (transaction.getSuccess().booleanValue()) {
            this.orderService.addPaymentToOrder(order, payment, null);
        } else {
            this.handleUnsuccessfulTransaction(payment);
        }
        return payment.getId();
    }

    protected void populateBillingInfo(PaymentResponseDTO responseDTO, OrderPayment payment, Address tempBillingAddress) {
        Address billingAddress = tempBillingAddress;
        if (responseDTO.getBillTo() != null && this.isUseBillingAddressFromGateway()) {
            billingAddress = this.addressService.create();
            AddressDTO billToDTO = responseDTO.getBillTo();
            billingAddress.setFirstName(billToDTO.getAddressFirstName());
            billingAddress.setLastName(billToDTO.getAddressLastName());
            billingAddress.setAddressLine1(billToDTO.getAddressLine1());
            billingAddress.setAddressLine2(billToDTO.getAddressLine2());
            billingAddress.setCity(billToDTO.getAddressCityLocality());
            State state = null;
            if (billToDTO.getAddressStateRegion() != null) {
                state = this.stateService.findStateByAbbreviation(billToDTO.getAddressStateRegion());
            }
            if (state == null) {
                LOG.warn((Object)("The given state from the response: " + billToDTO.getAddressStateRegion() + " could not be found" + " as a state abbreviation in BLC_STATE"));
            }
            billingAddress.setState(state);
            billingAddress.setPostalCode(billToDTO.getAddressPostalCode());
            Country country = null;
            if (billToDTO.getAddressCountryCode() != null) {
                country = this.countryService.findCountryByAbbreviation(billToDTO.getAddressCountryCode());
            }
            if (country == null) {
                LOG.warn((Object)("The given country from the response: " + billToDTO.getAddressCountryCode() + " could not be found" + " as a country abbreviation in BLC_COUNTRY"));
            }
            billingAddress.setCountry(country);
            if (billToDTO.getAddressPhone() != null) {
                Phone billingPhone = this.phoneService.create();
                billingPhone.setPhoneNumber(billToDTO.getAddressPhone());
                billingAddress.setPhonePrimary(billingPhone);
            }
        }
        payment.setBillingAddress(billingAddress);
    }

    protected void populateShippingInfo(PaymentResponseDTO responseDTO, Order order) {
        FulfillmentGroup shippableFulfillmentGroup = this.fulfillmentGroupService.getFirstShippableFulfillmentGroup(order);
        Address shippingAddress = null;
        if (responseDTO.getShipTo() != null && shippableFulfillmentGroup != null) {
            shippingAddress = this.addressService.create();
            AddressDTO shipToDTO = responseDTO.getShipTo();
            shippingAddress.setFirstName(shipToDTO.getAddressFirstName());
            shippingAddress.setLastName(shipToDTO.getAddressLastName());
            shippingAddress.setAddressLine1(shipToDTO.getAddressLine1());
            shippingAddress.setAddressLine2(shipToDTO.getAddressLine2());
            shippingAddress.setCity(shipToDTO.getAddressCityLocality());
            State state = null;
            if (shipToDTO.getAddressStateRegion() != null) {
                state = this.stateService.findStateByAbbreviation(shipToDTO.getAddressStateRegion());
            }
            if (state == null) {
                LOG.warn((Object)("The given state from the response: " + shipToDTO.getAddressStateRegion() + " could not be found" + " as a state abbreviation in BLC_STATE"));
            }
            shippingAddress.setState(state);
            shippingAddress.setPostalCode(shipToDTO.getAddressPostalCode());
            Country country = null;
            if (shipToDTO.getAddressCountryCode() != null) {
                country = this.countryService.findCountryByAbbreviation(shipToDTO.getAddressCountryCode());
            }
            if (country == null) {
                LOG.warn((Object)("The given country from the response: " + shipToDTO.getAddressCountryCode() + " could not be found" + " as a country abbreviation in BLC_COUNTRY"));
            }
            shippingAddress.setCountry(country);
            if (shipToDTO.getAddressPhone() != null) {
                Phone shippingPhone = this.phoneService.create();
                shippingPhone.setPhoneNumber(shipToDTO.getAddressPhone());
                shippingAddress.setPhonePrimary(shippingPhone);
            }
            if ((shippableFulfillmentGroup = this.fulfillmentGroupService.findFulfillmentGroupById(shippableFulfillmentGroup.getId())) != null) {
                shippableFulfillmentGroup.setAddress(shippingAddress);
                this.fulfillmentGroupService.save(shippableFulfillmentGroup);
            }
        }
    }

    protected void handleUnsuccessfulTransaction(OrderPayment payment) {
        this.markPaymentAsInvalid(payment.getId());
    }

    public void markPaymentAsInvalid(Long orderPaymentId) {
        OrderPayment payment = this.orderPaymentService.readPaymentById(orderPaymentId);
        if (payment == null) {
            throw new IllegalArgumentException("Could not find payment with id " + orderPaymentId);
        }
        payment.setArchived(Character.valueOf('Y'));
        for (PaymentTransaction transaction : payment.getTransactions()) {
            transaction.setArchived(Character.valueOf('Y'));
        }
        this.orderPaymentService.save(payment);
    }

    public String initiateCheckout(Long orderId) throws Exception {
        CheckoutResponse response;
        Order order = this.orderService.findOrderById(orderId, true);
        if (order == null || order instanceof NullOrderImpl) {
            throw new IllegalArgumentException("Could not order with id " + orderId);
        }
        try {
            response = this.checkoutService.performCheckout(order);
        }
        catch (CheckoutException e) {
            throw new Exception((Throwable)((Object)e));
        }
        if (response.getOrder().getOrderNumber() == null) {
            LOG.error((Object)("Order Number for Order ID: " + order.getId() + " is null."));
        }
        return response.getOrder().getOrderNumber();
    }

    public String lookupOrderNumberFromOrderId(PaymentResponseDTO responseDTO) {
        Order order = this.orderService.findOrderById(Long.parseLong(responseDTO.getOrderId()), true);
        if (order == null) {
            throw new IllegalArgumentException("An order with ID " + responseDTO.getOrderId() + " cannot be found for the" + " given payment response.");
        }
        return order.getOrderNumber();
    }

    public boolean isUseBillingAddressFromGateway() {
        return this.useBillingAddressFromGateway;
    }

    public void setUseBillingAddressFromGateway(boolean useBillingAddressFromGateway) {
        this.useBillingAddressFromGateway = useBillingAddressFromGateway;
    }
}

